/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public class ChunkCache
implements IBlockAccess {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private World worldObj;

    public ChunkCache(World world, int i2, int j2, int k2, int l2, int i1, int j1) {
        this.worldObj = world;
        this.chunkX = i2 >> 4;
        this.chunkZ = k2 >> 4;
        int k1 = l2 >> 4;
        int l1 = j1 >> 4;
        this.chunkArray = new Chunk[k1 - this.chunkX + 1][l1 - this.chunkZ + 1];
        for (int i22 = this.chunkX; i22 <= k1; ++i22) {
            for (int j22 = this.chunkZ; j22 <= l1; ++j22) {
                this.chunkArray[i22 - this.chunkX][j22 - this.chunkZ] = world.getChunkFromChunkCoords(i22, j22);
            }
        }
    }

    @Override
    public int getBlockId(int i2, int j2, int k2) {
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        int l2 = (i2 >> 4) - this.chunkX;
        int i1 = (k2 >> 4) - this.chunkZ;
        if (l2 < 0 || l2 >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l2].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[l2][i1];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockID(i2 & 0xF, j2, k2 & 0xF);
    }

    @Override
    public TileEntity getBlockTileEntity(int i2, int j2, int k2) {
        int l2 = (i2 >> 4) - this.chunkX;
        int i1 = (k2 >> 4) - this.chunkZ;
        return this.chunkArray[l2][i1].getChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
    }

    public boolean getBlockLitInteriorSurface(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return true;
        }
        if (j2 < 0) {
            return true;
        }
        if (j2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.worldObj, i2, j2, k2);
    }

    @Override
    public float getBrightness(int i2, int j2, int k2, int l2) {
        int i1 = this.getLightValue(i2, j2, k2);
        if (i1 < l2) {
            i1 = l2;
        }
        return this.worldObj.dimension.worldType.worldProvider.lightBrightnessTable[i1];
    }

    @Override
    public float getLightBrightness(int i2, int j2, int k2) {
        return this.worldObj.dimension.worldType.worldProvider.lightBrightnessTable[this.getLightValue(i2, j2, k2)];
    }

    public int getLightValue(int i2, int j2, int k2) {
        return this.getLightValueExt(i2, j2, k2, true);
    }

    public int getLightValueExt(int i2, int j2, int k2, boolean flag) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i2, j2, k2)) {
            int k1 = this.getLightValueExt(i2, j2 + 1, k2, false);
            int i22 = this.getLightValueExt(i2 + 1, j2, k2, false);
            int j22 = this.getLightValueExt(i2 - 1, j2, k2, false);
            int k22 = this.getLightValueExt(i2, j2, k2 + 1, false);
            int l2 = this.getLightValueExt(i2, j2, k2 - 1, false);
            if (i22 > k1) {
                k1 = i22;
            }
            if (j22 > k1) {
                k1 = j22;
            }
            if (k22 > k1) {
                k1 = k22;
            }
            if (l2 > k1) {
                k1 = l2;
            }
            return k1;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            int i1 = 15 - this.worldObj.skylightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = (i2 >> 4) - this.chunkX;
        int l1 = (k2 >> 4) - this.chunkZ;
        return this.chunkArray[j1][l1].getBlockLightValue(i2 & 0xF, j2, k2 & 0xF, this.worldObj.skylightSubtracted);
    }

    @Override
    public int getBlockMetadata(int i2, int j2, int k2) {
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        int l2 = (i2 >> 4) - this.chunkX;
        int i1 = (k2 >> 4) - this.chunkZ;
        return this.chunkArray[l2][i1].getBlockMetadata(i2 & 0xF, j2, k2 & 0xF);
    }

    @Override
    public Material getBlockMaterial(int i2, int j2, int k2) {
        int l2 = this.getBlockId(i2, j2, k2);
        if (l2 == 0) {
            return Material.air;
        }
        return Block.blocksList[l2].blockMaterial;
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.worldObj.getWorldChunkManager();
    }

    @Override
    public boolean isBlockOpaqueCube(int i2, int j2, int k2) {
        Block block = Block.blocksList[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int i2, int j2, int k2) {
        Block block = Block.blocksList[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.getIsSolid() && block.renderAsNormalBlock();
    }
}

