/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

public class ChunkCoordinates
implements Comparable<ChunkCoordinates> {
    public int x;
    public int y;
    public int z;

    public ChunkCoordinates() {
    }

    public ChunkCoordinates(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public ChunkCoordinates(ChunkCoordinates pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCoordinates)) {
            return false;
        }
        ChunkCoordinates chunkcoordinates = (ChunkCoordinates)obj;
        return this.x == chunkcoordinates.x && this.y == chunkcoordinates.y && this.z == chunkcoordinates.z;
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    public int compareChunkCoordinate(ChunkCoordinates chunkcoordinates) {
        if (this.y == chunkcoordinates.y) {
            if (this.z == chunkcoordinates.z) {
                return this.x - chunkcoordinates.x;
            }
            return this.z - chunkcoordinates.z;
        }
        return this.y - chunkcoordinates.y;
    }

    public double getSqDistanceTo(int i2, int j2, int k2) {
        int l2 = this.x - i2;
        int i1 = this.y - j2;
        int j1 = this.z - k2;
        return Math.sqrt(l2 * l2 + i1 * i1 + j1 * j1);
    }

    @Override
    public int compareTo(ChunkCoordinates o2) {
        return this.compareChunkCoordinate(o2);
    }

    public boolean equals(int x2, int y2, int z2) {
        return this.x == x2 && this.y == y2 && this.z == z2;
    }
}

