/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.World;

public class ChunkProvider
implements IChunkProvider {
    private Set droppedChunksSet = new HashSet();
    private Chunk field_28064_b;
    public IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Map chunkMap = new HashMap();
    private List chunkList = new ArrayList();
    private World field_28066_g;
    private int field_35392_h;

    public ChunkProvider(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.field_28064_b = new EmptyChunk(world, new short[32768], 0, 0);
        this.field_28066_g = world;
        this.chunkLoader = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        return this.chunkMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
    }

    public void func_35391_d(int i2, int j2) {
        ChunkCoordinates chunkcoordinates = this.field_28066_g.getSpawnPoint();
        int k2 = i2 * 16 + 8 - chunkcoordinates.x;
        int l2 = j2 * 16 + 8 - chunkcoordinates.z;
        int c2 = 128;
        if (k2 < -c2 || k2 > c2 || l2 < -c2 || l2 > c2) {
            this.droppedChunksSet.add(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
        }
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        int k2 = ChunkCoordIntPair.chunkXZ2Int(i2, j2);
        this.droppedChunksSet.remove(k2);
        Chunk chunk = (Chunk)this.chunkMap.get(k2);
        if (chunk == null) {
            chunk = this.loadChunkFromFile(i2, j2);
            if (chunk == null) {
                chunk = this.chunkProvider == null ? this.field_28064_b : this.chunkProvider.provideChunk(i2, j2);
            }
            this.chunkMap.put(k2, chunk);
            this.chunkList.add(chunk);
            if (chunk != null) {
                chunk.func_4143_d();
                chunk.onChunkLoad();
            }
            if (!chunk.isTerrainPopulated && this.chunkExists(i2 + 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2);
            }
            if (this.chunkExists(i2 - 1, j2) && !this.provideChunk((int)(i2 - 1), (int)j2).isTerrainPopulated && this.chunkExists(i2 - 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2);
            }
            if (this.chunkExists(i2, j2 - 1) && !this.provideChunk((int)i2, (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 + 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2 - 1);
            }
            if (this.chunkExists(i2 - 1, j2 - 1) && !this.provideChunk((int)(i2 - 1), (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 - 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2 - 1);
            }
        }
        return chunk;
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        Chunk chunk = (Chunk)this.chunkMap.get(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
        if (chunk == null) {
            return this.prepareChunk(i2, j2);
        }
        return chunk;
    }

    private Chunk loadChunkFromFile(int i2, int j2) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.field_28066_g, i2, j2);
            if (chunk != null) {
                chunk.lastSaveTime = this.field_28066_g.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_28063_a(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.field_28066_g, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_28062_b(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.field_28066_g.getWorldTime();
            this.chunkLoader.saveChunk(this.field_28066_g, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
        Chunk chunk = this.provideChunk(i2, j2);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(ichunkprovider, i2, j2);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i2 = 0;
        for (int j2 = 0; j2 < this.chunkList.size(); ++j2) {
            Chunk chunk = (Chunk)this.chunkList.get(j2);
            if (flag && !chunk.neverSave) {
                this.func_28063_a(chunk);
            }
            if (!chunk.needsSaving(flag)) continue;
            this.func_28062_b(chunk);
            chunk.isModified = false;
            if (++i2 != 24 || flag) continue;
            return false;
        }
        if (flag) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        for (int i2 = 0; i2 < 100; ++i2) {
            if (this.droppedChunksSet.isEmpty()) continue;
            Integer integer = (Integer)this.droppedChunksSet.iterator().next();
            Chunk chunk = (Chunk)this.chunkMap.get(integer);
            chunk.onChunkUnload();
            this.func_28062_b(chunk);
            this.func_28063_a(chunk);
            this.droppedChunksSet.remove(integer);
            this.chunkMap.remove(integer);
            this.chunkList.remove(chunk);
        }
        if (!Minecraft.isChunkLoadingDynamic()) {
            for (int j2 = 0; j2 < 10; ++j2) {
                if (this.field_35392_h >= this.chunkList.size()) {
                    this.field_35392_h = 0;
                    break;
                }
                Chunk chunk = (Chunk)this.chunkList.get(this.field_35392_h++);
                EntityPlayer entityplayer = this.field_28066_g.getClosestPlayer((double)(chunk.xPosition << 4) + 8.0, 64.0, (double)(chunk.zPosition << 4) + 8.0, 288.0);
                if (entityplayer != null) continue;
                this.func_35391_d(chunk.xPosition, chunk.zPosition);
            }
        }
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public void unloadAllChunks() {
        this.chunkMap.clear();
        this.chunkList.clear();
        this.droppedChunksSet.clear();
        this.chunkProvider = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "ServerChunkCache: " + this.chunkMap.size() + " Drop: " + this.droppedChunksSet.size();
    }
}

