/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.Packet56RequestChunk;
import net.minecraft.src.World;

public class ChunkProviderClient
implements IChunkProvider {
    private Chunk blankChunk;
    private Map chunkMapping = new HashMap();
    private List field_889_c = new ArrayList();
    private World worldObj;

    public ChunkProviderClient(World world) {
        this.blankChunk = new EmptyChunk(world, new short[256 * net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS], 0, 0);
        this.worldObj = world;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        if (this != null) {
            return true;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        return this.chunkMapping.containsKey(chunkcoordintpair);
    }

    public void func_539_c(int i2, int j2) {
        Chunk chunk = this.provideChunk(i2, j2);
        if (!chunk.func_21167_h()) {
            chunk.onChunkUnload();
        }
        this.chunkMapping.remove(new ChunkCoordIntPair(i2, j2));
        this.field_889_c.remove(chunk);
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        short[] ashort0 = new short[256 * net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS];
        Chunk chunk = new Chunk(this.worldObj, ashort0, i2, j2);
        Arrays.fill(chunk.skylightMap.data, (byte)-1);
        this.chunkMapping.put(chunkcoordintpair, chunk);
        chunk.isChunkLoaded = true;
        return chunk;
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        Chunk chunk = (Chunk)this.chunkMapping.get(chunkcoordintpair);
        if (chunk == null) {
            return this.blankChunk;
        }
        return chunk;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public void checkForMissingChunks() {
        for (Chunk chunk : this.chunkMapping.values()) {
            if (chunk.receivedFromServer) continue;
            if (chunk.ticksUnreceived > 100L) {
                Minecraft.getMinecraft().getSendQueue().addToSendQueue(new Packet56RequestChunk(chunk.xPosition, chunk.zPosition));
                System.out.println("Re-requesting chunk at " + chunk.xPosition + " " + chunk.zPosition);
                chunk.ticksUnreceived = 0L;
            }
            ++chunk.ticksUnreceived;
        }
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
    }

    @Override
    public String makeString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.size();
    }
}

