/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDeadBush;
import net.minecraft.src.WorldGenDungeon;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLabyrinth;
import net.minecraft.src.WorldGenLakes;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenPumpkin;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenReedTall;
import net.minecraft.src.WorldGenRichDirt;
import net.minecraft.src.WorldGenSponge;
import net.minecraft.src.WorldGenTallGrass;
import net.minecraft.src.WorldGenerator;
import net.minecraft.src.WorldType;

public class ChunkProviderGenerateOverworld
implements IChunkProvider {
    protected Random rand;
    protected NoiseGeneratorOctaves field_912_k;
    protected NoiseGeneratorOctaves field_911_l;
    protected NoiseGeneratorOctaves field_910_m;
    protected NoiseGeneratorOctaves beachNoise;
    protected NoiseGeneratorOctaves soilNoise;
    public NoiseGeneratorOctaves field_922_a;
    public NoiseGeneratorOctaves field_921_b;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    public int treeDensityOverride = -1;
    protected World worldObj;
    protected double[] field_4180_q;
    protected double[] sandBeachNoise = new double[256];
    protected double[] gravelBeachNoise = new double[256];
    protected double[] soilThicknessNoise = new double[256];
    protected double[] stoneLayerNoise;
    protected double[] stoneLayerNoiseGranite;
    protected double[] stoneLayerNoiseLimestone;
    protected int heightModifier;
    protected MapGenBase caveGen = new MapGenCaves(false);
    protected BiomeGenBase[] biomesForGeneration;
    protected double[] field_4185_d;
    protected double[] field_4184_e;
    protected double[] field_4183_f;
    protected double[] field_4182_g;
    protected double[] field_4181_h;
    protected int[][] field_914_i = new int[32][32];
    protected double[] generatedTemperatures;
    protected int oceanHeight;
    protected int terrainMaxHeight;
    protected int terrainMiddle;

    public ChunkProviderGenerateOverworld(World world, long l2, int oceanHeight, int terrainMaxHeight, int terrainMiddle) {
        this.worldObj = world;
        this.rand = new Random(l2);
        this.field_912_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_911_l = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_910_m = new NoiseGeneratorOctaves(this.rand, 8);
        this.beachNoise = new NoiseGeneratorOctaves(this.rand, 4);
        this.soilNoise = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_922_a = new NoiseGeneratorOctaves(this.rand, 10);
        this.field_921_b = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.oceanHeight = oceanHeight;
        this.terrainMaxHeight = terrainMaxHeight;
        this.terrainMiddle = terrainMiddle;
        this.heightModifier = 1;
    }

    public int[] generateTerrain(int chunkX, int chunkZ, short[] ashort0) {
        int xzScale = 4;
        int[] heights = new int[256];
        int xSampleSize = xzScale + 1;
        int fullYHeight = (this.terrainMaxHeight - this.terrainMiddle) * 2;
        int yOffset = (fullYHeight - this.terrainMaxHeight) / 8;
        int ySampleSize = this.terrainMaxHeight / 8 + 1;
        int zSampleSize = xzScale + 1;
        this.field_4180_q = this.func_4061_a(this.field_4180_q, chunkX * xzScale, 0, chunkZ * xzScale, xSampleSize, ySampleSize, zSampleSize);
        for (int x2 = 0; x2 < xzScale; ++x2) {
            for (int z2 = 0; z2 < xzScale; ++z2) {
                for (int y2 = 0; y2 < this.terrainMaxHeight / 8; ++y2) {
                    double d2 = 0.125;
                    double d1 = this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d22 = this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d3 = this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d4 = this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d5 = (this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 1 + yOffset)] - d1) * d2;
                    double d6 = (this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 1 + yOffset)] - d22) * d2;
                    double d7 = (this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 1 + yOffset)] - d3) * d2;
                    double d8 = (this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 1 + yOffset)] - d4) * d2;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d22;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d22) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + x2 * 4 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + z2 * 4 << Minecraft.WORLD_HEIGHT_BITS | y2 * 8 + l1;
                            int c2 = Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                int l2 = 0;
                                if (y2 * 8 + l1 < this.oceanHeight) {
                                    l2 = Block.fluidWaterStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                ashort0[j2] = (short)l2;
                                j2 += c2;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d22 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        return heights;
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, short[] ashort0, BiomeGenBase[] abiomegenbase) {
        int oceanBlockHeight = this.oceanHeight;
        double d2 = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves(this.sandBeachNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves(this.gravelBeachNoise, chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, d2, 1.0, d2);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves(this.soilThicknessNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        this.stoneLayerNoise = this.soilNoise.generateNoiseOctaves(this.stoneLayerNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        this.stoneLayerNoiseGranite = this.field_910_m.generateNoiseOctaves(this.stoneLayerNoiseGranite, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        this.stoneLayerNoiseLimestone = this.beachNoise.generateNoiseOctaves(this.stoneLayerNoiseLimestone, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        for (int xIndex = 0; xIndex < 16; ++xIndex) {
            for (int zIndex = 0; zIndex < 16; ++zIndex) {
                BiomeGenBase biomegenbase = abiomegenbase[xIndex + zIndex * 16];
                boolean genSand = this.sandBeachNoise[xIndex + zIndex * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean genGravel = this.gravelBeachNoise[xIndex + zIndex * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int genStone = (int)(this.soilThicknessNoise[xIndex + zIndex * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                boolean flagBasalt = this.stoneLayerNoise[xIndex + zIndex * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flagGranite = this.stoneLayerNoiseGranite[xIndex + zIndex * 16] + this.rand.nextDouble() * 0.2 > 2.0;
                boolean flagLimestone = this.stoneLayerNoiseLimestone[xIndex + zIndex * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int layerControlBasalt = (int)(this.stoneLayerNoise[xIndex + zIndex] + this.rand.nextDouble() * 0.5);
                int layerControlGranite = (int)(this.stoneLayerNoiseGranite[xIndex + zIndex] + this.rand.nextDouble() * 0.5);
                int layerControlLimestone = (int)(this.stoneLayerNoiseLimestone[xIndex + zIndex] + this.rand.nextDouble() * 0.5);
                int j1 = -1;
                short topBlock = biomegenbase.topBlock;
                short fillerBlock = biomegenbase.fillerBlock;
                for (int k1 = this.terrainMaxHeight - 1; k1 >= 0; --k1) {
                    int l1 = (zIndex * 16 + xIndex) * Minecraft.WORLD_HEIGHT_BLOCKS + k1;
                    if (k1 <= this.rand.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    short short3 = ashort0[l1];
                    if (short3 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short3 != Block.stone.blockID) continue;
                    if (j1 == -1) {
                        if (genStone <= 0) {
                            topBlock = 0;
                            fillerBlock = (short)Block.stone.blockID;
                        } else if (k1 >= oceanBlockHeight - 4 && k1 <= oceanBlockHeight + 1) {
                            topBlock = biomegenbase.topBlock;
                            fillerBlock = biomegenbase.fillerBlock;
                            if (genGravel) {
                                topBlock = 0;
                                fillerBlock = (short)Block.gravel.blockID;
                            }
                            if (genSand && biomegenbase != BiomeGenBase.swampland) {
                                topBlock = (short)Block.sand.blockID;
                                fillerBlock = (short)Block.sand.blockID;
                            }
                        }
                        if (k1 < oceanBlockHeight && topBlock == 0) {
                            topBlock = (short)Block.fluidWaterStill.blockID;
                        }
                        j1 = genStone;
                        if (k1 >= oceanBlockHeight - 1) {
                            ashort0[l1] = topBlock;
                            continue;
                        }
                        ashort0[l1] = fillerBlock;
                        continue;
                    }
                    if (j1 <= 0) {
                        if (k1 <= 30 + layerControlBasalt - this.rand.nextInt(3) && k1 >= layerControlBasalt - this.rand.nextInt(3) && flagBasalt) {
                            ashort0[l1] = (short)Block.basalt.blockID;
                            continue;
                        }
                        if (k1 <= Minecraft.WORLD_HEIGHT_BLOCKS + layerControlGranite - this.rand.nextInt(3) && k1 >= 64 + layerControlGranite - this.rand.nextInt(3) && flagGranite) {
                            ashort0[l1] = (short)Block.granite.blockID;
                            continue;
                        }
                        if (k1 > Minecraft.WORLD_HEIGHT_BLOCKS + layerControlLimestone - this.rand.nextInt(3) || k1 < 64 + layerControlLimestone - this.rand.nextInt(3) || !flagLimestone) continue;
                        ashort0[l1] = (short)Block.limestone.blockID;
                        continue;
                    }
                    ashort0[l1] = fillerBlock;
                    if (--j1 != 0 || fillerBlock != Block.sand.blockID) continue;
                    j1 = this.rand.nextInt(8);
                    if (biomegenbase == BiomeGenBase.desert) {
                        j1 += 2;
                    }
                    fillerBlock = (byte)Block.sandstone.blockID;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        return this.provideChunk(i2, j2);
    }

    @Override
    public Chunk provideChunk(int x2, int z2) {
        this.rand.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        Chunk chunk = new Chunk(this.worldObj, ashort0, x2, z2);
        this.biomesForGeneration = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(this.biomesForGeneration, x2 * 16, z2 * 16, 16, 16);
        for (int i2 = 0; i2 < 256; ++i2) {
            chunk.biome[i2] = (byte)this.biomesForGeneration[i2].id;
        }
        int[] heights = this.generateTerrain(x2, z2, ashort0);
        this.replaceBlocksForBiome(x2, z2, ashort0, this.biomesForGeneration);
        this.caveGen.generate(this, this.worldObj, x2, z2, ashort0);
        chunk.func_1024_c();
        return chunk;
    }

    protected double[] func_4061_a(double[] ad2, int i2, int j2, int k2, int l2, int i1, int j1) {
        if (ad2 == null) {
            ad2 = new double[l2 * i1 * j1];
        }
        double d2 = 684.412;
        double d1 = 684.412;
        double[] temperatureArray = this.worldObj.getWorldChunkManager().temperature;
        double[] humidityArray = this.worldObj.getWorldChunkManager().humidity;
        this.field_4182_g = this.field_922_a.func_4109_a(this.field_4182_g, i2, k2, l2, j1, 1.121, 1.121, 0.5);
        this.field_4181_h = this.field_921_b.func_4109_a(this.field_4181_h, i2, k2, l2, j1, 200.0, 200.0, 0.5);
        this.field_4185_d = this.field_910_m.generateNoiseOctaves(this.field_4185_d, i2, j2, k2, l2, i1, j1, d2 / 80.0, d1 / 160.0, d2 / 80.0);
        this.field_4184_e = this.field_912_k.generateNoiseOctaves(this.field_4184_e, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        this.field_4183_f = this.field_911_l.generateNoiseOctaves(this.field_4183_f, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        int k1 = 0;
        int l1 = 0;
        int i22 = 16 / l2;
        for (int j22 = 0; j22 < l2; ++j22) {
            int k22 = j22 * i22 + i22 / 2;
            for (int l22 = 0; l22 < j1; ++l22) {
                double d6;
                int i3 = l22 * i22 + i22 / 2;
                double tempAtBlock = temperatureArray[k22 * 16 + i3];
                double humidAtBlock = humidityArray[k22 * 16 + i3] * tempAtBlock;
                double d4 = 1.0 - humidAtBlock;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.field_4182_g[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.field_4181_h[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) < 0.0) {
                    if ((d6 /= 2.0) < -1.0) {
                        d6 = -1.0;
                    }
                    d6 /= 1.4;
                    d6 /= 2.0;
                    d5 = 0.0;
                } else {
                    if (d6 > 1.0) {
                        d6 = 1.0;
                    }
                    d6 /= 8.0;
                }
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)i1 / 16.0;
                double d7 = (double)i1 / 2.0 + d6 * 4.0;
                ++l1;
                for (int j3 = 0; j3 < i1; ++j3) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 12.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= 4.0;
                    }
                    double d10 = this.field_4184_e[k1] / 512.0;
                    double d11 = this.field_4183_f[k1] / 512.0;
                    double d12 = (this.field_4185_d[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= d9;
                    if (j3 > i1 - 4) {
                        double d13 = (float)(j3 - (i1 - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d13) + -10.0 * d13;
                    }
                    ad2[k1] = d8;
                    ++k1;
                }
            }
        }
        return ad2;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        int i22;
        int j21;
        int j16;
        int l22;
        int i20;
        int i17;
        int i15;
        int j13;
        int k10;
        int j7;
        int i4;
        int i9;
        int j5;
        int k1;
        BlockSand.fallInstantly = true;
        int x2 = chunkX * 16;
        int z2 = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.getWorldChunkManager().getBiomeGenAt(x2 + 16, z2 + 16);
        this.rand.setSeed(this.worldObj.getRandomSeed());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.getRandomSeed());
        double d2 = 0.25;
        int lakeChance = 4;
        if (biomegenbase == BiomeGenBase.swampland) {
            lakeChance = 2;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            lakeChance = 0;
        }
        if (lakeChance != 0 && this.rand.nextInt(lakeChance) == 0) {
            int i1 = x2 + this.rand.nextInt(16) + 8;
            int l4 = this.rand.nextInt(this.terrainMaxHeight);
            int i8 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.fluidWaterStill.blockID).generate(this.worldObj, this.rand, i1, l4, i8);
        }
        if (this.rand.nextInt(8) == 0) {
            int j1 = x2 + this.rand.nextInt(16) + 8;
            int i5 = this.rand.nextInt(this.rand.nextInt(this.terrainMaxHeight - this.terrainMaxHeight / 16) + this.terrainMaxHeight / 16);
            int j8 = z2 + this.rand.nextInt(16) + 8;
            if (i5 < 64 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Block.fluidLavaStill.blockID).generate(this.worldObj, this.rand, j1, i5, j8);
            }
        }
        for (k1 = 0; k1 < 8 * this.heightModifier; ++k1) {
            j5 = x2 + this.rand.nextInt(16) + 8;
            int k8 = this.rand.nextInt(this.terrainMaxHeight);
            int j11 = z2 + this.rand.nextInt(16) + 8;
            if (this.rand.nextInt(2) == 0) {
                new WorldGenDungeon(Block.brickClay.blockID, Block.brickClay.blockID, null).generate(this.worldObj, this.rand, j5, k8, j11);
                continue;
            }
            new WorldGenDungeon(Block.cobbleStone.blockID, Block.cobbleStoneMossy.blockID, null).generate(this.worldObj, this.rand, j5, k8, j11);
        }
        for (k1 = 0; k1 < 1; ++k1) {
            j5 = x2 + this.rand.nextInt(16) + 8;
            int j11 = z2 + this.rand.nextInt(16) + 8;
            int k8 = this.worldObj.getHeightValue(j5, j11) - (this.rand.nextInt(2) + 2);
            if (this.rand.nextInt(5) == 0) {
                k8 -= this.rand.nextInt(10) + 30;
            }
            if (this.rand.nextInt(700) != 0) continue;
            new WorldGenLabyrinth().generate(this.worldObj, this.rand, j5, k8, j11);
        }
        for (int i2 = 0; i2 < 20 * this.heightModifier; ++i2) {
            int k5 = x2 + this.rand.nextInt(16);
            int l8 = this.rand.nextInt(this.terrainMaxHeight);
            int k11 = z2 + this.rand.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.rand, k5, l8, k11);
        }
        if (biomegenbase == BiomeGenBase.outback) {
            int l5 = x2 + this.rand.nextInt(16);
            int l11 = z2 + this.rand.nextInt(16);
            i9 = this.worldObj.getHeightValue(l5, l11);
            new WorldGenRichDirt(20).generate(this.worldObj, this.rand, l5, i9, l11);
        }
        for (int j2 = 0; j2 < 20 * this.heightModifier; ++j2) {
            int l5 = x2 + this.rand.nextInt(16);
            i9 = this.rand.nextInt(this.terrainMaxHeight);
            int l11 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32, false).generate(this.worldObj, this.rand, l5, i9, l11);
        }
        for (int k2 = 0; k2 < 10 * this.heightModifier; ++k2) {
            int i6 = x2 + this.rand.nextInt(16);
            int j9 = this.rand.nextInt(this.terrainMaxHeight);
            int i12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32, false).generate(this.worldObj, this.rand, i6, j9, i12);
        }
        for (int i3 = 0; i3 < 20 * this.heightModifier; ++i3) {
            int j6 = x2 + this.rand.nextInt(16);
            int k9 = this.rand.nextInt(this.terrainMaxHeight);
            int j12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreCoalStone.blockID, 16, true).generate(this.worldObj, this.rand, j6, k9, j12);
        }
        for (int j3 = 0; j3 < 20 * this.heightModifier; ++j3) {
            int k6 = x2 + this.rand.nextInt(16);
            int l9 = this.rand.nextInt(this.terrainMaxHeight / 2);
            int k12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreIronStone.blockID, 8, true).generate(this.worldObj, this.rand, k6, l9, k12);
        }
        for (int k3 = 0; k3 < 2 * this.heightModifier; ++k3) {
            int l6 = x2 + this.rand.nextInt(16);
            int i10 = this.rand.nextInt(this.terrainMaxHeight / 4);
            int l12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreGoldStone.blockID, 8, true).generate(this.worldObj, this.rand, l6, i10, l12);
        }
        for (int l3 = 0; l3 < 8 * this.heightModifier; ++l3) {
            int i7 = x2 + this.rand.nextInt(16);
            int j10 = this.rand.nextInt(this.terrainMaxHeight / 8);
            int i13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreRedstoneStone.blockID, 7, true).generate(this.worldObj, this.rand, i7, j10, i13);
        }
        for (i4 = 0; i4 < this.heightModifier; ++i4) {
            j7 = x2 + this.rand.nextInt(16);
            k10 = this.rand.nextInt(this.terrainMaxHeight / 8);
            j13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreDiamondStone.blockID, 7, true).generate(this.worldObj, this.rand, j7, k10, j13);
        }
        for (i4 = 0; i4 < this.heightModifier; ++i4) {
            j7 = x2 + this.rand.nextInt(16);
            k10 = this.rand.nextInt(this.terrainMaxHeight / 2);
            j13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.mossStone.blockID, 32, true).generate(this.worldObj, this.rand, j7, k10, j13);
        }
        for (int j4 = 0; j4 < this.heightModifier; ++j4) {
            int k7 = x2 + this.rand.nextInt(16);
            int l10 = this.rand.nextInt(this.terrainMaxHeight / 8) + this.rand.nextInt(this.terrainMaxHeight / 8);
            int k13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreLapisStone.blockID, 6, true).generate(this.worldObj, this.rand, k7, l10, k13);
        }
        d2 = 0.5;
        int k4 = (int)((this.mobSpawnerNoise.func_806_a((double)x2 * d2, (double)z2 * d2) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        int treeDensity = 0;
        if (this.treeDensityOverride != -1) {
            treeDensity = this.treeDensityOverride;
        } else {
            if (this.rand.nextInt(10) == 0) {
                ++treeDensity;
            }
            if (biomegenbase == BiomeGenBase.forest) {
                treeDensity += k4 + 5;
            }
            if (biomegenbase == BiomeGenBase.rainforest) {
                treeDensity += k4 + 10;
            }
            if (biomegenbase == BiomeGenBase.seasonalForest) {
                treeDensity += k4 + 2;
            }
            if (biomegenbase == BiomeGenBase.taiga) {
                treeDensity += k4 + 5;
            }
            if (biomegenbase == BiomeGenBase.borealForest) {
                treeDensity += k4 + 3;
            }
            if (biomegenbase == BiomeGenBase.desert) {
                treeDensity += k4 + 1;
            }
            if (biomegenbase == BiomeGenBase.tundra) {
                treeDensity -= 20;
            }
            if (biomegenbase == BiomeGenBase.plains) {
                treeDensity -= 20;
            }
            if (biomegenbase == BiomeGenBase.swampland) {
                treeDensity += k4 + 4;
            }
        }
        for (int i11 = 0; i11 < treeDensity; ++i11) {
            int l13 = x2 + this.rand.nextInt(16) + 8;
            int j14 = z2 + this.rand.nextInt(16) + 8;
            WorldGenerator worldgenerator = biomegenbase.getRandomWorldGenForTrees(this.rand);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.worldObj, this.rand, l13, this.worldObj.getHeightValue(l13, j14), j14);
        }
        int byteReeds = 0;
        if (biomegenbase == BiomeGenBase.rainforest) {
            byteReeds = 1;
        }
        for (int i11 = 0; i11 < byteReeds; ++i11) {
            int i18 = x2 + this.rand.nextInt(16) + 8;
            int i23 = z2 + this.rand.nextInt(16) + 8;
            int i21 = this.worldObj.getHeightValue(i18, i23);
            new WorldGenReedTall().generate(this.worldObj, this.rand, i18, i21, i23);
        }
        int byteMeadow = 0;
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            byteMeadow = 1;
        }
        if (biomegenbase == BiomeGenBase.meadow) {
            byteMeadow = 2;
        }
        if (biomegenbase == BiomeGenBase.borealForest) {
            byteMeadow = 2;
        }
        if (biomegenbase == BiomeGenBase.shrubland) {
            byteMeadow = 1;
        }
        for (int l14 = 0; l14 < byteMeadow; ++l14) {
            int blockId = Block.flowerYellow.blockID;
            if (this.rand.nextInt(3) != 0) {
                blockId = Block.flowerRed.blockID;
            }
            int l19 = x2 + this.rand.nextInt(16) + 8;
            int k22 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j24 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(blockId).generate(this.worldObj, this.rand, l19, k22, j24);
        }
        int byte0 = 0;
        if (biomegenbase == BiomeGenBase.forest) {
            byte0 = 2;
        }
        if (biomegenbase == BiomeGenBase.swampland) {
            byte0 = 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            byte0 = 2;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            byte0 = 3;
        }
        for (int i14 = 0; i14 < byte0; ++i14) {
            int k14 = x2 + this.rand.nextInt(16) + 8;
            int l16 = this.rand.nextInt(this.terrainMaxHeight);
            int k19 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerYellow.blockID).generate(this.worldObj, this.rand, k14, l16, k19);
        }
        int byte1 = 0;
        if (biomegenbase == BiomeGenBase.forest) {
            byte1 = 2;
        }
        if (biomegenbase == BiomeGenBase.meadow) {
            byte1 = 2;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            byte1 = 10;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            byte1 = 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            byte1 = 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            byte1 = 1;
        }
        if (biomegenbase == BiomeGenBase.borealForest) {
            byte1 = 5;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            byte1 = 10;
        }
        if (biomegenbase == BiomeGenBase.swampland) {
            byte1 = 4;
        }
        if (biomegenbase == BiomeGenBase.shrubland) {
            byte1 = 2;
        }
        for (int l14 = 0; l14 < byte1; ++l14) {
            int type = Block.tallgrass.blockID;
            if ((biomegenbase == BiomeGenBase.rainforest || biomegenbase == BiomeGenBase.swampland || biomegenbase == BiomeGenBase.borealForest || biomegenbase == BiomeGenBase.taiga) && this.rand.nextInt(3) != 0) {
                type = Block.tallgrassFern.blockID;
            }
            int l19 = x2 + this.rand.nextInt(16) + 8;
            int k22 = this.rand.nextInt(this.terrainMaxHeight);
            int j24 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(type).generate(this.worldObj, this.rand, l19, k22, j24);
        }
        byte1 = 0;
        if (biomegenbase == BiomeGenBase.outback) {
            byte1 = 2;
        }
        for (i15 = 0; i15 < byte1; ++i15) {
            i17 = x2 + this.rand.nextInt(16) + 8;
            i20 = this.rand.nextInt(this.terrainMaxHeight);
            l22 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(Block.spinifex.blockID).generate(this.worldObj, this.rand, i17, i20, l22);
        }
        byte1 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            byte1 = 2;
        }
        for (i15 = 0; i15 < byte1; ++i15) {
            i17 = x2 + this.rand.nextInt(16) + 8;
            i20 = this.rand.nextInt(this.terrainMaxHeight);
            l22 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenDeadBush(Block.deadbush.blockID).generate(this.worldObj, this.rand, i17, i20, l22);
        }
        if (this.rand.nextInt(2) == 0) {
            int j15 = x2 + this.rand.nextInt(16) + 8;
            int j17 = this.rand.nextInt(this.terrainMaxHeight);
            int j20 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerRed.blockID).generate(this.worldObj, this.rand, j15, j17, j20);
        }
        if (this.rand.nextInt(4) == 0) {
            int k15 = x2 + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(this.terrainMaxHeight);
            int k20 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, k15, k17, k20);
        }
        if (this.rand.nextInt(8) == 0) {
            int l15 = x2 + this.rand.nextInt(16) + 8;
            int l17 = this.rand.nextInt(this.terrainMaxHeight);
            int l20 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, l15, l17, l20);
        }
        if (this.rand.nextInt(5) == 0) {
            int i18 = x2 + this.rand.nextInt(16) + 8;
            int i23 = z2 + this.rand.nextInt(16) + 8;
            int i21 = this.worldObj.getHeightValue(i18, i23);
            new WorldGenReed().generate(this.worldObj, this.rand, i18, i21, i23);
        }
        if (this.rand.nextInt(128) == 0) {
            j16 = x2 + this.rand.nextInt(16) + 8;
            j21 = z2 + this.rand.nextInt(16) + 8;
            i22 = this.worldObj.getHeightValue(j16, j21);
            new WorldGenPumpkin().generate(this.worldObj, this.rand, j16, i22, j21);
        }
        if (this.rand.nextInt(64) == 0) {
            j16 = x2 + this.rand.nextInt(16) + 8;
            j21 = z2 + this.rand.nextInt(16) + 8;
            i22 = this.worldObj.getHeightValue(j16, j21);
            new WorldGenSponge().generate(this.worldObj, this.rand, j16, i22, j21);
        }
        int k16 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            k16 += 10;
        }
        for (int k18 = 0; k18 < k16; ++k18) {
            int k21 = x2 + this.rand.nextInt(16) + 8;
            int j23 = this.rand.nextInt(this.terrainMaxHeight);
            int k24 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.rand, k21, j23, k24);
        }
        for (int l18 = 0; l18 < 50; ++l18) {
            int l21 = x2 + this.rand.nextInt(16) + 8;
            int k23 = this.rand.nextInt(this.rand.nextInt(this.terrainMaxHeight - this.terrainMaxHeight / 16) + this.terrainMaxHeight / 16);
            int l24 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidWaterFlowing.blockID).generate(this.worldObj, this.rand, l21, k23, l24);
        }
        for (int i19 = 0; i19 < 20; ++i19) {
            i22 = x2 + this.rand.nextInt(16) + 8;
            int l23 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(this.terrainMaxHeight - this.terrainMaxHeight / 8) + this.terrainMaxHeight / 16) + this.terrainMaxHeight / 16);
            int i25 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaFlowing.blockID).generate(this.worldObj, this.rand, i22, l23, i25);
        }
        this.generatedTemperatures = this.worldObj.getWorldChunkManager().getTemperatures(this.generatedTemperatures, x2 + 8, z2 + 8, 16, 16);
        for (int j19 = x2 + 8; j19 < x2 + 8 + 16; ++j19) {
            for (int j22 = z2 + 8; j22 < z2 + 8 + 16; ++j22) {
                if (this.worldObj.getCurrentWeather() != null) {
                    this.worldObj.getCurrentWeather().doEnvironmentGenerate(this.worldObj, j19, j22);
                }
                BiomeGenBase biome = this.worldObj.getWorldChunkManager().getBiomeGenAt(j19, j22);
                int k25 = this.worldObj.getHeightValue(j19, j22);
                if ((biome.hasSurfaceSnow() || this.worldObj.dimension.worldType == WorldType.overworldWinter) && k25 > 0 && k25 < Minecraft.WORLD_HEIGHT_BLOCKS && this.worldObj.isAirBlock(j19, k25, j22) && this.worldObj.getBlockMaterial(j19, k25 - 1, j22).getIsSolid()) {
                    this.worldObj.setBlockWithNotify(j19, k25, j22, Block.layerSnow.blockID);
                }
                if (!biome.hasSurfaceSnow() && this.worldObj.dimension.worldType != WorldType.overworldWinter || this.worldObj.getBlockId(j19, this.oceanHeight - 1, j22) != Block.fluidWaterStill.blockID && this.worldObj.getBlockId(j19, this.oceanHeight - 1, j22) != Block.fluidWaterFlowing.blockID) continue;
                this.worldObj.setBlockWithNotify(j19, this.oceanHeight - 1, j22, Block.ice.blockID);
            }
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public void unloadAllChunks() {
    }
}

