/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCavesHell;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenFire;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenGlowStone1;
import net.minecraft.src.WorldGenGlowStone2;
import net.minecraft.src.WorldGenHellLava;
import net.minecraft.src.WorldGenMinable;

public class ChunkProviderHell
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves field_4169_i;
    private NoiseGeneratorOctaves field_4168_j;
    private NoiseGeneratorOctaves field_4167_k;
    private NoiseGeneratorOctaves field_4166_l;
    private NoiseGeneratorOctaves field_4165_m;
    public NoiseGeneratorOctaves field_4177_a;
    public NoiseGeneratorOctaves field_4176_b;
    private World worldObj;
    private double[] field_4163_o;
    private double[] field_4162_p = new double[256];
    private double[] field_4161_q = new double[256];
    private double[] field_4160_r = new double[256];
    private MapGenBase field_4159_s = new MapGenCavesHell();
    double[] field_4175_c;
    double[] field_4174_d;
    double[] field_4173_e;
    double[] field_4172_f;
    double[] field_4171_g;

    public ChunkProviderHell(World world, long l2) {
        this.worldObj = world;
        this.hellRNG = new Random(l2);
        this.field_4169_i = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4168_j = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4167_k = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.field_4166_l = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4165_m = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4177_a = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.field_4176_b = new NoiseGeneratorOctaves(this.hellRNG, 16);
    }

    public void func_4059_a(int i2, int j2, short[] ashort0) {
        int byte0 = 4;
        int byte1 = 32;
        int k2 = byte0 + 1;
        int byte2 = 17;
        int yOffset = 128;
        int l2 = byte0 + 1;
        this.field_4163_o = this.func_4057_a(this.field_4163_o, i2 * byte0, 0, j2 * byte0, k2, byte2, l2);
        for (int i1 = 0; i1 < byte0; ++i1) {
            for (int j1 = 0; j1 < byte0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d2 = 0.125;
                    double d1 = this.field_4163_o[((i1 + 0) * l2 + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d22 = this.field_4163_o[((i1 + 0) * l2 + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.field_4163_o[((i1 + 1) * l2 + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.field_4163_o[((i1 + 1) * l2 + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.field_4163_o[((i1 + 0) * l2 + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d2;
                    double d6 = (this.field_4163_o[((i1 + 0) * l2 + (j1 + 1)) * byte2 + (k1 + 1)] - d22) * d2;
                    double d7 = (this.field_4163_o[((i1 + 1) * l2 + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d2;
                    double d8 = (this.field_4163_o[((i1 + 1) * l2 + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d2;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d22;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d22) * d9;
                        for (int i22 = 0; i22 < 4; ++i22) {
                            int j22 = i22 + i1 * 4 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + j1 * 4 << Minecraft.WORLD_HEIGHT_BITS | k1 * 8 + l1 + yOffset;
                            char c2 = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k22 = 0; k22 < 4; ++k22) {
                                int l22 = 0;
                                if (k1 * 8 + l1 < byte1) {
                                    l22 = Block.fluidLavaStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l22 = Block.netherrack.blockID;
                                }
                                ashort0[j22] = (short)l22;
                                j22 += c2;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d22 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_4058_b(int i2, int j2, short[] ashort0) {
        int byte0 = 64;
        double d2 = 0.03125;
        this.field_4162_p = this.field_4166_l.generateNoiseOctaves(this.field_4162_p, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.field_4161_q = this.field_4166_l.generateNoiseOctaves(this.field_4161_q, i2 * 16, 109.0134, j2 * 16, 16, 1, 16, d2, 1.0, d2);
        this.field_4160_r = this.field_4165_m.generateNoiseOctaves(this.field_4160_r, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                boolean flag = this.field_4162_p[k2 + l2 * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.field_4161_q[k2 + l2 * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.field_4160_r[k2 + l2 * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                short byte1 = (short)Block.netherrack.blockID;
                short byte2 = (short)Block.netherrack.blockID;
                for (int k1 = 127; k1 >= 0; --k1) {
                    short short3;
                    int l1 = (l2 * 16 + k2) * Minecraft.WORLD_HEIGHT_BLOCKS + k1 + 128;
                    if (k1 >= 127 - this.hellRNG.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    if (k1 <= 0 + this.hellRNG.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    if (k1 == 0 || k1 == 127) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                    }
                    if ((short3 = ashort0[l1]) == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short3 != Block.netherrack.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            byte1 = 0;
                            byte2 = (short)Block.netherrack.blockID;
                        } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                            byte1 = (short)Block.netherrack.blockID;
                            byte2 = (short)Block.netherrack.blockID;
                            if (flag1) {
                                byte1 = (short)Block.gravel.blockID;
                            }
                            if (flag1) {
                                byte2 = (short)Block.netherrack.blockID;
                            }
                            if (flag) {
                                byte1 = (short)Block.soulsand.blockID;
                            }
                            if (flag) {
                                byte2 = (short)Block.soulsand.blockID;
                            }
                        }
                        if (k1 < byte0 && byte1 == 0) {
                            byte1 = (short)Block.fluidLavaStill.blockID;
                        }
                        j1 = i1;
                        if (k1 >= byte0 - 1) {
                            ashort0[l1] = byte1;
                            continue;
                        }
                        ashort0[l1] = byte2;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    ashort0[l1] = byte2;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        return this.provideChunk(i2, j2);
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        this.hellRNG.setSeed((long)i2 * 341873128712L + (long)j2 * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        this.func_4059_a(i2, j2, ashort0);
        this.func_4058_b(i2, j2, ashort0);
        this.field_4159_s.generate(this, this.worldObj, i2, j2, ashort0);
        Chunk chunk = new Chunk(this.worldObj, ashort0, i2, j2);
        return chunk;
    }

    private double[] func_4057_a(double[] ad2, int i2, int j2, int k2, int l2, int i1, int j1) {
        if (ad2 == null) {
            ad2 = new double[l2 * i1 * j1];
        }
        double d2 = 684.412;
        double d1 = 2053.236;
        this.field_4172_f = this.field_4177_a.generateNoiseOctaves(this.field_4172_f, i2, j2, k2, l2, 1, j1, 1.0, 0.0, 1.0);
        this.field_4171_g = this.field_4176_b.generateNoiseOctaves(this.field_4171_g, i2, j2, k2, l2, 1, j1, 100.0, 0.0, 100.0);
        this.field_4175_c = this.field_4167_k.generateNoiseOctaves(this.field_4175_c, i2, j2, k2, l2, i1, j1, d2 / 80.0, d1 / 60.0, d2 / 80.0);
        this.field_4174_d = this.field_4169_i.generateNoiseOctaves(this.field_4174_d, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        this.field_4173_e = this.field_4168_j.generateNoiseOctaves(this.field_4173_e, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        int k1 = 0;
        int l1 = 0;
        double[] ad1 = new double[i1];
        for (int i22 = 0; i22 < i1; ++i22) {
            ad1[i22] = Math.cos((double)i22 * Math.PI * 6.0 / (double)i1) * 2.0;
            double d22 = i22;
            if (i22 > i1 / 2) {
                d22 = i1 - 1 - i22;
            }
            if (!(d22 < 4.0)) continue;
            d22 = 4.0 - d22;
            int n2 = i22;
            ad1[n2] = ad1[n2] - d22 * d22 * d22 * 10.0;
        }
        for (int j22 = 0; j22 < l2; ++j22) {
            for (int k22 = 0; k22 < j1; ++k22) {
                double d3 = (this.field_4172_f[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.field_4171_g[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)i1 / 16.0;
                ++l1;
                for (int l22 = 0; l22 < i1; ++l22) {
                    double d6 = 0.0;
                    double d7 = ad1[l22];
                    double d8 = this.field_4174_d[k1] / 512.0;
                    double d9 = this.field_4173_e[k1] / 512.0;
                    double d10 = (this.field_4175_c[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (l22 > i1 - 4) {
                        double d11 = (float)(l22 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)l22 < d4) {
                        double d12 = (d4 - (double)l22) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    ad2[k1] = d6;
                    ++k1;
                }
            }
        }
        return ad2;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
        BlockSand.fallInstantly = true;
        int k2 = i2 * 16;
        int l2 = j2 * 16;
        for (int i1 = 0; i1 < 8; ++i1) {
            int k1 = k2 + this.hellRNG.nextInt(16) + 8;
            int i3 = this.hellRNG.nextInt(120) + 4 + 128;
            int k4 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenHellLava(Block.fluidLavaFlowing.blockID).generate(this.worldObj, this.hellRNG, k1, i3, k4);
        }
        for (int i22 = 0; i22 < 10; ++i22) {
            int k3 = k2 + this.hellRNG.nextInt(16);
            int i5 = this.hellRNG.nextInt(120) + 128;
            int j6 = l2 + this.hellRNG.nextInt(16);
            new WorldGenMinable(Block.oreNethercoalNetherrack.blockID, 16, false).generate(this.worldObj, this.hellRNG, k3, i5, j6);
        }
        int j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        for (int l1 = 0; l1 < j1; ++l1) {
            int j3 = k2 + this.hellRNG.nextInt(16) + 8;
            int l4 = this.hellRNG.nextInt(120) + 4 + 128;
            int i6 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenFire().generate(this.worldObj, this.hellRNG, j3, l4, i6);
        }
        j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        for (int i23 = 0; i23 < j1; ++i23) {
            int k3 = k2 + this.hellRNG.nextInt(16) + 8;
            int i5 = this.hellRNG.nextInt(120) + 4 + 128;
            int j6 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone1().generate(this.worldObj, this.hellRNG, k3, i5, j6);
        }
        for (int j22 = 0; j22 < 10; ++j22) {
            int l3 = k2 + this.hellRNG.nextInt(16) + 8;
            int j5 = this.hellRNG.nextInt(128) + 128;
            int k6 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone2().generate(this.worldObj, this.hellRNG, l3, j5, k6);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int k22 = k2 + this.hellRNG.nextInt(16) + 8;
            int i4 = this.hellRNG.nextInt(128) + 128;
            int k5 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.hellRNG, k22, i4, k5);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int l22 = k2 + this.hellRNG.nextInt(16) + 8;
            int j4 = this.hellRNG.nextInt(128) + 128;
            int l5 = l2 + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.hellRNG, l22, j4, l5);
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "HellRandomLevelSource";
    }

    @Override
    public void checkForMissingChunks() {
    }
}

