/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import net.minecraft.src.Chunk;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.World;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk blankChunk;
    public IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks = new Chunk[1024];
    private World worldObj;
    int lastQueriedChunkXPos = -999999999;
    int lastQueriedChunkZPos = -999999999;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderLoadOrGenerate(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.blankChunk = new EmptyChunk(world, new short[32768], 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    public void setCurrentChunkOver(int i2, int j2) {
        this.curChunkX = i2;
        this.curChunkY = j2;
    }

    public boolean canChunkExist(int i2, int j2) {
        int byte0 = 15;
        return i2 >= this.curChunkX - byte0 && j2 >= this.curChunkY - byte0 && i2 <= this.curChunkX + byte0 && j2 <= this.curChunkY + byte0;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        if (!this.canChunkExist(i2, j2)) {
            return false;
        }
        if (i2 == this.lastQueriedChunkXPos && j2 == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k2 = i2 & 0x1F;
        int l2 = j2 & 0x1F;
        int i1 = k2 + l2 * 32;
        return this.chunks[i1] != null && (this.chunks[i1] == this.blankChunk || this.chunks[i1].isAtLocation(i2, j2));
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        return this.provideChunk(i2, j2);
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        if (i2 == this.lastQueriedChunkXPos && j2 == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(i2, j2)) {
            return this.blankChunk;
        }
        int k2 = i2 & 0x1F;
        int l2 = j2 & 0x1F;
        int i1 = k2 + l2 * 32;
        if (!this.chunkExists(i2, j2)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkUnload();
                this.saveChunk(this.chunks[i1]);
                this.saveExtraChunkData(this.chunks[i1]);
            }
            if ((chunk = this.func_542_c(i2, j2)) == null) {
                if (this.chunkProvider == null) {
                    chunk = this.blankChunk;
                } else {
                    chunk = this.chunkProvider.provideChunk(i2, j2);
                    chunk.func_25124_i();
                }
            }
            this.chunks[i1] = chunk;
            chunk.func_4143_d();
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.chunkExists(i2 + 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2);
            }
            if (this.chunkExists(i2 - 1, j2) && !this.provideChunk((int)(i2 - 1), (int)j2).isTerrainPopulated && this.chunkExists(i2 - 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2);
            }
            if (this.chunkExists(i2, j2 - 1) && !this.provideChunk((int)i2, (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 + 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2 - 1);
            }
            if (this.chunkExists(i2 - 1, j2 - 1) && !this.provideChunk((int)(i2 - 1), (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 - 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2 - 1);
            }
        }
        this.lastQueriedChunkXPos = i2;
        this.lastQueriedChunkZPos = j2;
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk func_542_c(int i2, int j2) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, i2, j2);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.blankChunk;
        }
    }

    private void saveExtraChunkData(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
        Chunk chunk = this.provideChunk(i2, j2);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(ichunkprovider, i2, j2);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i2 = 0;
        int j2 = 0;
        if (iprogressupdate != null) {
            for (int k2 = 0; k2 < this.chunks.length; ++k2) {
                if (this.chunks[k2] == null || !this.chunks[k2].needsSaving(flag)) continue;
                ++j2;
            }
        }
        int l2 = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null) continue;
            if (flag && !this.chunks[i1].neverSave) {
                this.saveExtraChunkData(this.chunks[i1]);
            }
            if (!this.chunks[i1].needsSaving(flag)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i2 == 2 && !flag) {
                return false;
            }
            if (iprogressupdate == null || ++l2 % 10 != 0) continue;
            iprogressupdate.setLoadingProgress(l2 * 100 / j2);
        }
        if (flag) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public void unloadAllChunks() {
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            this.chunks[i2] = null;
        }
        this.chunkProvider = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public String makeString() {
        return "ChunkCache: " + this.chunks.length;
    }
}

