/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.ChunkProviderGenerateOverworld;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDeadBush;
import net.minecraft.src.WorldGenDungeon;
import net.minecraft.src.WorldGenLabyrinth;
import net.minecraft.src.WorldGenLakes;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenRichDirt;
import net.minecraft.src.WorldGenTreeShapeDefault;
import net.minecraft.src.WorldGenTreeShapeFancy;
import net.minecraft.src.WorldGenerator;

public class ChunkProviderOverworldHell
extends ChunkProviderGenerateOverworld {
    public ChunkProviderOverworldHell(World world, long l2) {
        super(world, l2, 64, 128, 64);
    }

    @Override
    public int[] generateTerrain(int chunkX, int chunkZ, short[] ashort0) {
        int xzScale = 4;
        int[] heights = new int[256];
        int xSampleSize = xzScale + 1;
        int fullYHeight = (this.terrainMaxHeight - this.terrainMiddle) * 2;
        int yOffset = (fullYHeight - this.terrainMaxHeight) / 8;
        int ySampleSize = this.terrainMaxHeight / 8 + 1;
        int zSampleSize = xzScale + 1;
        this.field_4180_q = this.func_4061_a(this.field_4180_q, chunkX * xzScale, 0, chunkZ * xzScale, xSampleSize, ySampleSize, zSampleSize);
        for (int x2 = 0; x2 < xzScale; ++x2) {
            for (int z2 = 0; z2 < xzScale; ++z2) {
                for (int y2 = 0; y2 < this.terrainMaxHeight / 8; ++y2) {
                    double d2 = 0.125;
                    double d1 = this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d22 = this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d3 = this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d4 = this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 0 + yOffset)];
                    double d5 = (this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 1 + yOffset)] - d1) * d2;
                    double d6 = (this.field_4180_q[((x2 + 0) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 1 + yOffset)] - d22) * d2;
                    double d7 = (this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 0)) * ySampleSize + (y2 + 1 + yOffset)] - d3) * d2;
                    double d8 = (this.field_4180_q[((x2 + 1) * zSampleSize + (z2 + 1)) * ySampleSize + (y2 + 1 + yOffset)] - d4) * d2;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d22;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d22) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + x2 * 4 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + z2 * 4 << Minecraft.WORLD_HEIGHT_BITS | y2 * 8 + l1;
                            char c2 = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                int l2 = 0;
                                if (y2 * 8 + l1 < this.oceanHeight) {
                                    l2 = Block.fluidLavaStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                ashort0[j2] = (short)l2;
                                j2 += c2;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d22 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        return heights;
    }

    @Override
    public void replaceBlocksForBiome(int chunkX, int chunkZ, short[] ashort0, BiomeGenBase[] abiomegenbase) {
        int byte0 = 64;
        double d2 = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves(this.sandBeachNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves(this.gravelBeachNoise, chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, d2, 1.0, d2);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves(this.soilThicknessNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        this.stoneLayerNoise = this.soilNoise.generateNoiseOctaves(this.stoneLayerNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        this.stoneLayerNoiseGranite = this.field_910_m.generateNoiseOctaves(this.stoneLayerNoiseGranite, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        this.stoneLayerNoiseLimestone = this.beachNoise.generateNoiseOctaves(this.stoneLayerNoiseLimestone, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 4.0, d2 * 4.0, d2 * 4.0);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                BiomeGenBase biomegenbase = abiomegenbase[k2 + l2 * 16];
                boolean flag = this.sandBeachNoise[k2 + l2 * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelBeachNoise[k2 + l2 * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                boolean flagBasalt = this.stoneLayerNoise[k2 + l2 * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flagGranite = this.stoneLayerNoiseGranite[k2 + l2 * 16] + this.rand.nextDouble() * 0.2 > 2.0;
                boolean flagLimestone = this.stoneLayerNoiseLimestone[k2 + l2 * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.soilThicknessNoise[k2 + l2 * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int layerControlBasalt = (int)(this.stoneLayerNoise[k2 + l2] + this.rand.nextDouble() * 0.5);
                int layerControlGranite = (int)(this.stoneLayerNoiseGranite[k2 + l2] + this.rand.nextDouble() * 0.5);
                int layerControlLimestone = (int)(this.stoneLayerNoiseLimestone[k2 + l2] + this.rand.nextDouble() * 0.5);
                int j1 = -1;
                short short1 = biomegenbase.topBlock;
                short short2 = biomegenbase.fillerBlock;
                if (short1 == Block.grass.blockID) {
                    short1 = (short)Block.dirtScorched.blockID;
                }
                if (short2 == Block.dirt.blockID) {
                    short2 = (short)Block.dirtScorched.blockID;
                }
                for (int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; k1 >= 0; --k1) {
                    int l1 = (l2 * 16 + k2) * Minecraft.WORLD_HEIGHT_BLOCKS + k1;
                    if (k1 <= 0 + this.rand.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    short short3 = ashort0[l1];
                    if (short3 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short3 != Block.stone.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            short1 = 0;
                            short2 = (short)Block.stone.blockID;
                        } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                            short1 = biomegenbase.topBlock;
                            short2 = biomegenbase.fillerBlock;
                            if (short1 == Block.grass.blockID) {
                                short1 = (short)Block.dirt.blockID;
                            }
                            if (flag1) {
                                short1 = 0;
                            }
                            if (flag1) {
                                short2 = (short)Block.gravel.blockID;
                            }
                            if (flag) {
                                short1 = (short)Block.sand.blockID;
                            }
                            if (flag) {
                                short2 = (short)Block.sand.blockID;
                            }
                        }
                        if (k1 < byte0 && short1 == 0) {
                            short1 = (short)Block.fluidLavaStill.blockID;
                        }
                        j1 = i1;
                        if (k1 >= byte0 - 1) {
                            ashort0[l1] = short1;
                            continue;
                        }
                        ashort0[l1] = short2;
                        continue;
                    }
                    if (j1 <= 0) {
                        if (k1 <= 30 + layerControlBasalt - this.rand.nextInt(3) && k1 >= 0 + layerControlBasalt - this.rand.nextInt(3) && flagBasalt) {
                            ashort0[l1] = (short)Block.basalt.blockID;
                            continue;
                        }
                        if (k1 <= Minecraft.WORLD_HEIGHT_BLOCKS + layerControlGranite - this.rand.nextInt(3) && k1 >= 64 + layerControlGranite - this.rand.nextInt(3) && flagGranite) {
                            ashort0[l1] = (short)Block.granite.blockID;
                            continue;
                        }
                        if (k1 > Minecraft.WORLD_HEIGHT_BLOCKS + layerControlLimestone - this.rand.nextInt(3) || k1 < 64 + layerControlLimestone - this.rand.nextInt(3) || !flagLimestone) continue;
                        ashort0[l1] = (short)Block.limestone.blockID;
                        continue;
                    }
                    ashort0[l1] = short2;
                    if (--j1 != 0 || short2 != Block.sand.blockID) continue;
                    j1 = this.rand.nextInt(4);
                    short2 = (byte)Block.sandstone.blockID;
                }
            }
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        int l5;
        int j2;
        int j5;
        int k1;
        BlockSand.fallInstantly = true;
        int x2 = chunkX * 16;
        int z2 = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.getWorldChunkManager().getBiomeGenAt(x2 + 16, z2 + 16);
        this.rand.setSeed(this.worldObj.getRandomSeed());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.getRandomSeed());
        double d2 = 0.25;
        if (this.rand.nextInt(32) == 0) {
            int i1 = x2 + this.rand.nextInt(16) + 8;
            int l4 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i8 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.fluidLavaStill.blockID).generate(this.worldObj, this.rand, i1, l4, i8);
        }
        if (this.rand.nextInt(16) == 0) {
            int j1 = x2 + this.rand.nextInt(16) + 8;
            int i5 = this.rand.nextInt(this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            int j8 = z2 + this.rand.nextInt(16) + 8;
            if (i5 < 64 || this.rand.nextInt(10) == 0) {
                if (this.rand.nextInt(4) == 0) {
                    new WorldGenLakes(Block.obsidian.blockID).generate(this.worldObj, this.rand, j1, i5, j8);
                } else {
                    new WorldGenLakes(Block.fluidLavaStill.blockID).generate(this.worldObj, this.rand, j1, i5, j8);
                }
            }
        }
        for (int l18 = 0; l18 < 50; ++l18) {
            int l21 = x2 + this.rand.nextInt(16) + 8;
            int k23 = this.rand.nextInt(this.rand.nextInt(this.terrainMaxHeight - this.terrainMaxHeight / 16) + this.terrainMaxHeight / 16);
            int l24 = z2 + this.rand.nextInt(16) + 8;
            if (k23 >= 64) continue;
            new WorldGenLiquids(Block.fluidWaterFlowing.blockID).generate(this.worldObj, this.rand, l21, k23, l24);
        }
        for (k1 = 0; k1 < 8; ++k1) {
            j5 = x2 + this.rand.nextInt(16) + 8;
            int k8 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j11 = z2 + this.rand.nextInt(16) + 8;
            if (this.rand.nextInt(2) == 0) {
                new WorldGenDungeon(Block.brickClay.blockID, Block.brickClay.blockID, null).generate(this.worldObj, this.rand, j5, k8, j11);
                continue;
            }
            new WorldGenDungeon(Block.cobbleStone.blockID, Block.cobbleStoneMossy.blockID, null).generate(this.worldObj, this.rand, j5, k8, j11);
        }
        for (k1 = 0; k1 < 1; ++k1) {
            j5 = x2 + this.rand.nextInt(16) + 8;
            int j11 = z2 + this.rand.nextInt(16) + 8;
            int k8 = this.worldObj.getHeightValue(j5, j11) - (this.rand.nextInt(2) + 2);
            if (this.rand.nextInt(10) == 0) {
                k8 -= this.rand.nextInt(10) + 30;
            }
            if (this.rand.nextInt(512) != 0) continue;
            new WorldGenLabyrinth().generate(this.worldObj, this.rand, j5, k8, j11);
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            int k5 = x2 + this.rand.nextInt(16);
            int l8 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k11 = z2 + this.rand.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.rand, k5, l8, k11);
        }
        if (biomegenbase == BiomeGenBase.outback) {
            for (j2 = 0; j2 < 5; ++j2) {
                l5 = x2 + this.rand.nextInt(16);
                int l11 = z2 + this.rand.nextInt(16);
                int i9 = this.worldObj.getHeightValue(l5, l11);
                new WorldGenRichDirt(20).generate(this.worldObj, this.rand, l5, i9, l11);
            }
        }
        for (j2 = 0; j2 < 20; ++j2) {
            l5 = x2 + this.rand.nextInt(16);
            int i9 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l11 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32, false).generate(this.worldObj, this.rand, l5, i9, l11);
        }
        for (int k2 = 0; k2 < 10; ++k2) {
            int i6 = x2 + this.rand.nextInt(16);
            int j9 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32, false).generate(this.worldObj, this.rand, i6, j9, i12);
        }
        for (int i3 = 0; i3 < 20; ++i3) {
            int j6 = x2 + this.rand.nextInt(16);
            int k9 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreCoalStone.blockID, 16, true).generate(this.worldObj, this.rand, j6, k9, j12);
        }
        for (int j3 = 0; j3 < 20; ++j3) {
            int k6 = x2 + this.rand.nextInt(16);
            int l9 = this.rand.nextInt(64);
            int k12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreIronStone.blockID, 8, true).generate(this.worldObj, this.rand, k6, l9, k12);
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = x2 + this.rand.nextInt(16);
            int i10 = this.rand.nextInt(32);
            int l12 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreGoldStone.blockID, 8, true).generate(this.worldObj, this.rand, l6, i10, l12);
        }
        for (int l3 = 0; l3 < 8; ++l3) {
            int i7 = x2 + this.rand.nextInt(16);
            int j10 = this.rand.nextInt(16);
            int i13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreRedstoneStone.blockID, 7, true).generate(this.worldObj, this.rand, i7, j10, i13);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = x2 + this.rand.nextInt(16);
            int k10 = this.rand.nextInt(16);
            int j13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreDiamondStone.blockID, 7, true).generate(this.worldObj, this.rand, j7, k10, j13);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = x2 + this.rand.nextInt(16);
            int l10 = this.rand.nextInt(16) + this.rand.nextInt(16);
            int k13 = z2 + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreLapisStone.blockID, 6, true).generate(this.worldObj, this.rand, k7, l10, k13);
        }
        d2 = 0.5;
        int k4 = (int)((this.mobSpawnerNoise.func_806_a((double)x2 * d2, (double)z2 * d2) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        int treeDensity = 0;
        if (this.rand.nextInt(10) == 0) {
            ++treeDensity;
        }
        if (biomegenbase == BiomeGenBase.forest) {
            treeDensity += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            treeDensity += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            treeDensity += k4 + 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            treeDensity += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            treeDensity -= 20;
        }
        if (biomegenbase == BiomeGenBase.tundra) {
            treeDensity -= 20;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            treeDensity -= 20;
        }
        treeDensity /= 2;
        for (int i11 = 0; i11 < treeDensity; ++i11) {
            int l13 = x2 + this.rand.nextInt(16) + 8;
            int j14 = z2 + this.rand.nextInt(16) + 8;
            WorldGenerator worldgenerator = this.rand.nextInt(10) == 0 ? new WorldGenTreeShapeFancy(0, Block.logOak.blockID) : new WorldGenTreeShapeDefault(0, Block.logOak.blockID, 4);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.worldObj, this.rand, l13, this.worldObj.getHeightValue(l13, j14), j14);
        }
        int byte1 = 1;
        if (biomegenbase == BiomeGenBase.outback) {
            byte1 = 10;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            byte1 = 2;
        }
        for (int i15 = 0; i15 < byte1; ++i15) {
            int i17 = x2 + this.rand.nextInt(16) + 8;
            int i20 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l22 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenDeadBush(Block.deadbush.blockID).generate(this.worldObj, this.rand, i17, i20, l22);
        }
        for (int l18 = 0; l18 < 5; ++l18) {
            int l21 = x2 + this.rand.nextInt(16) + 8;
            int k23 = this.rand.nextInt(this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            int l24 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaFlowing.blockID).generate(this.worldObj, this.rand, l21, k23, l24);
        }
        for (int i19 = 0; i19 < 20; ++i19) {
            int i22 = x2 + this.rand.nextInt(16) + 8;
            int l23 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            int i25 = z2 + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaFlowing.blockID).generate(this.worldObj, this.rand, i22, l23, i25);
        }
        this.generatedTemperatures = this.worldObj.getWorldChunkManager().getTemperatures(this.generatedTemperatures, x2 + 8, z2 + 8, 16, 16);
        BlockSand.fallInstantly = false;
    }
}

