/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.WorldServer;

public class ChunkProviderServer
implements IChunkProvider {
    private Set field_725_a = new HashSet();
    private Chunk dummyChunk;
    public IChunkProvider chunkProvider;
    private IChunkLoader field_729_d;
    public boolean chunkLoadOverride = false;
    private Map id2ChunkMap = new HashMap();
    private List field_727_f = new ArrayList();
    private WorldServer world;

    public ChunkProviderServer(WorldServer worldserver, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.dummyChunk = new EmptyChunk(worldserver, new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS], 0, 0);
        this.world = worldserver;
        this.field_729_d = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        return this.id2ChunkMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
    }

    public void func_35391_d(int i2, int j2) {
        ChunkCoordinates chunkcoordinates = this.world.getSpawnPoint();
        int k2 = i2 * 16 + 8 - chunkcoordinates.x;
        int l2 = j2 * 16 + 8 - chunkcoordinates.z;
        int c2 = 128;
        if (k2 < -c2 || k2 > c2 || l2 < -c2 || l2 > c2) {
            this.field_725_a.add(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
        }
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        int k2 = ChunkCoordIntPair.chunkXZ2Int(i2, j2);
        this.field_725_a.remove(k2);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(k2);
        if (chunk == null) {
            chunk = this.func_4063_e(i2, j2);
            if (chunk == null) {
                chunk = this.chunkProvider == null ? this.dummyChunk : this.chunkProvider.provideChunk(i2, j2);
            }
            this.id2ChunkMap.put(k2, chunk);
            this.field_727_f.add(chunk);
            if (chunk != null) {
                chunk.func_4143_d();
                chunk.onChunkLoad();
            }
            if (!chunk.isTerrainPopulated && this.chunkExists(i2 + 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2);
            }
            if (this.chunkExists(i2 - 1, j2) && !this.provideChunk((int)(i2 - 1), (int)j2).isTerrainPopulated && this.chunkExists(i2 - 1, j2 + 1) && this.chunkExists(i2, j2 + 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2);
            }
            if (this.chunkExists(i2, j2 - 1) && !this.provideChunk((int)i2, (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 + 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 + 1, j2)) {
                this.populate(this, i2, j2 - 1);
            }
            if (this.chunkExists(i2 - 1, j2 - 1) && !this.provideChunk((int)(i2 - 1), (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(i2 - 1, j2 - 1) && this.chunkExists(i2, j2 - 1) && this.chunkExists(i2 - 1, j2)) {
                this.populate(this, i2 - 1, j2 - 1);
            }
        }
        return chunk;
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        Chunk chunk = (Chunk)this.id2ChunkMap.get(ChunkCoordIntPair.chunkXZ2Int(i2, j2));
        if (chunk == null) {
            if (this.world.findingSpawnPoint || this.chunkLoadOverride) {
                return this.prepareChunk(i2, j2);
            }
            return this.dummyChunk;
        }
        return chunk;
    }

    private Chunk func_4063_e(int i2, int j2) {
        if (this.field_729_d == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_729_d.loadChunk(this.world, i2, j2);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_375_a(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            this.field_729_d.saveExtraChunkData(this.world, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_373_b(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.field_729_d.saveChunk(this.world, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
        Chunk chunk = this.provideChunk(i2, j2);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(ichunkprovider, i2, j2);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i2 = 0;
        for (int j2 = 0; j2 < this.field_727_f.size(); ++j2) {
            Chunk chunk = (Chunk)this.field_727_f.get(j2);
            if (flag && !chunk.neverSave) {
                this.func_375_a(chunk);
            }
            if (!chunk.needsSaving(flag)) continue;
            this.func_373_b(chunk);
            chunk.isModified = false;
            if (++i2 != 24 || flag) continue;
            return false;
        }
        if (flag) {
            if (this.field_729_d == null) {
                return true;
            }
            this.field_729_d.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        if (!this.world.levelSaving) {
            for (int i2 = 0; i2 < 100; ++i2) {
                if (this.field_725_a.isEmpty()) continue;
                Integer integer = (Integer)this.field_725_a.iterator().next();
                Chunk chunk = (Chunk)this.id2ChunkMap.get(integer);
                chunk.onChunkUnload();
                this.func_373_b(chunk);
                this.func_375_a(chunk);
                this.field_725_a.remove(integer);
                this.id2ChunkMap.remove(integer);
                this.field_727_f.remove(chunk);
            }
            if (this.field_729_d != null) {
                this.field_729_d.func_814_a();
            }
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public void unloadAllChunks() {
        this.id2ChunkMap.clear();
        this.field_727_f.clear();
        this.field_725_a.clear();
        this.chunkProvider = null;
        System.gc();
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public boolean canSave() {
        return !this.world.levelSaving;
    }

    @Override
    public String makeString() {
        return "";
    }
}

