/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.Material;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDungeon;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenPumpkin;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenerator;

public class ChunkProviderSky
implements IChunkProvider {
    private Random field_28087_j;
    private NoiseGeneratorOctaves field_28086_k;
    private NoiseGeneratorOctaves field_28085_l;
    private NoiseGeneratorOctaves field_28084_m;
    private NoiseGeneratorOctaves field_28083_n;
    private NoiseGeneratorOctaves field_28082_o;
    public NoiseGeneratorOctaves field_28096_a;
    public NoiseGeneratorOctaves field_28095_b;
    public NoiseGeneratorOctaves field_28094_c;
    private World field_28081_p;
    private double[] field_28080_q;
    private double[] field_28079_r = new double[256];
    private double[] field_28078_s = new double[256];
    private double[] field_28077_t = new double[256];
    private MapGenBase field_28076_u = new MapGenCaves(false);
    private BiomeGenBase[] field_28075_v;
    double[] field_28093_d;
    double[] field_28092_e;
    double[] field_28091_f;
    double[] field_28090_g;
    double[] field_28089_h;
    int[][] field_28088_i = new int[32][32];
    private double[] field_28074_w;

    public ChunkProviderSky(World world, long l2) {
        this.field_28081_p = world;
        this.field_28087_j = new Random(l2);
        this.field_28086_k = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28085_l = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28084_m = new NoiseGeneratorOctaves(this.field_28087_j, 8);
        this.field_28083_n = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28082_o = new NoiseGeneratorOctaves(this.field_28087_j, 4);
        this.field_28096_a = new NoiseGeneratorOctaves(this.field_28087_j, 10);
        this.field_28095_b = new NoiseGeneratorOctaves(this.field_28087_j, 16);
        this.field_28094_c = new NoiseGeneratorOctaves(this.field_28087_j, 8);
    }

    public int[] generateTerrain(int i2, int j2, short[] ashort0) {
        int byte0 = 2;
        int[] heights = new int[256];
        Arrays.fill(heights, 0);
        int k2 = byte0 + 1;
        int byte1 = 33;
        int l2 = byte0 + 1;
        this.field_28080_q = this.func_28073_a(this.field_28080_q, i2 * byte0, 0, j2 * byte0, k2, byte1, l2);
        for (int x2 = 0; x2 < byte0; ++x2) {
            for (int z2 = 0; z2 < byte0; ++z2) {
                for (int y2 = 0; y2 < 32; ++y2) {
                    double d2 = 0.25;
                    double d1 = this.field_28080_q[((x2 + 0) * l2 + (z2 + 0)) * byte1 + (y2 + 0)];
                    double d22 = this.field_28080_q[((x2 + 0) * l2 + (z2 + 1)) * byte1 + (y2 + 0)];
                    double d3 = this.field_28080_q[((x2 + 1) * l2 + (z2 + 0)) * byte1 + (y2 + 0)];
                    double d4 = this.field_28080_q[((x2 + 1) * l2 + (z2 + 1)) * byte1 + (y2 + 0)];
                    double d5 = (this.field_28080_q[((x2 + 0) * l2 + (z2 + 0)) * byte1 + (y2 + 1)] - d1) * d2;
                    double d6 = (this.field_28080_q[((x2 + 0) * l2 + (z2 + 1)) * byte1 + (y2 + 1)] - d22) * d2;
                    double d7 = (this.field_28080_q[((x2 + 1) * l2 + (z2 + 0)) * byte1 + (y2 + 1)] - d3) * d2;
                    double d8 = (this.field_28080_q[((x2 + 1) * l2 + (z2 + 1)) * byte1 + (y2 + 1)] - d4) * d2;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d22;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d22) * d9;
                        for (int i22 = 0; i22 < 8; ++i22) {
                            int j22 = i22 + x2 * 8 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + z2 * 8 << Minecraft.WORLD_HEIGHT_BITS | y2 * 4 + l1;
                            char c2 = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k22 = 0; k22 < 8; ++k22) {
                                int l22 = 0;
                                if (d15 > 0.0) {
                                    l22 = Block.stone.blockID;
                                }
                                if (l22 != 0 && y2 > heights[x2 * 16 + z2]) {
                                    heights[x2 * 16 + z2] = y2;
                                }
                                ashort0[j22] = (short)l22;
                                j22 += c2;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d22 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        return heights;
    }

    public void replaceBlocksForBiome(int i2, int j2, short[] ashort0, BiomeGenBase[] abiomegenbase) {
        double d2 = 0.03125;
        this.field_28079_r = this.field_28083_n.generateNoiseOctaves(this.field_28079_r, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.field_28078_s = this.field_28083_n.generateNoiseOctaves(this.field_28078_s, i2 * 16, 109.0134, j2 * 16, 16, 1, 16, d2, 1.0, d2);
        this.field_28077_t = this.field_28082_o.generateNoiseOctaves(this.field_28077_t, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                BiomeGenBase biomegenbase = abiomegenbase[k2 + l2 * 16];
                int i1 = (int)(this.field_28077_t[k2 + l2 * 16] / 3.0 + 3.0 + this.field_28087_j.nextDouble() * 0.25);
                int j1 = -1;
                short short0 = biomegenbase.topBlock;
                short short1 = biomegenbase.fillerBlock;
                for (int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; k1 >= 0; --k1) {
                    int l1 = (l2 * 16 + k2) * Minecraft.WORLD_HEIGHT_BLOCKS + k1;
                    short short2 = ashort0[l1];
                    if (short2 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short2 != Block.stone.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            short0 = 0;
                            short1 = (short)Block.stone.blockID;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            ashort0[l1] = short0;
                            continue;
                        }
                        ashort0[l1] = short1;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    ashort0[l1] = short1;
                    if (--j1 != 0 || short1 != Block.sand.blockID) continue;
                    j1 = this.field_28087_j.nextInt(4);
                    short1 = (short)Block.sandstone.blockID;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i2, int j2) {
        return this.provideChunk(i2, j2);
    }

    @Override
    public Chunk provideChunk(int i2, int j2) {
        this.field_28087_j.setSeed((long)i2 * 341873128712L + (long)j2 * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        Chunk chunk = new Chunk(this.field_28081_p, ashort0, i2, j2);
        this.field_28075_v = this.field_28081_p.getWorldChunkManager().loadBlockGeneratorData(this.field_28075_v, i2 * 16, j2 * 16, 16, 16);
        this.generateTerrain(i2, j2, ashort0);
        this.replaceBlocksForBiome(i2, j2, ashort0, this.field_28075_v);
        this.field_28076_u.generate(this, this.field_28081_p, i2, j2, ashort0);
        chunk.func_1024_c();
        return chunk;
    }

    private double[] func_28073_a(double[] ad2, int i2, int j2, int k2, int l2, int i1, int j1) {
        if (ad2 == null) {
            ad2 = new double[l2 * i1 * j1];
        }
        double d2 = 684.412;
        double d1 = 684.412;
        double[] ad1 = this.field_28081_p.getWorldChunkManager().temperature;
        double[] ad22 = this.field_28081_p.getWorldChunkManager().humidity;
        this.field_28090_g = this.field_28096_a.func_4109_a(this.field_28090_g, i2, k2, l2, j1, 1.121, 1.121, 0.5);
        this.field_28089_h = this.field_28095_b.func_4109_a(this.field_28089_h, i2, k2, l2, j1, 200.0, 200.0, 0.5);
        this.field_28093_d = this.field_28084_m.generateNoiseOctaves(this.field_28093_d, i2, j2, k2, l2, i1, j1, (d2 *= 2.0) / 80.0, d1 / 160.0, d2 / 80.0);
        this.field_28092_e = this.field_28086_k.generateNoiseOctaves(this.field_28092_e, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        this.field_28091_f = this.field_28085_l.generateNoiseOctaves(this.field_28091_f, i2, j2, k2, l2, i1, j1, d2, d1, d2);
        int k1 = 0;
        int l1 = 0;
        int i22 = 16 / l2;
        for (int j22 = 0; j22 < l2; ++j22) {
            int k22 = j22 * i22 + i22 / 2;
            for (int l22 = 0; l22 < j1; ++l22) {
                double d6;
                int i3 = l22 * i22 + i22 / 2;
                double d22 = ad1[k22 * 16 + i3];
                double d3 = ad22[k22 * 16 + i3] * d22;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.field_28090_g[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.field_28089_h[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)i1 / 16.0;
                ++l1;
                double d7 = (double)i1 / 2.0;
                for (int j3 = 0; j3 < i1; ++j3) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.field_28092_e[k1] / 512.0;
                    double d11 = this.field_28091_f[k1] / 512.0;
                    double d12 = (this.field_28093_d[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > i1 - k3) {
                        double d13 = (float)(j3 - (i1 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    ad2[k1] = d8;
                    ++k1;
                }
            }
        }
        return ad2;
    }

    @Override
    public boolean chunkExists(int i2, int j2) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i2, int j2) {
        BlockSand.fallInstantly = true;
        int k2 = i2 * 16;
        int l2 = j2 * 16;
        BiomeGenBase biomegenbase = this.field_28081_p.getWorldChunkManager().getBiomeGenAt(k2 + 16, l2 + 16);
        this.field_28087_j.setSeed(this.field_28081_p.getRandomSeed());
        long l1 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        long l22 = this.field_28087_j.nextLong() / 2L * 2L + 1L;
        this.field_28087_j.setSeed((long)i2 * l1 + (long)j2 * l22 ^ this.field_28081_p.getRandomSeed());
        double d2 = 0.25;
        for (int k1 = 0; k1 < 8; ++k1) {
            int j5 = k2 + this.field_28087_j.nextInt(16) + 8;
            int k8 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i13 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenDungeon(Block.cobbleStone.blockID, Block.cobbleStoneMossy.blockID, null).generate(this.field_28081_p, this.field_28087_j, j5, k8, i13);
        }
        for (int i22 = 0; i22 < 10; ++i22) {
            int k5 = k2 + this.field_28087_j.nextInt(16);
            int l8 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j13 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenClay(32).generate(this.field_28081_p, this.field_28087_j, k5, l8, j13);
        }
        for (int j22 = 0; j22 < 20; ++j22) {
            int l5 = k2 + this.field_28087_j.nextInt(16);
            int i9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k13 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32, false).generate(this.field_28081_p, this.field_28087_j, l5, i9, k13);
        }
        for (int k22 = 0; k22 < 10; ++k22) {
            int i6 = k2 + this.field_28087_j.nextInt(16);
            int j9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l13 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32, false).generate(this.field_28081_p, this.field_28087_j, i6, j9, l13);
        }
        for (int i3 = 0; i3 < 20; ++i3) {
            int j6 = k2 + this.field_28087_j.nextInt(16);
            int k9 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i14 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreCoalStone.blockID, 16, true).generate(this.field_28081_p, this.field_28087_j, j6, k9, i14);
        }
        for (int j3 = 0; j3 < 20; ++j3) {
            int k6 = k2 + this.field_28087_j.nextInt(16);
            int l9 = this.field_28087_j.nextInt(64);
            int j14 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreIronStone.blockID, 8, true).generate(this.field_28081_p, this.field_28087_j, k6, l9, j14);
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = k2 + this.field_28087_j.nextInt(16);
            int i10 = this.field_28087_j.nextInt(32);
            int k14 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreGoldStone.blockID, 8, true).generate(this.field_28081_p, this.field_28087_j, l6, i10, k14);
        }
        for (int l3 = 0; l3 < 8; ++l3) {
            int i7 = k2 + this.field_28087_j.nextInt(16);
            int j10 = this.field_28087_j.nextInt(16);
            int l14 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreRedstoneStone.blockID, 7, true).generate(this.field_28081_p, this.field_28087_j, i7, j10, l14);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = k2 + this.field_28087_j.nextInt(16);
            int k10 = this.field_28087_j.nextInt(16);
            int i15 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreDiamondStone.blockID, 7, true).generate(this.field_28081_p, this.field_28087_j, j7, k10, i15);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = k2 + this.field_28087_j.nextInt(16);
            int l10 = this.field_28087_j.nextInt(16) + this.field_28087_j.nextInt(16);
            int j15 = l2 + this.field_28087_j.nextInt(16);
            new WorldGenMinable(Block.oreLapisStone.blockID, 6, true).generate(this.field_28081_p, this.field_28087_j, k7, l10, j15);
        }
        d2 = 0.5;
        int k4 = (int)((this.field_28094_c.func_806_a((double)k2 * d2, (double)l2 * d2) / 8.0 + this.field_28087_j.nextDouble() * 4.0 + 4.0) / 3.0);
        int l7 = 0;
        if (this.field_28087_j.nextInt(10) == 0) {
            ++l7;
        }
        if (biomegenbase == BiomeGenBase.forest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            l7 += k4 + 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.tundra) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            l7 -= 20;
        }
        for (int i11 = 0; i11 < l7; ++i11) {
            int k15 = k2 + this.field_28087_j.nextInt(16) + 8;
            int j18 = l2 + this.field_28087_j.nextInt(16) + 8;
            WorldGenerator worldgenerator = biomegenbase.getRandomWorldGenForTrees(this.field_28087_j);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.field_28081_p, this.field_28087_j, k15, this.field_28081_p.getHeightValue(k15, j18), j18);
        }
        for (int j11 = 0; j11 < 2; ++j11) {
            int l15 = k2 + this.field_28087_j.nextInt(16) + 8;
            int k18 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i21 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerYellow.blockID).generate(this.field_28081_p, this.field_28087_j, l15, k18, i21);
        }
        if (this.field_28087_j.nextInt(2) == 0) {
            int k11 = k2 + this.field_28087_j.nextInt(16) + 8;
            int i16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l18 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerRed.blockID).generate(this.field_28081_p, this.field_28087_j, k11, i16, l18);
        }
        if (this.field_28087_j.nextInt(4) == 0) {
            int l11 = k2 + this.field_28087_j.nextInt(16) + 8;
            int j16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i19 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.field_28081_p, this.field_28087_j, l11, j16, i19);
        }
        if (this.field_28087_j.nextInt(8) == 0) {
            int i12 = k2 + this.field_28087_j.nextInt(16) + 8;
            int k16 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j19 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.field_28081_p, this.field_28087_j, i12, k16, j19);
        }
        for (int j12 = 0; j12 < 10; ++j12) {
            int l16 = k2 + this.field_28087_j.nextInt(16) + 8;
            int k19 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j21 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenReed().generate(this.field_28081_p, this.field_28087_j, l16, k19, j21);
        }
        if (this.field_28087_j.nextInt(32) == 0) {
            int k12 = k2 + this.field_28087_j.nextInt(16) + 8;
            int i17 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l19 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.field_28081_p, this.field_28087_j, k12, i17, l19);
        }
        int l12 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            l12 += 10;
        }
        for (int j17 = 0; j17 < l12; ++j17) {
            int i20 = k2 + this.field_28087_j.nextInt(16) + 8;
            int k21 = this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k22 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenCactus().generate(this.field_28081_p, this.field_28087_j, i20, k21, k22);
        }
        for (int k17 = 0; k17 < 50; ++k17) {
            int j20 = k2 + this.field_28087_j.nextInt(16) + 8;
            int l21 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            int l222 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidWaterFlowing.blockID).generate(this.field_28081_p, this.field_28087_j, j20, l21, l222);
        }
        for (int l17 = 0; l17 < 20; ++l17) {
            int k20 = k2 + this.field_28087_j.nextInt(16) + 8;
            int i22 = this.field_28087_j.nextInt(this.field_28087_j.nextInt(this.field_28087_j.nextInt(112) + 8) + 8);
            int i23 = l2 + this.field_28087_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaFlowing.blockID).generate(this.field_28081_p, this.field_28087_j, k20, i22, i23);
        }
        this.field_28074_w = this.field_28081_p.getWorldChunkManager().getTemperatures(this.field_28074_w, k2 + 8, l2 + 8, 16, 16);
        for (int i18 = k2 + 8; i18 < k2 + 8 + 16; ++i18) {
            for (int l20 = l2 + 8; l20 < l2 + 8 + 16; ++l20) {
                int j22 = i18 - (k2 + 8);
                int j23 = l20 - (l2 + 8);
                int k23 = this.field_28081_p.findTopSolidBlock(i18, l20);
                double d1 = this.field_28074_w[j22 * 16 + j23] - (double)(k23 - 64) / 64.0 * 0.3;
                if (!(d1 < 0.5) || k23 <= 0 || k23 >= Minecraft.WORLD_HEIGHT_BLOCKS || !this.field_28081_p.isAirBlock(i18, k23, l20) || !this.field_28081_p.getBlockMaterial(i18, k23 - 1, l20).getIsSolid() || this.field_28081_p.getBlockMaterial(i18, k23 - 1, l20) == Material.ice) continue;
                this.field_28081_p.setBlockWithNotify(i18, k23, l20, Block.layerSnow.blockID);
            }
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }

    @Override
    public void checkForMissingChunks() {
    }
}

