/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ColorProperties;
import net.minecraft.src.LeavesColorProperties;
import net.minecraft.src.Season;

public class ColorizerFoliage {
    private static int[] foliageBuffer = new int[65536];

    public static void func_28152_a(int[] ai2) {
        foliageBuffer = ai2;
    }

    private static int getFoliageColor(double d2, double d1) {
        int i2 = (int)((1.0 - d2) * 255.0);
        int j2 = (int)((1.0 - (d1 *= d2)) * 255.0);
        return foliageBuffer[j2 << 8 | i2];
    }

    private static int getPeakSeasonalColor(Season season, double temp, double hum, LeavesColorProperties lcp) {
        int myColor = ColorProperties.fRGB2iRGB(lcp.inventoryR, lcp.inventoryG, lcp.inventoryB);
        if (season == Season.surfaceSpring) {
            myColor = lcp.overrideSpring ? ColorProperties.fRGB2iRGB(lcp.springR, lcp.springG, lcp.springB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Season.surfaceSummer) {
            myColor = lcp.overrideSummer ? ColorProperties.fRGB2iRGB(lcp.summerR, lcp.summerG, lcp.summerB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Season.surfaceFall) {
            myColor = lcp.overrideFall ? ColorProperties.fRGB2iRGB(lcp.fallR, lcp.fallG, lcp.fallB) : ColorizerFoliage.getFoliageColor(temp, hum);
        } else if (season == Season.surfaceWinter) {
            myColor = lcp.overrideWinter ? ColorProperties.fRGB2iRGB(lcp.winterR, lcp.winterG, lcp.winterB) : ColorizerFoliage.getFoliageColor(temp, hum);
        }
        return myColor;
    }

    public static int getSeasonalColor(Season season, float progress, double temp, double hum, LeavesColorProperties lcp) {
        return ColorizerFoliage.getSeasonalColor(season, progress, temp, hum, lcp, false);
    }

    public static int getSeasonalColor(Season season, float progress, double temp, double hum, LeavesColorProperties lcp, boolean applySeasonalTransform) {
        int myColor = ColorizerFoliage.getPeakSeasonalColor(season, temp, hum, lcp);
        Season otherSeason = null;
        int otherColor = ColorizerFoliage.getPeakSeasonalColor(season, temp, hum, lcp);
        float blend = Math.abs(progress - 0.5f);
        if (season == Season.surfaceSpring) {
            otherSeason = progress < 0.5f ? Season.surfaceWinter : Season.surfaceSummer;
        } else if (season == Season.surfaceSummer) {
            otherSeason = progress < 0.5f ? Season.surfaceSpring : Season.surfaceFall;
        } else if (season == Season.surfaceFall) {
            otherSeason = progress < 0.5f ? Season.surfaceSummer : Season.surfaceWinter;
        } else if (season == Season.surfaceWinter) {
            otherSeason = progress < 0.5f ? Season.surfaceFall : Season.surfaceSpring;
        }
        if (otherSeason != null) {
            otherColor = ColorizerFoliage.getPeakSeasonalColor(otherSeason, temp, hum, lcp);
            if (applySeasonalTransform) {
                myColor = season.modifyFoliageColorizer(myColor, otherSeason, blend);
            }
        }
        return Season.blendColors(myColor, otherColor, blend);
    }
}

