/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Gamemode;
import net.minecraft.src.ICommandListener;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet41EntityPlayerGamemode;
import net.minecraft.src.ServerCommand;
import net.minecraft.src.ServerConfigurationManager;
import net.minecraft.src.WorldServer;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.Commands;
import net.minecraft.src.command.ConsoleCommandSender;

public class ConsoleCommandHandler {
    private static Logger minecraftLogger = Logger.getLogger("Minecraft");
    private MinecraftServer minecraftServer;
    public final ConsoleCommandSender sender;

    public ConsoleCommandHandler(MinecraftServer server) {
        this.minecraftServer = server;
        Commands.initServerCommands(server);
        this.sender = new ConsoleCommandSender(server);
    }

    public boolean handleCommandNew(ServerCommand serverCommand) {
        System.out.println("ServerCommand: " + serverCommand.command);
        String[] args = serverCommand.command.split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            try {
                boolean success = command.execute(this.minecraftServer.serverCommandHandler, this.sender, args1);
                if (!success) {
                    command.sendCommandSyntax(this.minecraftServer.serverCommandHandler, this.sender);
                }
            }
            catch (CommandError e2) {
                this.sender.sendMessage("\u00a7" + ChatColor.red + e2.getMessage());
            }
            return true;
        }
        return false;
    }

    public void handleCommand(ServerCommand servercommand) {
        String s2 = servercommand.command;
        ICommandListener icommandlistener = servercommand.commandListener;
        String s1 = icommandlistener.getUsername();
        ServerConfigurationManager serverconfigurationmanager = this.minecraftServer.configManager;
        if (!this.handleCommandNew(servercommand)) {
            if (s2.toLowerCase().startsWith("help") || s2.toLowerCase().startsWith("?")) {
                this.printHelp(icommandlistener);
            } else if (s2.toLowerCase().startsWith("save-all")) {
                this.sendNoticeToOps(s1, "Forcing save..");
                if (serverconfigurationmanager != null) {
                    serverconfigurationmanager.savePlayerStates();
                }
                for (int i2 = 0; i2 < this.minecraftServer.worldMngr.length; ++i2) {
                    WorldServer worldserver = this.minecraftServer.worldMngr[i2];
                    worldserver.saveWorld(true, null);
                }
                this.sendNoticeToOps(s1, "Save complete.");
            } else if (s2.toLowerCase().startsWith("save-off")) {
                this.sendNoticeToOps(s1, "Disabling level saving..");
                for (int j2 = 0; j2 < this.minecraftServer.worldMngr.length; ++j2) {
                    WorldServer worldserver1 = this.minecraftServer.worldMngr[j2];
                    worldserver1.levelSaving = true;
                }
            } else if (s2.toLowerCase().startsWith("save-on")) {
                this.sendNoticeToOps(s1, "Enabling level saving..");
                for (int k2 = 0; k2 < this.minecraftServer.worldMngr.length; ++k2) {
                    WorldServer worldserver2 = this.minecraftServer.worldMngr[k2];
                    worldserver2.levelSaving = false;
                }
            } else if (s2.toLowerCase().startsWith("ban-ip ")) {
                String s4 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.banIP(s4);
                this.sendNoticeToOps(s1, "Banning ip " + s4);
            } else if (s2.toLowerCase().startsWith("pardon-ip ")) {
                String s5 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.pardonIP(s5);
                this.sendNoticeToOps(s1, "Pardoning ip " + s5);
            } else if (s2.toLowerCase().startsWith("ban ")) {
                String s6 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.banPlayer(s6);
                this.sendNoticeToOps(s1, "Banning " + s6);
                EntityPlayerMP entityplayermp = serverconfigurationmanager.getPlayerEntity(s6);
                if (entityplayermp != null) {
                    entityplayermp.playerNetServerHandler.kickPlayer("Banned by admin");
                }
            } else if (s2.toLowerCase().startsWith("pardon ")) {
                String s7 = s2.substring(s2.indexOf(" ")).trim();
                serverconfigurationmanager.pardonPlayer(s7);
                this.sendNoticeToOps(s1, "Pardoning " + s7);
            } else if (s2.toLowerCase().startsWith("kick ")) {
                String s8 = s2.substring(s2.indexOf(" ")).trim();
                EntityPlayerMP entityplayermp1 = null;
                for (int l2 = 0; l2 < serverconfigurationmanager.playerEntities.size(); ++l2) {
                    EntityPlayerMP entityplayermp5 = serverconfigurationmanager.playerEntities.get(l2);
                    if (!entityplayermp5.username.equalsIgnoreCase(s8)) continue;
                    entityplayermp1 = entityplayermp5;
                }
                if (entityplayermp1 != null) {
                    entityplayermp1.playerNetServerHandler.kickPlayer("Kicked by admin");
                    this.sendNoticeToOps(s1, "Kicking " + entityplayermp1.getDisplayName());
                } else {
                    icommandlistener.log("Can't find user " + s8 + ". No kick.");
                }
            } else if (s2.toLowerCase().startsWith("say ")) {
                s2 = s2.substring(s2.indexOf(" ")).trim();
                minecraftLogger.info("[" + s1 + "] " + s2);
                serverconfigurationmanager.sendPacketToAllPlayers(new Packet3Chat(ChatColor.pink + "[Server] " + s2));
            } else if (s2.toLowerCase().startsWith("whitelist ")) {
                this.handleWhitelist(s1, s2, icommandlistener);
            } else if (s2.startsWith("gamemode ")) {
                String[] as2 = s2.split(" ");
                if (as2.length == 3) {
                    int gamemodeId = -1;
                    try {
                        gamemodeId = Integer.parseInt(as2[2]);
                    }
                    catch (Exception e2) {
                        icommandlistener.log("Unknown or invalid gamemode ID.");
                    }
                    if (gamemodeId != -1) {
                        if (gamemodeId >= Gamemode.gamemodesList.length || Gamemode.gamemodesList[gamemodeId] == null) {
                            icommandlistener.log("Unknown or invalid gamemode ID.");
                        } else if (!serverconfigurationmanager.sendPacketToPlayer(as2[1], new Packet41EntityPlayerGamemode(gamemodeId))) {
                            icommandlistener.log("There's no player by that name online.");
                        } else {
                            EntityPlayerMP player = serverconfigurationmanager.getPlayerEntity(as2[1]);
                            player.setGamemode(Gamemode.gamemodesList[gamemodeId]);
                            this.sendNoticeToOps(s1, "Setting " + player.getDisplayName() + "\u00a77" + "'s gamemode to " + Gamemode.gamemodesList[gamemodeId].languageKey);
                        }
                    }
                }
            } else {
                minecraftLogger.info("Unknown console command. Type \"help\" for help.");
            }
        }
    }

    private void handleWhitelist(String s2, String s1, ICommandListener icommandlistener) {
        String[] as2 = s1.split(" ");
        if (as2.length < 2) {
            return;
        }
        String s22 = as2[1].toLowerCase();
        if ("on".equals(s22)) {
            this.sendNoticeToOps(s2, "Turned on white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", true);
        } else if ("off".equals(s22)) {
            this.sendNoticeToOps(s2, "Turned off white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", false);
        } else if ("list".equals(s22)) {
            Set set = this.minecraftServer.configManager.getWhiteListedIPs();
            String s5 = "";
            for (String s6 : set) {
                s5 = s5 + s6 + " ";
            }
            icommandlistener.log("White-listed players: " + s5);
        } else if ("add".equals(s22) && as2.length == 3) {
            String s3 = as2[2].toLowerCase();
            this.minecraftServer.configManager.addToWhiteList(s3);
            this.sendNoticeToOps(s2, "Added " + s3 + " to white-list");
        } else if ("remove".equals(s22) && as2.length == 3) {
            String s4 = as2[2].toLowerCase();
            this.minecraftServer.configManager.removeFromWhiteList(s4);
            this.sendNoticeToOps(s2, "Removed " + s4 + " from white-list");
        } else if ("reload".equals(s22)) {
            this.minecraftServer.configManager.reloadWhiteList();
            this.sendNoticeToOps(s2, "Reloaded white-list from file");
        }
    }

    private void printHelp(ICommandListener icommandlistener) {
        icommandlistener.log("To run the server without a gui, start it like this:");
        icommandlistener.log("   java -Xmx1024M -Xms1024M -jar minecraft_server.jar nogui");
        icommandlistener.log("Console commands:");
        icommandlistener.log("   help  or  ?               shows this message");
        icommandlistener.log("   kick <player>             removes a player from the server");
        icommandlistener.log("   ban <player>              bans a player from the server");
        icommandlistener.log("   pardon <player>           pardons a banned player so that they can connect again");
        icommandlistener.log("   ban-ip <ip>               bans an IP address from the server");
        icommandlistener.log("   pardon-ip <ip>            pardons a banned IP address so that they can connect again");
        icommandlistener.log("   op <player>               turns a player into an op");
        icommandlistener.log("   deop <player>             removes op status from a player");
        icommandlistener.log("   tp <player1> <player2>    moves one player to the same location as another player");
        icommandlistener.log("   give <player> <id> [num]  gives a player a resource");
        icommandlistener.log("   tell <player> <message>   sends a private message to a player");
        icommandlistener.log("   stop                      gracefully stops the server");
        icommandlistener.log("   save-all                  forces a server-wide level save");
        icommandlistener.log("   save-off                  disables terrain saving (useful for backup scripts)");
        icommandlistener.log("   save-on                   re-enables terrain saving");
        icommandlistener.log("   list                      lists all currently connected players");
        icommandlistener.log("   say <message>             broadcasts a message to all players");
        icommandlistener.log("   time <add|set> <amount>   adds to or sets the world time (0-24000)");
        icommandlistener.log("   gamemode <player> <id>   sets the target player's gamemode");
        icommandlistener.log("   setspawn <x> <y> <z>   sets the server spawn point to the given coordinates");
    }

    private void sendNoticeToOps(String s2, String s1) {
        String s22 = s2 + ": " + s1;
        this.minecraftServer.configManager.sendChatMessageToAllOps("\u00a77(" + s22 + ")");
        minecraftLogger.info(s22);
    }

    private int tryParse(String s2, int i2) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException numberformatexception) {
            return i2;
        }
    }
}

