/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotFurnace;
import net.minecraft.src.TileEntityFurnace;

public class ContainerFurnace
extends Container {
    private TileEntityFurnace furnace;
    private int currentCookTime = 0;
    private int currentBurnTime = 0;
    private int itemBurnTime = 0;
    private int itemCookTime = 0;

    public ContainerFurnace(InventoryPlayer inventoryplayer, TileEntityFurnace tileentityfurnace) {
        this.furnace = tileentityfurnace;
        this.addSlot(new Slot(tileentityfurnace, 0, 56, 17));
        this.addSlot(new Slot(tileentityfurnace, 1, 56, 53));
        this.addSlot(new SlotFurnace(inventoryplayer.player, tileentityfurnace, 2, 116, 35));
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(inventoryplayer, k2 + i2 * 9 + 9, 8 + k2 * 18, 84 + i2 * 18));
            }
        }
        for (int j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(inventoryplayer, j2, 8 + j2 * 18, 142));
        }
    }

    @Override
    public void updateInventory() {
        super.updateInventory();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.currentCookTime != this.furnace.currentCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 0, this.furnace.currentCookTime);
            }
            if (this.currentBurnTime != this.furnace.currentBurnTime) {
                icrafting.updateCraftingInventoryInfo(this, 1, this.furnace.currentBurnTime);
            }
            if (this.itemCookTime != this.furnace.maxCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 2, this.furnace.maxCookTime);
            }
            if (this.itemBurnTime == this.furnace.maxBurnTime) continue;
            icrafting.updateCraftingInventoryInfo(this, 3, this.furnace.maxBurnTime);
        }
        this.currentCookTime = this.furnace.currentCookTime;
        this.currentBurnTime = this.furnace.currentBurnTime;
        this.itemCookTime = this.furnace.maxCookTime;
        this.itemBurnTime = this.furnace.maxBurnTime;
    }

    @Override
    public void updateClientProgressBar(int id2, int value) {
        if (id2 == 0) {
            this.furnace.currentCookTime = value;
        }
        if (id2 == 1) {
            this.furnace.currentBurnTime = value;
        }
        if (id2 == 2) {
            this.furnace.maxCookTime = value;
        }
        if (id2 == 3) {
            this.furnace.maxBurnTime = value;
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.furnace.canInteractWith(entityplayer);
    }

    @Override
    public void quickMoveItems(int slotID, EntityPlayer player, boolean shift, boolean control) {
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot == null || !slot.hasStack()) {
            return;
        }
        ItemStack item = slot.getStack();
        ItemStack originalItem = item.copy();
        if (slotID >= 3 && (originalItem.itemID < Block.blocksList.length && Block.blocksList[originalItem.itemID].blockMaterial == Material.wood || originalItem.itemID == Item.stick.itemID || originalItem.itemID == Item.coal.itemID || originalItem.itemID == Item.nethercoal.itemID || originalItem.itemID == Item.olivine.itemID || originalItem.itemID == Item.bucketLava.itemID || originalItem.itemID == Block.saplingOak.blockID || originalItem.itemID == Block.blockCoal.blockID || originalItem.itemID == Block.blockCharcoal.blockID || originalItem.itemID == Block.blockNetherCoal.blockID || originalItem.itemID == Block.blockOlivine.blockID)) {
            this.onStackMergeShiftClick(item, 1, 2, false);
        } else if (slotID == 2) {
            this.onStackMergeShiftClick(item, 3, 39, true);
        } else if (slotID >= 3) {
            this.onStackMergeShiftClick(item, 0, 1, false);
        } else {
            this.onStackMergeShiftClick(item, 3, 39, false);
        }
        if (item.stackSize == 0) {
            slot.putStack(null);
        } else {
            slot.onSlotChanged();
        }
        if (item.stackSize != originalItem.stackSize) {
            slot.onPickupFromSlot(originalItem);
        }
    }
}

