/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.ContainerGuidebookRecipeBase;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Gamemode;
import net.minecraft.src.ItemStack;
import net.minecraft.src.SlotGuidebook;
import net.minecraft.src.StatFileWriter;
import net.minecraft.src.StatList;

public class ContainerGuidebook
extends Container {
    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public ItemStack clickInventorySlot(int slotID, int button, boolean shift, boolean control, EntityPlayer player) {
        return null;
    }

    public void setRecipes(EntityPlayer player, ContainerGuidebookRecipeBase[] recipes, StatFileWriter statWriter) {
        this.inventorySlots.clear();
        for (int i2 = 0; i2 < recipes.length; ++i2) {
            int xOffset = 158 * (i2 / 3) - 41;
            int yOffset = 62 * (i2 % 3) + 3;
            if (recipes[i2] == null) continue;
            for (int j2 = 0; j2 < recipes[i2].inventorySlots.size(); ++j2) {
                boolean discovered;
                SlotGuidebook slot = (SlotGuidebook)recipes[i2].inventorySlots.get(j2);
                if (slot.item == null) {
                    discovered = false;
                } else {
                    boolean bl2 = discovered = statWriter.readStat(StatList.pickUpItemStats[slot.item.itemID]) > 0;
                }
                if (player.getGamemode() == Gamemode.creative) {
                    discovered = true;
                }
                this.addSlot(new SlotGuidebook(this.inventorySlots.size(), slot.xDisplayPosition + xOffset, slot.yDisplayPosition + yOffset, slot.item, discovered));
            }
        }
    }

    @Override
    public void quickMoveItems(int i2, EntityPlayer player, boolean shift, boolean control) {
    }
}

