/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ContainerGuidebookRecipeBase;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IRecipe;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeShaped;
import net.minecraft.src.RecipeShapeless;
import net.minecraft.src.SlotGuidebook;

public class ContainerGuidebookRecipeCrafting
extends ContainerGuidebookRecipeBase {
    public IRecipe recipe;

    public ContainerGuidebookRecipeCrafting(IRecipe recipe) {
        this.recipe = recipe;
        if (recipe instanceof RecipeShaped) {
            RecipeShaped r2 = (RecipeShaped)recipe;
            int slots = 0;
            if (r2.recipeHeight > 2 || r2.recipeWidth > 2) {
                slots = 10;
                this.addSlot(new SlotGuidebook(slots - 1, 81, 19, r2.recipeOutput, false));
                for (int i2 = 0; i2 < slots - 1; ++i2) {
                    int slotX = i2 % 3;
                    int slotY = i2 / 3;
                    if (slotX >= r2.recipeWidth || slotY >= r2.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i2, 1 + 18 * (i2 % 3), 1 + 18 * (i2 / 3), null, false));
                        continue;
                    }
                    ItemStack stack = r2.recipeItems[slotX + slotY * r2.recipeWidth];
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i2, 1 + 18 * (i2 % 3), 1 + 18 * (i2 / 3), stack, false));
                }
            } else {
                slots = 5;
                this.addSlot(new SlotGuidebook(slots - 1, 69, 20, r2.recipeOutput, false));
                for (int i3 = 0; i3 < slots - 1; ++i3) {
                    int slotX = i3 % 2;
                    int slotY = i3 / 2;
                    if (slotX >= r2.recipeWidth || slotY >= r2.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i3, 13 + 18 * (i3 % 2), 10 + 18 * (i3 / 2), null, false));
                        continue;
                    }
                    ItemStack stack = r2.recipeItems[slotX + slotY * r2.recipeWidth];
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i3, 13 + 18 * (i3 % 2), 10 + 18 * (i3 / 2), stack, false));
                }
            }
        } else if (recipe instanceof RecipeShapeless) {
            RecipeShapeless r3 = (RecipeShapeless)recipe;
            int slots = 0;
            if (r3.recipeItems.size() > 4) {
                slots = 10;
                this.addSlot(new SlotGuidebook(slots - 1, 81, 19, r3.recipeOutput, false));
                for (int i4 = 0; i4 < r3.recipeItems.size(); ++i4) {
                    ItemStack stack = (ItemStack)r3.recipeItems.get(i4);
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i4, 1 + 18 * (i4 % 3), 1 + 18 * (i4 / 3), stack, false));
                }
            } else {
                slots = 5;
                this.addSlot(new SlotGuidebook(slots - 1, 69, 20, r3.recipeOutput, false));
                for (int i5 = 0; i5 < r3.recipeItems.size(); ++i5) {
                    ItemStack stack = (ItemStack)r3.recipeItems.get(i5);
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i5, 13 + 18 * (i5 % 2), 10 + 18 * (i5 / 2), stack, false));
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported recipe type!!");
        }
    }

    @Override
    public void quickMoveItems(int i2, EntityPlayer player, boolean shift, boolean control) {
    }
}

