/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryCraftResult;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemQuiver;
import net.minecraft.src.ItemQuiverEndless;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotArmor;
import net.minecraft.src.SlotCrafting;

public class ContainerPlayer
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 2, 2);
    public IInventory craftResult = new InventoryCraftResult();
    public boolean isSinglePlayer = false;
    public InventoryPlayer playerInv;

    public ContainerPlayer(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayer(InventoryPlayer inventoryplayer, boolean isMultiplayer) {
        this.isSinglePlayer = isMultiplayer;
        this.playerInv = inventoryplayer;
        this.addSlot(new SlotCrafting(inventoryplayer.player, this.craftMatrix, this.craftResult, 0, 144, 36));
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i1 = 0; i1 < 2; ++i1) {
                this.addSlot(new Slot(this.craftMatrix, i1 + i2 * 2, 88 + i1 * 18, 26 + i2 * 18));
            }
        }
        for (int j2 = 0; j2 < 4; ++j2) {
            int j1 = j2;
            this.addSlot(new SlotArmor(this, inventoryplayer, inventoryplayer.getSizeInventory() - 1 - j2, 8, 8 + j2 * 18, j1));
        }
        for (int k2 = 0; k2 < 3; ++k2) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot(inventoryplayer, k1 + (k2 + 1) * 9, 8 + k1 * 18, 84 + k2 * 18));
            }
        }
        for (int l2 = 0; l2 < 9; ++l2) {
            this.addSlot(new Slot(inventoryplayer, l2, 8 + l2 * 18, 142));
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix));
    }

    @Override
    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        super.onCraftGuiClosed(entityplayer);
        for (int i2 = 0; i2 < 4; ++i2) {
            ItemStack itemstack = this.craftMatrix.getStackInSlot(i2);
            if (itemstack == null) continue;
            if (!entityplayer.inventory.addItemStackToInventory(itemstack)) {
                entityplayer.dropPlayerItem(itemstack);
            }
            this.craftMatrix.setInventorySlotContents(i2, null);
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void quickMoveItems(int slotID, EntityPlayer player, boolean shift, boolean control) {
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot == null || !slot.hasStack()) {
            return;
        }
        ItemStack item = slot.getStack();
        ItemStack originalItem = item.copy();
        if (originalItem.getItem() instanceof ItemArmor && !(slot instanceof SlotArmor)) {
            ItemArmor armor = (ItemArmor)originalItem.getItem();
            this.onStackMergeShiftClick(item, 5 + armor.armorPiece, 6 + armor.armorPiece, false);
        } else if ((originalItem.getItem() instanceof ItemQuiver || originalItem.getItem() instanceof ItemQuiverEndless) && !(slot instanceof SlotArmor)) {
            this.onStackMergeShiftClick(item, 6, 7, false);
        } else {
            if (slotID == 0) {
                ItemStack craftItem;
                int craftCount = 65536;
                if (control && !shift) {
                    craftCount = 1;
                }
                if (shift && !control) {
                    craftCount = item.getMaxStackSize() / item.stackSize;
                }
                for (int j2 = 0; j2 < craftCount && (craftItem = slot.getStack()) != null && craftItem.itemID == originalItem.itemID && craftItem.getMetadata() == originalItem.getMetadata(); ++j2) {
                    boolean stop = false;
                    boolean itemsCrafted = false;
                    itemsCrafted = this.onStackMergeShiftClick(craftItem, 9, 45, true);
                    if (itemsCrafted) {
                        if (craftItem.stackSize > 0) {
                            player.dropPlayerItem(craftItem.copy());
                            stop = true;
                        }
                    } else {
                        stop = true;
                    }
                    if (craftItem.stackSize == 0) {
                        slot.putStack(null);
                    } else {
                        slot.onSlotChanged();
                    }
                    if (itemsCrafted) {
                        slot.onPickupFromSlot(originalItem);
                    }
                    if (stop) break;
                }
                return;
            }
            if (slotID >= 9 && slotID < 36) {
                this.onStackMergeShiftClick(item, 36, 45, false);
            } else if (slotID >= 36 && slotID < 45) {
                this.onStackMergeShiftClick(item, 9, 36, false);
            } else {
                this.onStackMergeShiftClick(item, 9, 45, false);
            }
        }
        if (item.stackSize == 0) {
            slot.putStack(null);
        } else {
            slot.onSlotChanged();
        }
        if (item.stackSize != originalItem.stackSize) {
            slot.onPickupFromSlot(originalItem);
        }
    }
}

