/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.SlotCreative;
import net.minecraft.src.StringTranslate;

public class ContainerPlayerCreative
extends ContainerPlayer {
    public int page = 0;
    public int maxPage;
    protected int creativeSlotsStart;
    protected String searchText = "";
    protected List<ItemStack> searchedItems = new ArrayList<ItemStack>();
    public static ItemStack[] creativeItems;
    public static int creativeItemsCount;

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer, boolean isSinglePlayer) {
        super(inventoryplayer, isSinglePlayer);
        this.creativeSlotsStart = this.inventorySlots.size();
        for (int i2 = 0; i2 < 36; ++i2) {
            int x2 = i2 % 6;
            int y2 = i2 / 6;
            this.addSlot(new SlotCreative(this.creativeSlotsStart + i2, 174 + x2 * 18, 30 + y2 * 18, creativeItems[i2]));
        }
        this.searchPage("");
    }

    public void setInventoryStatus(int page, String searchText) {
        if (this.page != page) {
            this.page = page;
            this.updatePage();
        }
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.searchPage(searchText);
        }
    }

    public void lastPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.updatePage();
    }

    public void nextPage() {
        if (this.page == this.maxPage) {
            return;
        }
        ++this.page;
        this.updatePage();
    }

    public void searchPage(String search) {
        this.searchText = search;
        this.searchedItems.clear();
        this.page = 0;
        StringTranslate t2 = StringTranslate.getInstance();
        for (int i2 = 0; i2 < creativeItemsCount; ++i2) {
            if (!t2.translateNamedKey(creativeItems[i2].getItemName()).toLowerCase().contains(search.toLowerCase())) continue;
            this.searchedItems.add(creativeItems[i2]);
        }
        this.updatePage();
    }

    protected void updatePage() {
        this.maxPage = this.searchedItems.size() / 36;
        if (this.searchedItems.size() % 36 == 0) {
            --this.maxPage;
        }
        if (this.maxPage == -1) {
            this.maxPage = 0;
        }
        for (int i2 = 0; i2 < 36; ++i2) {
            ((SlotCreative)this.inventorySlots.get((int)(this.creativeSlotsStart + i2))).item = i2 + this.page * 36 >= this.searchedItems.size() ? null : this.searchedItems.get(i2 + this.page * 36);
        }
        this.playerInv.player.updateCreativeInventory(this.page, this.searchText);
    }

    static {
        int j2;
        int i2;
        creativeItems = new ItemStack[512];
        int count = 0;
        for (i2 = 0; i2 < 1000; ++i2) {
            if (Block.blocksList[i2] == null || Block.blocksList[i2].notInCreativeMenu) continue;
            ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i2]);
            ++count;
            if (i2 == Block.wool.blockID || i2 == Block.planksOakPainted.blockID || i2 == Block.lampIdle.blockID || i2 == Block.fencePlanksOakPainted.blockID) {
                for (j2 = 1; j2 < 16; ++j2) {
                    ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i2], 1, j2);
                    ++count;
                }
                continue;
            }
            if (i2 != Block.chestPlanksOakPainted.blockID && i2 != Block.slabPlanksOakPainted.blockID && i2 != Block.fencegatePlanksOakPainted.blockID && i2 != Block.stairsPlanksOakPainted.blockID) continue;
            for (j2 = 16; j2 < 256; j2 += 16) {
                ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i2], 1, j2);
                ++count;
            }
        }
        for (i2 = Block.blocksList.length; i2 < Block.blocksList.length + 2256; ++i2) {
            if (Item.itemsList[i2] == null || Item.itemsList[i2].notInCreativeMenu) continue;
            ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i2]);
            ++count;
            if (i2 == Item.coal.itemID) {
                for (j2 = 1; j2 < 2; ++j2) {
                    ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i2], 1, j2);
                    ++count;
                }
            }
            if (i2 != Item.dye.itemID) continue;
            for (j2 = 1; j2 < 16; ++j2) {
                ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i2], 1, j2);
                ++count;
            }
        }
        creativeItemsCount = count;
    }
}

