/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.Slot;
import net.minecraft.src.TileEntityTrommel;

public class ContainerTrommel
extends Container {
    private TileEntityTrommel trommel;
    private int cookTime = 0;
    private int burnTime = 0;
    private int itemBurnTime = 0;

    public ContainerTrommel(InventoryPlayer inventoryplayer, TileEntityTrommel tileEntityTrommel) {
        this.trommel = tileEntityTrommel;
        this.addSlot(new Slot(tileEntityTrommel, 0, 105, 30));
        this.addSlot(new Slot(tileEntityTrommel, 1, 125, 50));
        this.addSlot(new Slot(tileEntityTrommel, 2, 105, 70));
        this.addSlot(new Slot(tileEntityTrommel, 3, 85, 50));
        this.addSlot(new Slot(tileEntityTrommel, 4, 33, 50));
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(inventoryplayer, k2 + i2 * 9 + 9, 8 + k2 * 18, 110 + i2 * 18));
            }
        }
        for (int j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(inventoryplayer, j2, 8 + j2 * 18, 168));
        }
    }

    @Override
    public void updateInventory() {
        super.updateInventory();
        for (int i2 = 0; i2 < this.crafters.size(); ++i2) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i2);
            if (this.cookTime != this.trommel.itemPopTime) {
                icrafting.updateCraftingInventoryInfo(this, 0, this.trommel.itemPopTime);
            }
            if (this.burnTime != this.trommel.burnTime) {
                icrafting.updateCraftingInventoryInfo(this, 1, this.trommel.burnTime);
            }
            if (this.itemBurnTime == this.trommel.currentItemBurnTime) continue;
            icrafting.updateCraftingInventoryInfo(this, 2, this.trommel.currentItemBurnTime);
        }
        this.cookTime = this.trommel.itemPopTime;
        this.burnTime = this.trommel.burnTime;
        this.itemBurnTime = this.trommel.currentItemBurnTime;
    }

    @Override
    public void updateClientProgressBar(int id2, int value) {
        if (id2 == 0) {
            this.trommel.itemPopTime = value;
        }
        if (id2 == 1) {
            this.trommel.burnTime = value;
        }
        if (id2 == 2) {
            this.trommel.currentItemBurnTime = value;
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.trommel.canInteractWith(entityplayer);
    }

    @Override
    public void quickMoveItems(int slotID, EntityPlayer player, boolean shift, boolean control) {
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot == null || !slot.hasStack()) {
            return;
        }
        ItemStack item = slot.getStack();
        ItemStack originalItem = item.copy();
        if (slotID >= 3 && (originalItem.itemID < Block.blocksList.length && Block.blocksList[originalItem.itemID].blockMaterial == Material.wood || originalItem.itemID == Item.stick.itemID || originalItem.itemID == Item.coal.itemID || originalItem.itemID == Item.bucketLava.itemID || originalItem.itemID == Block.saplingOak.blockID || originalItem.itemID == Block.oreNethercoalNetherrack.blockID)) {
            this.onStackMergeShiftClick(item, 1, 2, false);
        } else if (slotID == 2) {
            this.onStackMergeShiftClick(item, 3, 39, true);
        } else if (slotID >= 3) {
            this.onStackMergeShiftClick(item, 0, 1, false);
        } else {
            this.onStackMergeShiftClick(item, 3, 39, false);
        }
        if (item.stackSize == 0) {
            slot.putStack(null);
        } else {
            slot.onSlotChanged();
        }
        if (item.stackSize != originalItem.stackSize) {
            slot.onPickupFromSlot(originalItem);
        }
    }
}

