/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeRepairable;
import net.minecraft.src.RecipeRepairableStackable;
import net.minecraft.src.RecipeScrap;
import net.minecraft.src.RecipeShaped;
import net.minecraft.src.RecipeShapeless;
import net.minecraft.src.RecipeSorter;
import net.minecraft.src.RecipesArmor;
import net.minecraft.src.RecipesCrafting;
import net.minecraft.src.RecipesDyes;
import net.minecraft.src.RecipesFood;
import net.minecraft.src.RecipesIngots;
import net.minecraft.src.RecipesRepairs;
import net.minecraft.src.RecipesScrappable;
import net.minecraft.src.RecipesTools;
import net.minecraft.src.RecipesWeapons;
import net.minecraft.src.helper.DyeColor;

public class CraftingManager {
    private static final CraftingManager instance = new CraftingManager();
    private List recipes = new ArrayList();
    public static Block[][] blockAlternatives = new Block[][]{{Block.stone, Block.basalt, Block.limestone, Block.granite}, {Block.cobbleStone, Block.cobbleBasalt, Block.cobbleLimestone, Block.cobbleGranite}, {Block.planksOak, Block.planksOakPainted}, {Block.grass, Block.grassRetro}, {Block.dirt, Block.dirtScorched}, {Block.mossStone, Block.mossBasalt, Block.mossLimestone, Block.mossGranite}, {Block.logOak, Block.logPine, Block.logBirch, Block.logCherry, Block.logEucalyptus, Block.logOakMossy}, {Block.leavesOak, Block.leavesOakRetro, Block.leavesPine, Block.leavesBirch, Block.leavesCherry, Block.leavesEucalyptus, Block.leavesShrub}, {Block.oreCoalStone, Block.oreCoalBasalt, Block.oreCoalLimestone, Block.oreCoalGranite}, {Block.oreIronStone, Block.oreIronBasalt, Block.oreIronLimestone, Block.oreIronGranite}, {Block.oreGoldStone, Block.oreGoldBasalt, Block.oreGoldLimestone, Block.oreGoldGranite}, {Block.oreLapisStone, Block.oreLapisBasalt, Block.oreLapisLimestone, Block.oreLapisGranite}, {Block.oreRedstoneStone, Block.oreRedstoneBasalt, Block.oreRedstoneLimestone, Block.oreRedstoneGranite, Block.oreRedstoneGlowingStone, Block.oreRedstoneGlowingBasalt, Block.oreRedstoneGlowingLimestone, Block.oreRedstoneGlowingGranite}, {Block.chestPlanksOak, Block.chestPlanksOakPainted}};

    public static final CraftingManager getInstance() {
        return instance;
    }

    private CraftingManager() {
        new RecipesTools().addRecipes(this);
        new RecipesWeapons().addRecipes(this);
        new RecipesIngots().addRecipes(this);
        new RecipesFood().addRecipes(this);
        new RecipesCrafting().addRecipes(this);
        new RecipesArmor().addRecipes(this);
        new RecipesDyes().addRecipes(this);
        new RecipesRepairs().addRecipes(this);
        new RecipesScrappable().addRecipes(this);
        this.addRecipe(new ItemStack(Block.pillarMarble, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.marble});
        this.addRecipe(new ItemStack(Block.sandstone, 2), new Object[]{"##", "##", Character.valueOf('#'), Block.sand});
        this.addRecipe(new ItemStack(Block.torchCoal, 4), new Object[]{"X", "#", Character.valueOf('X'), Item.coal, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.planksOak, 4), new Object[]{"#", Character.valueOf('#'), Block.logOak}, false);
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.dyeBrown), new Object[]{"#", Character.valueOf('#'), Block.logPine}, false);
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.dyeWhite), new Object[]{"#", Character.valueOf('#'), Block.logBirch}, false);
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.dyeGreen), new Object[]{"#", Character.valueOf('#'), Block.logOakMossy}, false);
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.dyeOrange), new Object[]{"#", Character.valueOf('#'), Block.logEucalyptus}, false);
        this.addRecipe(new ItemStack(Block.planksOakPainted, 4, DyeColor.dyePink), new Object[]{"#", Character.valueOf('#'), Block.logCherry}, false);
        this.addRecipe(new ItemStack(Block.planksOak, 4), new Object[]{"#", Character.valueOf('#'), Block.logOak}, false);
        this.addRecipe(new ItemStack(Block.planksOak, 4), new Object[]{"#", Character.valueOf('#'), Block.logOak}, false);
        this.addRecipe(new ItemStack(Block.ladderOak, 2), new Object[]{"# #", "###", "# #", Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.fencePlanksOak, 6), new Object[]{"#X#", "#X#", Character.valueOf('X'), Item.stick, Character.valueOf('#'), Block.planksOak}, true);
        this.addRecipe(new ItemStack(Block.fencegatePlanksOak, 3), new Object[]{"#X#", "#X#", Character.valueOf('X'), Block.planksOak, Character.valueOf('#'), Item.stick}, true);
        this.addRecipe(new ItemStack(Block.bookshelfPlanksOak, 1), new Object[]{"###", "XXX", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.book}, true, false);
        this.addRecipe(new ItemStack(Block.wool, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.string});
        this.addRecipe(new ItemStack(Block.brickClay, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.brickClay});
        this.addRecipe(new ItemStack(Block.brickStonePolished, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.stonePolished});
        this.addRecipe(new ItemStack(Block.brickStone, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.brickSandstone, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.sandstone});
        this.addRecipe(new ItemStack(Block.brickGold, 4), new Object[]{"##", "##", Character.valueOf('#'), Item.ingotGold});
        this.addRecipe(new ItemStack(Block.brickLapis, 4), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(Item.dye, 1, 4)});
        this.addRecipe(new ItemStack(Block.brickBasalt, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.basalt});
        this.addRecipe(new ItemStack(Block.brickLimestone, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.limestone});
        this.addRecipe(new ItemStack(Block.brickGranite, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.granite});
        this.addRecipe(new ItemStack(Block.brickMarble, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.marble});
        this.addRecipe(new ItemStack(Block.brickSlate, 4), new Object[]{"##", "##", Character.valueOf('#'), Block.slate});
        this.addRecipe(new ItemStack(Block.slabPlanksOak, 6), new Object[]{"###", Character.valueOf('#'), Block.planksOak}, true);
        this.addRecipe(new ItemStack(Block.slabCobbleStone, 6), new Object[]{"###", Character.valueOf('#'), Block.cobbleStone});
        this.addRecipe(new ItemStack(Block.slabSandstone, 6), new Object[]{"###", Character.valueOf('#'), Block.sandstone});
        this.addRecipe(new ItemStack(Block.slabBrickStonePolished, 6), new Object[]{"###", Character.valueOf('#'), Block.brickStonePolished});
        this.addRecipe(new ItemStack(Block.slabStonePolished, 6), new Object[]{"###", Character.valueOf('#'), Block.stonePolished});
        this.addRecipe(new ItemStack(Block.slabGranitePolished, 6), new Object[]{"###", Character.valueOf('#'), Block.granitePolished});
        this.addRecipe(new ItemStack(Block.slabBasaltPolished, 6), new Object[]{"###", Character.valueOf('#'), Block.basaltPolished});
        this.addRecipe(new ItemStack(Block.slabLimestonePolished, 6), new Object[]{"###", Character.valueOf('#'), Block.limestonePolished});
        this.addRecipe(new ItemStack(Block.slabBrickMarble, 6), new Object[]{"###", Character.valueOf('#'), Block.brickMarble});
        this.addRecipe(new ItemStack(Block.slabBrickClay, 6), new Object[]{"###", Character.valueOf('#'), Block.brickClay});
        this.addRecipe(new ItemStack(Block.slabCapstoneMarble, 6), new Object[]{"###", Character.valueOf('#'), Block.marble});
        this.addRecipe(new ItemStack(Block.slabCobbleBasalt, 6), new Object[]{"###", Character.valueOf('#'), Block.cobbleBasalt});
        this.addRecipe(new ItemStack(Block.slabCobbleLimestone, 6), new Object[]{"###", Character.valueOf('#'), Block.cobbleLimestone});
        this.addRecipe(new ItemStack(Block.slabCobbleGranite, 6), new Object[]{"###", Character.valueOf('#'), Block.cobbleGranite});
        this.addRecipe(new ItemStack(Block.slabBrickBasalt, 6), new Object[]{"###", Character.valueOf('#'), Block.brickBasalt});
        this.addRecipe(new ItemStack(Block.slabBrickLimestone, 6), new Object[]{"###", Character.valueOf('#'), Block.brickLimestone});
        this.addRecipe(new ItemStack(Block.slabBrickGranite, 6), new Object[]{"###", Character.valueOf('#'), Block.brickGranite});
        this.addRecipe(new ItemStack(Block.slabBrickStone, 6), new Object[]{"###", Character.valueOf('#'), Block.brickStone});
        this.addRecipe(new ItemStack(Block.slabBrickSlate, 6), new Object[]{"###", Character.valueOf('#'), Block.brickSlate});
        this.addRecipe(new ItemStack(Block.stairsPlanksOak, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.planksOak}, true);
        this.addRecipe(new ItemStack(Block.stairsCobbleStone, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.cobbleStone});
        this.addRecipe(new ItemStack(Block.stairsBrickStonePolished, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickStonePolished});
        this.addRecipe(new ItemStack(Block.stairsBrickMarble, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickMarble});
        this.addRecipe(new ItemStack(Block.stairsCobbleBasalt, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.cobbleBasalt});
        this.addRecipe(new ItemStack(Block.stairsCobbleLimestone, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.cobbleLimestone});
        this.addRecipe(new ItemStack(Block.stairsCobbleGranite, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.cobbleGranite});
        this.addRecipe(new ItemStack(Block.stairsBrickBasalt, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickBasalt});
        this.addRecipe(new ItemStack(Block.stairsBrickLimestone, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickLimestone});
        this.addRecipe(new ItemStack(Block.stairsBrickGranite, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickGranite});
        this.addRecipe(new ItemStack(Block.stairsBrickClay, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickClay});
        this.addRecipe(new ItemStack(Block.stairsBrickStone, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickStone});
        this.addRecipe(new ItemStack(Block.stairsBrickSlate, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickSlate});
        this.addRecipe(new ItemStack(Block.torchRedstoneActive, 1), new Object[]{"X", "#", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Block.buttonStone, 4), new Object[]{"#", Character.valueOf('#'), Block.stone}, true);
        this.addRecipe(new ItemStack(Block.leverCobbleStone, 2), new Object[]{"X", "#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.stick}, true);
        this.addRecipe(new ItemStack(Block.pressureplateStone, 1), new Object[]{"##", Character.valueOf('#'), Block.stone}, true);
        this.addRecipe(new ItemStack(Block.pressureplatePlanksOak, 1), new Object[]{"##", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Block.pressureplateCobbleStone, 1), new Object[]{"##", Character.valueOf('#'), Block.cobbleStone}, true);
        this.addRecipe(new ItemStack(Block.pistonBase, 1), new Object[]{"TTT", "#X#", "#R#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.ingotIron, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('T'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Block.pistonBaseSticky, 1), new Object[]{"S", "P", Character.valueOf('S'), Item.slimeball, Character.valueOf('P'), Block.pistonBase}, true);
        this.addRecipe(new ItemStack(Block.noteblock, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.dustRedstone}, true, false);
        this.addRecipe(new ItemStack(Block.rail, 16), new Object[]{"X X", "X#X", "X X", Character.valueOf('X'), Item.ingotIron, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.railPowered, 8), new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), Item.ingotGold, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.railDetector, 8), new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), Item.ingotIron, Character.valueOf('R'), Item.dustRedstone, Character.valueOf('#'), Block.pressureplateStone});
        this.addRecipe(new ItemStack(Block.spikes, 4), new Object[]{" # ", "#X#", "YYY", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.dustRedstone, Character.valueOf('Y'), Block.cobbleStone}, true);
        this.addRecipe(new ItemStack(Block.dispenserCobbleStone, 1), new Object[]{"###", "#X#", "#R#", Character.valueOf('#'), Block.cobbleStone, Character.valueOf('X'), Item.toolBow, Character.valueOf('R'), Item.dustRedstone}, true);
        this.addRecipe(new ItemStack(Block.trapdoorPlanksOak, 6), new Object[]{"###", "###", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Block.trapdoorIron, 6), new Object[]{"###", "###", Character.valueOf('#'), Item.ingotIron}, true, false);
        this.addRecipe(new ItemStack(Block.tnt, 1), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('X'), Item.sulphur, Character.valueOf('#'), Block.sand});
        this.addRecipe(new ItemStack(Block.mesh, 8), new Object[]{"###", "# #", "###", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Block.cobweb, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), Item.string});
        this.addRecipe(new ItemStack(Block.blockSnow, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.ammoSnowball});
        this.addRecipe(new ItemStack(Block.blockClay, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.clay});
        this.addRecipe(new ItemStack(Block.jukebox, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.diamond}, true, false);
        this.addRecipe(new ItemStack(Item.paper, 6), new Object[]{"###", Character.valueOf('#'), Item.sugarcane});
        this.addRecipe(new ItemStack(Item.book, 1), new Object[]{"#", "#", "#", Character.valueOf('#'), Item.paper});
        this.addRecipe(new ItemStack(Block.pumpkinCarvedIdle, 1), new Object[]{"A", Character.valueOf('A'), Block.pumpkin});
        this.addRecipe(new ItemStack(Block.pumpkinCarvedActive, 1), new Object[]{"A", "B", Character.valueOf('A'), Block.pumpkinCarvedIdle, Character.valueOf('B'), Block.torchCoal});
        this.addRecipe(new ItemStack(Block.glowstone, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.dustGlowstone});
        this.addRecipe(new ItemStack(Item.doorOak, 2), new Object[]{"##", "##", "##", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Item.doorIron, 2), new Object[]{"##", "##", "##", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.sign, 4), new Object[]{"###", "###", " X ", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.stick}, true, false);
        this.addRecipe(new ItemStack(Item.foodCake, 1), new Object[]{"AAA", "BEB", "CCC", Character.valueOf('A'), Item.bucketMilk, Character.valueOf('B'), Item.dustSugar, Character.valueOf('C'), Item.wheat, Character.valueOf('E'), Item.eggChicken});
        this.addRecipe(new ItemStack(Item.dustSugar, 3), new Object[]{"#", Character.valueOf('#'), Item.sugarcane});
        this.addRecipe(new ItemStack(Item.stick, 4), new Object[]{"#", "#", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Block.torchCoal, 4), new Object[]{"X", "#", Character.valueOf('X'), new ItemStack(Item.coal, 1, 1), Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.torchCoal, 8), new Object[]{"X", "#", Character.valueOf('X'), new ItemStack(Item.nethercoal, 1, 0), Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Item.bowl, 4), new Object[]{"# #", " # ", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Item.minecart, 1), new Object[]{"# #", "###", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.minecartChest, 1), new Object[]{"A", "B", Character.valueOf('A'), Block.chestPlanksOak, Character.valueOf('B'), Item.minecart}, true, false);
        this.addRecipe(new ItemStack(Item.minecartFurnace, 1), new Object[]{"A", "B", Character.valueOf('A'), Block.furnaceStoneIdle, Character.valueOf('B'), Item.minecart});
        this.addRecipe(new ItemStack(Item.boat, 1), new Object[]{"# #", "###", Character.valueOf('#'), Block.planksOak}, true, false);
        this.addRecipe(new ItemStack(Item.bucket, 1), new Object[]{"# #", " # ", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.toolFirestriker, 1), new Object[]{"A ", " B", Character.valueOf('A'), Item.ingotIron, Character.valueOf('B'), Item.flint});
        this.addRecipe(new ItemStack(Item.foodBread, 1), new Object[]{"###", Character.valueOf('#'), Item.wheat});
        this.addRecipe(new ItemStack(Item.toolFishingrod, 1), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.string});
        this.addRecipe(new ItemStack(Item.painting, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Block.wool}, false, false);
        this.addRecipe(new ItemStack(Item.foodAppleGold, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.blockGold, Character.valueOf('X'), Item.foodApple});
        this.addRecipe(new ItemStack(Item.repeater, 1), new Object[]{"#X#", "III", Character.valueOf('#'), Block.torchRedstoneActive, Character.valueOf('X'), Item.dustRedstone, Character.valueOf('I'), Block.stone}, true);
        this.addRecipe(new ItemStack(Item.toolClock, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Item.ingotGold, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Item.toolCompass, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Item.toolCalendar, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Block.planksOak, Character.valueOf('X'), Item.dustRedstone}, true, false);
        this.addRecipe(new ItemStack(Item.map, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Item.paper, Character.valueOf('X'), Item.toolCompass});
        this.addRecipe(new ItemStack(Item.bed, 1), new Object[]{"YY#", "XXX", Character.valueOf('#'), Block.wool, Character.valueOf('X'), Block.planksOak, Character.valueOf('Y'), Item.cloth}, true, false);
        this.addRecipe(new ItemStack(Block.stairsBrickStonePolished, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.brickStonePolished});
        this.addRecipe(new ItemStack(Item.ingotSteel, 1), new Object[]{"###", Character.valueOf('#'), Item.ingotSteelCrude});
        this.addRecipe(new ItemStack(Item.ingotIron, 1), new Object[]{"##", Character.valueOf('#'), Item.nuggetIron});
        this.addRecipe(new ItemStack(Item.ingotGold, 1), new Object[]{"##", Character.valueOf('#'), Item.nuggetGold});
        this.addRecipe(new ItemStack(Block.lampIdle, 4), new Object[]{"###", "#O#", "#X#", Character.valueOf('#'), Block.glass, Character.valueOf('O'), Item.quartz, Character.valueOf('X'), Item.dustRedstone});
        this.addRecipe(new ItemStack(Block.glassTinted, 4), new Object[]{"#X", "X#", Character.valueOf('#'), Block.glass, Character.valueOf('X'), Item.olivine});
        this.addRecipe(new ItemStack(Block.layerSlate, 8), new Object[]{"#", Character.valueOf('#'), Block.slate});
        this.addRecipe(new ItemStack(Block.layerSnow, 2), new Object[]{"##", Character.valueOf('#'), Item.ammoSnowball});
        this.addRecipe(new ItemStack(Block.layerLeavesOak, 8), new Object[]{"#", Character.valueOf('#'), Block.leavesOak});
        this.addRecipe(new ItemStack(Block.cobbleStone, 2), new Object[]{"##", "##", Character.valueOf('#'), Item.ammoPebble});
        this.addRecipe(new ItemStack(Block.cobbleBasalt, 2), new Object[]{"#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Item.coal});
        this.addRecipe(new ItemStack(Block.cobbleLimestone, 2), new Object[]{"#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Block.sand});
        this.addRecipe(new ItemStack(Block.cobbleGranite, 2), new Object[]{"#X", "X#", Character.valueOf('#'), Item.ammoPebble, Character.valueOf('X'), Item.quartz});
        this.addRecipe(new ItemStack(Block.slatePolished, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.slate});
        this.addRecipe(new ItemStack(Block.stonePolished, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.granitePolished, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.granite});
        this.addRecipe(new ItemStack(Block.limestonePolished, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.limestone});
        this.addRecipe(new ItemStack(Block.basaltPolished, 2), new Object[]{"#", "#", Character.valueOf('#'), Block.basalt});
        this.addShapelessRecipe(new ItemStack(Block.spongeWet, 1), new Object[]{new ItemStack(Block.spongeDry, 1), new ItemStack(Item.bucketWater, 1, 0)});
        this.addShapelessRecipe(new ItemStack(Item.label), new Object[]{Item.string, Item.paper, new ItemStack(Item.dye, 1, 0)});
        Collections.sort(this.recipes, new RecipeSorter(this));
        System.out.println(this.recipes.size() + " recipes");
    }

    void addRecipe(ItemStack itemstack, Object[] aobj) {
        this.addRecipe(itemstack, aobj, false, true);
    }

    void addRecipe(ItemStack itemstack, Object[] aobj, boolean useAlternatives) {
        this.addRecipe(itemstack, aobj, useAlternatives, true);
    }

    void addRecipe(ItemStack itemstack, Object[] aobj, boolean useAlternatives, boolean countForMetadata) {
        String s2 = "";
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        if (aobj[i2] instanceof String[]) {
            String[] as2 = (String[])aobj[i2++];
            for (int l2 = 0; l2 < as2.length; ++l2) {
                String s22 = as2[l2];
                ++k2;
                j2 = s22.length();
                s2 = s2 + s22;
            }
        } else {
            while (aobj[i2] instanceof String) {
                String s1 = (String)aobj[i2++];
                ++k2;
                j2 = s1.length();
                s2 = s2 + s1;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i2 < aobj.length) {
            Character character = (Character)aobj[i2];
            ItemStack itemstack1 = null;
            if (aobj[i2 + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)aobj[i2 + 1]);
            } else if (aobj[i2 + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)aobj[i2 + 1]);
            } else if (aobj[i2 + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)aobj[i2 + 1];
            }
            hashmap.put(character, itemstack1);
            i2 += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j2 * k2];
        for (int i1 = 0; i1 < j2 * k2; ++i1) {
            char c2 = s2.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c2)) ? ((ItemStack)hashmap.get(Character.valueOf(c2))).copy() : null;
        }
        this.recipes.add(new RecipeShaped(j2, k2, aitemstack, itemstack, useAlternatives, countForMetadata));
    }

    void addShapelessRecipe(ItemStack itemstack, Object[] aobj) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (Object obj : aobj) {
            if (obj instanceof ItemStack) {
                arraylist.add(((ItemStack)obj).copy());
                continue;
            }
            if (obj instanceof Item) {
                arraylist.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                arraylist.add(new ItemStack((Block)obj));
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipy!");
        }
        this.recipes.add(new RecipeShapeless(itemstack, arraylist));
    }

    void addRepairableRecipe(Item inItem, Item repairMaterial) {
        this.recipes.add(new RecipeRepairable(inItem, repairMaterial));
    }

    void addRepairableStackableRecipe(Item inItem, ItemStack materialStack) {
        this.recipes.add(new RecipeRepairableStackable(inItem, materialStack));
    }

    void addScrappableRecipe(Item itemToScrap, Item scrapYield) {
        this.recipes.add(new RecipeScrap(itemToScrap, scrapYield));
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inventorycrafting) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            IRecipe irecipe = (IRecipe)this.recipes.get(i2);
            if (!irecipe.matches(inventorycrafting)) continue;
            return irecipe.getCraftingResult(inventorycrafting);
        }
        return null;
    }

    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            IRecipe irecipe = (IRecipe)this.recipes.get(i2);
            if (!irecipe.matches(inventorycrafting)) continue;
            return irecipe.onCraftResult(inventorycrafting);
        }
        return null;
    }

    public List getRecipeList() {
        return this.recipes;
    }
}

