/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.WorldType;

public class Dimension {
    public int dimId;
    public String name;
    public Dimension homeDim;
    public WorldType worldType;
    public float worldScale;
    public int portalBlockId;
    public int minY;
    public int maxY;
    public static final Dimension[] dimensionList = new Dimension[3];
    public static final Dimension overworld = new Dimension(0, "overworld", null, 1.0f, -1).setWorldType(WorldType.overworld).setBounds(0, 256);
    public static final Dimension nether = new Dimension(1, "hell", overworld, 0.125f, Block.portalNether.blockID).setWorldType(WorldType.nether).setBounds(128, 256);
    public static final Dimension paradise = new Dimension(2, "paradise", overworld, 8.0f, Block.portalParadise.blockID).setWorldType(WorldType.paradise).setBounds(0, 128);

    public Dimension(int dimId, String name, Dimension homeDim, float worldScale, int portalBlockId) {
        this.dimId = dimId;
        this.name = name;
        this.homeDim = homeDim;
        this.worldScale = worldScale;
        this.portalBlockId = portalBlockId;
        Dimension.dimensionList[dimId] = this;
    }

    public Dimension setWorldType(WorldType worldType) {
        this.worldType = worldType;
        return this;
    }

    public Dimension setBounds(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public boolean canPortal(Dimension dim) {
        if (this.homeDim == null) {
            return true;
        }
        return dim == this.homeDim;
    }

    public static float getCoordScale(Dimension oldDim, Dimension newDim) {
        if (oldDim.homeDim == newDim) {
            return 1.0f / oldDim.worldScale;
        }
        if (newDim.homeDim == oldDim) {
            return newDim.worldScale;
        }
        return 1.0f;
    }

    public String getName() {
        return StringTranslate.getInstance().translateNamedKey("dimension." + this.name);
    }

    public String toString() {
        return "Dimension: [ ID: " + this.dimId + " Name: " + this.getName() + " ]";
    }
}

