/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityFX;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();

    public EffectRenderer(World world, RenderEngine renderengine) {
        if (world != null) {
            this.worldObj = world;
        }
        this.renderer = renderengine;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.fxLayers[i2] = new ArrayList();
        }
    }

    public void addEffect(EntityFX entityfx) {
        int i2 = entityfx.getFXLayer();
        if (this.fxLayers[i2].size() >= 4000) {
            this.fxLayers[i2].remove(0);
        }
        this.fxLayers[i2].add(entityfx);
    }

    public void updateEffects() {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < this.fxLayers[i2].size(); ++j2) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i2].get(j2);
                entityfx.onUpdate();
                if (!entityfx.isDead) continue;
                this.fxLayers[i2].remove(j2--);
            }
        }
    }

    public void renderParticles(Entity entity, float f2) {
        int l2 = (Integer)Minecraft.getMinecraft().gameSettings.thirdPersonView.value == 2 ? 1 : 0;
        float f1 = MathHelper.cos(entity.rotationYaw * 3.141593f / 180.0f) * (float)(1 - l2 * 2);
        float f22 = MathHelper.sin(entity.rotationYaw * 3.141593f / 180.0f) * (float)(1 - l2 * 2);
        float f3 = -f22 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f) * (float)(1 - l2 * 2);
        float f4 = f1 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f) * (float)(1 - l2 * 2);
        float f5 = MathHelper.cos(entity.rotationPitch * 3.141593f / 180.0f);
        EntityFX.interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f2;
        EntityFX.interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f2;
        EntityFX.interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f2;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.fxLayers[i2].size() == 0) continue;
            int j2 = 0;
            if (i2 == 0) {
                j2 = this.renderer.getTexture("/particles.png");
            }
            if (i2 == 1) {
                j2 = this.renderer.getTexture("/terrain.png");
            }
            if (i2 == 2) {
                j2 = this.renderer.getTexture("/gui/items.png");
            }
            GL11.glBindTexture((int)3553, (int)j2);
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            for (int k2 = 0; k2 < this.fxLayers[i2].size(); ++k2) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i2].get(k2);
                entityfx.renderParticle(tessellator, f2, f1, f5, f22, f3, f4);
            }
            tessellator.draw();
        }
    }

    public void func_1187_b(Entity entity, float f2) {
        int byte0 = 3;
        if (this.fxLayers[byte0].size() == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.instance;
        for (int i2 = 0; i2 < this.fxLayers[byte0].size(); ++i2) {
            EntityFX entityfx = (EntityFX)this.fxLayers[byte0].get(i2);
            entityfx.renderParticle(tessellator, f2, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void clearEffects(World world) {
        this.worldObj = world;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.fxLayers[i2].clear();
        }
    }

    public void addBlockDestroyEffects(int i2, int j2, int k2, int l2, int i1) {
        if (l2 == 0) {
            return;
        }
        Block block = Block.blocksList[l2];
        int j1 = 4;
        for (int k1 = 0; k1 < j1; ++k1) {
            for (int l1 = 0; l1 < j1; ++l1) {
                for (int i22 = 0; i22 < j1; ++i22) {
                    double d2 = (double)i2 + ((double)k1 + 0.5) / (double)j1;
                    double d1 = (double)j2 + ((double)l1 + 0.5) / (double)j1;
                    double d22 = (double)k2 + ((double)i22 + 0.5) / (double)j1;
                    int j22 = this.rand.nextInt(6);
                    this.addEffect(new EntityDiggingFX(this.worldObj, d2, d1, d22, d2 - (double)i2 - 0.5, d1 - (double)j2 - 0.5, d22 - (double)k2 - 0.5, block, j22, i1).func_4041_a(i2, j2, k2));
                }
            }
        }
    }

    public void addBlockHitEffects(int i2, int j2, int k2, int l2) {
        int i1 = this.worldObj.getBlockId(i2, j2, k2);
        if (i1 == 0) {
            return;
        }
        Block block = Block.blocksList[i1];
        float f2 = 0.1f;
        double d2 = (double)i2 + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f2 * 2.0f)) + (double)f2 + block.minX;
        double d1 = (double)j2 + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f2 * 2.0f)) + (double)f2 + block.minY;
        double d22 = (double)k2 + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f2 * 2.0f)) + (double)f2 + block.minZ;
        if (l2 == 0) {
            d1 = (double)j2 + block.minY - (double)f2;
        }
        if (l2 == 1) {
            d1 = (double)j2 + block.maxY + (double)f2;
        }
        if (l2 == 2) {
            d22 = (double)k2 + block.minZ - (double)f2;
        }
        if (l2 == 3) {
            d22 = (double)k2 + block.maxZ + (double)f2;
        }
        if (l2 == 4) {
            d2 = (double)i2 + block.minX - (double)f2;
        }
        if (l2 == 5) {
            d2 = (double)i2 + block.maxX + (double)f2;
        }
        this.addEffect(new EntityDiggingFX(this.worldObj, d2, d1, d22, 0.0, 0.0, 0.0, block, l2, this.worldObj.getBlockMetadata(i2, j2, k2)).func_4041_a(i2, j2, k2).func_407_b(0.2f).func_405_d(0.6f));
    }

    public String getStatistics() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

