/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.DataWatcher;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagDouble;
import net.minecraft.src.NBTTagFloat;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.StepSound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public abstract class Entity {
    private static int nextEntityID = 0;
    public int entityId;
    public double renderDistanceWeight = 1.0;
    public boolean preventEntitySpawning = false;
    public Entity riddenByEntity;
    public Entity ridingEntity;
    public World worldObj;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean isCollidedHorizontally;
    public boolean isCollidedVertically;
    public boolean isCollided = false;
    public boolean beenAttacked = false;
    public boolean hadNicknameSet;
    public boolean isInWeb;
    public boolean field_9293_aM = true;
    public boolean isDead = false;
    public float yOffset = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified = 0.0f;
    public float distanceWalkedModified = 0.0f;
    protected float fallDistance = 0.0f;
    private int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float ySize = 0.0f;
    public float stepHeight = 0.0f;
    public boolean noClip = false;
    public float entityCollisionReduction = 0.0f;
    protected Random rand;
    public int ticksExisted = 0;
    public int fireResistance = 1;
    public int fire = 0;
    public int maxFire;
    protected int maxAir = 300;
    protected boolean inWater = false;
    public int heartsFlashTime = 0;
    public int air = 300;
    private boolean isFirstUpdate = true;
    protected boolean isImmuneToFire = false;
    protected DataWatcher dataWatcher;
    public float entityBrightness = 0.0f;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isWalking = false;

    public Entity(World world) {
        this.entityId = nextEntityID++;
        this.rand = new Random();
        this.dataWatcher = new DataWatcher();
        this.worldObj = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataWatcher.addObject(0, (byte)0);
        this.entityInit();
    }

    protected abstract void entityInit();

    public void entityInitOnSpawn() {
    }

    public DataWatcher getDataWatcher() {
        return this.dataWatcher;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            return ((Entity)obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void preparePlayerToSpawn() {
        if (this.worldObj == null) {
            return;
        }
        while (!(this.posY <= 0.0)) {
            this.setPosition(this.posX, this.posY, this.posZ);
            if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0) break;
            this.posY += 1.0;
        }
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.rotationPitch = 0.0f;
    }

    public void setEntityDead() {
        this.isDead = true;
    }

    protected void setSize(float f2, float f1) {
        this.width = f2;
        this.height = f1;
    }

    protected void setRotation(float f2, float f1) {
        this.rotationYaw = f2 % 360.0f;
        this.rotationPitch = f1 % 360.0f;
    }

    public void setPosition(double x2, double y2, double z2) {
        this.posX = x2;
        this.posY = y2;
        this.posZ = z2;
        float center = this.width / 2.0f;
        float heightOfMob = this.height;
        this.boundingBox.setBounds(x2 - (double)center, y2 - (double)this.yOffset + (double)this.ySize, z2 - (double)center, x2 + (double)center, y2 - (double)this.yOffset + (double)this.ySize + (double)heightOfMob, z2 + (double)center);
    }

    public void rotate(float f2, float f1) {
        float f22 = this.rotationPitch;
        float f3 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)f2 * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)f1 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.prevRotationPitch += this.rotationPitch - f22;
        this.prevRotationYaw += this.rotationYaw - f3;
    }

    public void onUpdate() {
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        if (this.ridingEntity != null && this.ridingEntity.isDead) {
            this.ridingEntity = null;
        }
        ++this.ticksExisted;
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.handleWaterMovement()) {
            if (!this.inWater && !this.isFirstUpdate) {
                float f2 = MathHelper.sqrt_double(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.worldObj.playSoundAtEntity(this, "random.splash", f2, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int i2 = 0;
                while ((float)i2 < 1.0f + this.width * 20.0f) {
                    float f22 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f22, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++i2;
                }
                int j2 = 0;
                while ((float)j2 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j2;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fire = 0;
        } else {
            this.inWater = false;
        }
        if (this.worldObj.isMultiplayerAndNotHost) {
            this.fire = 0;
        } else if (this.fire > 0) {
            if (this.isImmuneToFire) {
                this.fire -= 4;
                if (this.fire < 0) {
                    this.fire = 0;
                }
            } else {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(null, 1, DamageType.FIRE);
                }
                --this.fire;
            }
        }
        if (this.handleLavaMovement()) {
            this.setOnFireFromLava();
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            this.setEntityFlag(0, this.fire > 0);
            this.setEntityFlag(2, this.ridingEntity != null);
        }
        this.isFirstUpdate = false;
    }

    protected void setOnFireFromLava() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, 4, DamageType.FIRE);
            this.maxFire = this.fire = 600;
        }
    }

    protected void setOnFire() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, 1, DamageType.FIRE);
            this.maxFire = this.fire = 300;
        }
    }

    protected void kill() {
        this.setEntityDead();
    }

    public boolean isOffsetPositionInLiquid(double d2, double d1, double d22) {
        AxisAlignedBB axisalignedbb = this.boundingBox.getOffsetBoundingBox(d2, d1, d22);
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.getIsAnyLiquid(axisalignedbb);
    }

    public void moveEntity(double x2, double y2, double z2) {
        int i4;
        int l3;
        int k3;
        int i2;
        int k1;
        int i1;
        boolean flag;
        if (this.noClip) {
            this.boundingBox.offset(x2, y2, z2);
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
            return;
        }
        this.ySize *= 0.4f;
        double d3 = this.posX;
        double d4 = this.posZ;
        if (this.isInWeb) {
            this.isInWeb = false;
            x2 *= 0.25;
            y2 *= (double)0.05f;
            z2 *= 0.25;
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        double d5 = x2;
        double d6 = y2;
        double d7 = z2;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        boolean bl2 = flag = this.onGround && this.isSneaking();
        if (flag) {
            double d8 = 0.05;
            while (x2 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(x2, -1.0, 0.0)).size() == 0) {
                x2 = x2 < d8 && x2 >= -d8 ? 0.0 : (x2 > 0.0 ? (x2 -= d8) : (x2 += d8));
                d5 = x2;
            }
            while (z2 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(0.0, -1.0, z2)).size() == 0) {
                z2 = z2 < d8 && z2 >= -d8 ? 0.0 : (z2 > 0.0 ? (z2 -= d8) : (z2 += d8));
                d7 = z2;
            }
        }
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(x2, y2, z2));
        for (int i3 = 0; i3 < list.size(); ++i3) {
            y2 = list.get(i3).calculateYOffset(this.boundingBox, y2);
        }
        this.boundingBox.offset(0.0, y2, 0.0);
        if (!this.field_9293_aM && d6 != y2) {
            z2 = 0.0;
            y2 = 0.0;
            x2 = 0.0;
        }
        boolean flag1 = this.onGround || d6 != y2 && d6 < 0.0;
        for (int j2 = 0; j2 < list.size(); ++j2) {
            x2 = list.get(j2).calculateXOffset(this.boundingBox, x2);
        }
        this.boundingBox.offset(x2, 0.0, 0.0);
        if (!this.field_9293_aM && d5 != x2) {
            z2 = 0.0;
            y2 = 0.0;
            x2 = 0.0;
        }
        for (int k2 = 0; k2 < list.size(); ++k2) {
            z2 = list.get(k2).calculateZOffset(this.boundingBox, z2);
        }
        this.boundingBox.offset(0.0, 0.0, z2);
        if (!this.field_9293_aM && d7 != z2) {
            z2 = 0.0;
            y2 = 0.0;
            x2 = 0.0;
        }
        if (this.stepHeight > 0.0f && flag1 && (flag || this.ySize < 0.05f) && (d5 != x2 || d7 != z2)) {
            double oldX = x2;
            double oldY = y2;
            double oldZ = z2;
            x2 = d5;
            y2 = this.stepHeight;
            z2 = d7;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.copy();
            this.boundingBox.setBB(axisalignedbb);
            List<AxisAlignedBB> list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(x2, y2, z2));
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                y2 = list1.get(j2).calculateYOffset(this.boundingBox, y2);
            }
            this.boundingBox.offset(0.0, y2, 0.0);
            if (!this.field_9293_aM && d6 != y2) {
                z2 = 0.0;
                y2 = 0.0;
                x2 = 0.0;
            }
            for (int k2 = 0; k2 < list1.size(); ++k2) {
                x2 = list1.get(k2).calculateXOffset(this.boundingBox, x2);
            }
            this.boundingBox.offset(x2, 0.0, 0.0);
            if (!this.field_9293_aM && d5 != x2) {
                z2 = 0.0;
                y2 = 0.0;
                x2 = 0.0;
            }
            for (int l2 = 0; l2 < list1.size(); ++l2) {
                z2 = list1.get(l2).calculateZOffset(this.boundingBox, z2);
            }
            this.boundingBox.offset(0.0, 0.0, z2);
            if (!this.field_9293_aM && d7 != z2) {
                z2 = 0.0;
                y2 = 0.0;
                x2 = 0.0;
            }
            if (!this.field_9293_aM && d6 != y2) {
                z2 = 0.0;
                y2 = 0.0;
                x2 = 0.0;
            } else {
                y2 = -this.stepHeight;
                for (int i3 = 0; i3 < list1.size(); ++i3) {
                    y2 = list1.get(i3).calculateYOffset(this.boundingBox, y2);
                }
                this.boundingBox.offset(0.0, y2, 0.0);
            }
            if (oldX * oldX + oldZ * oldZ >= x2 * x2 + z2 * z2) {
                x2 = oldX;
                y2 = oldY;
                z2 = oldZ;
                this.boundingBox.setBB(axisalignedbb1);
            }
        }
        if (!this.worldObj.isMultiplayerAndNotHost || this instanceof EntityPlayer || !(this instanceof EntityLiving)) {
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        }
        this.isCollidedHorizontally = d5 != x2 || d7 != z2;
        this.isCollidedVertically = d6 != y2;
        this.onGround = d6 != y2 && d6 < 0.0;
        this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
        this.updateFallState(y2, this.onGround);
        if (d5 != x2) {
            this.motionX = 0.0;
        }
        if (d6 != y2) {
            this.motionY = 0.0;
        }
        if (d7 != z2) {
            this.motionZ = 0.0;
        }
        double d10 = this.posX - d3;
        double d12 = this.posZ - d4;
        if (this.canTriggerWalking() && !flag && this.ridingEntity == null) {
            this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt_double(d10 * d10 + d12 * d12) * 0.6);
            int l2 = MathHelper.floor_double(this.posX);
            int j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset);
            int l1 = MathHelper.floor_double(this.posZ);
            int j3 = this.worldObj.getBlockId(l2, j1, l1);
            if (this.worldObj.getBlockId(l2, j1 - 1, l1) == Block.fencePlanksOak.blockID) {
                j3 = this.worldObj.getBlockId(l2, j1 - 1, l1);
            }
            this.isWalking = this.prevDistanceWalkedModified != this.distanceWalkedModified;
            if (this.distanceWalkedModified > (float)this.nextStepDistance && j3 > 0) {
                ++this.nextStepDistance;
                StepSound stepsound = Block.blocksList[j3].stepSound;
                if (this.worldObj.getBlockId(l2, j1 + 1, l1) == Block.layerSnow.blockID) {
                    stepsound = Block.layerSnow.stepSound;
                    this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
                } else if (!Block.blocksList[j3].blockMaterial.getIsLiquid()) {
                    this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
                }
                Block.blocksList[j3].onEntityWalking(this.worldObj, l2, j1, l1, this);
            }
        }
        if (this.worldObj.checkChunksExist(i1 = MathHelper.floor_double(this.boundingBox.minX + 0.001), k1 = MathHelper.floor_double(this.boundingBox.minY + 0.001), i2 = MathHelper.floor_double(this.boundingBox.minZ + 0.001), k3 = MathHelper.floor_double(this.boundingBox.maxX - 0.001), l3 = MathHelper.floor_double(this.boundingBox.maxY - 0.001), i4 = MathHelper.floor_double(this.boundingBox.maxZ - 0.001))) {
            for (int j4 = i1; j4 <= k3; ++j4) {
                for (int k4 = k1; k4 <= l3; ++k4) {
                    for (int l4 = i2; l4 <= i4; ++l4) {
                        int i5 = this.worldObj.getBlockId(j4, k4, l4);
                        if (i5 <= 0) continue;
                        Block.blocksList[i5].onEntityCollidedWithBlock(this.worldObj, j4, k4, l4, this);
                    }
                }
            }
        }
        boolean flag2 = this.isWet();
        if (this.worldObj.isBoundingBoxBurning(this.boundingBox.getInsetBoundingBox(0.001, 0.001, 0.001))) {
            this.dealFireDamage(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.fire = 300;
                }
                this.maxFire = this.fire;
            }
        } else if (this.fire <= 0) {
            this.fire = -this.fireResistance;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.fireResistance;
        }
    }

    protected boolean canTriggerWalking() {
        return true;
    }

    protected void updateFallState(double d2, boolean flag) {
        if (flag) {
            if (this.fallDistance > 0.0f) {
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d2 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d2);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    protected void dealFireDamage(int i2) {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, i2, DamageType.FIRE);
        }
    }

    protected void fall(float f2) {
        if (this.riddenByEntity != null) {
            this.riddenByEntity.fall(f2);
        }
    }

    public boolean isWet() {
        return this.inWater || this.worldObj.canBlockBeRainedOn(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0).getInsetBoundingBox(0.001, 0.001, 0.001), Material.water, this);
    }

    public boolean isInsideOfMaterial(Material material) {
        int k2;
        int j2;
        double d2 = this.posY + (double)this.getEyeHeight();
        int i2 = MathHelper.floor_double(this.posX);
        int l2 = this.worldObj.getBlockId(i2, j2 = MathHelper.floor_float(MathHelper.floor_double(d2)), k2 = MathHelper.floor_double(this.posZ));
        if (l2 != 0 && Block.blocksList[l2].blockMaterial == material) {
            float f2 = BlockFluid.getPercentAir(this.worldObj.getBlockMetadata(i2, j2, k2)) - 0.2f;
            float f1 = (float)(j2 + 1) - f2;
            return d2 < (double)f1;
        }
        return false;
    }

    public float getEyeHeight() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand(-0.1f, -0.4f, -0.1f), Material.lava);
    }

    public void moveFlying(float f2, float f1, float f22) {
        float f3 = MathHelper.sqrt_float(f2 * f2 + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f22 / f3;
        f2 *= f3;
        f1 *= f3;
        if (this instanceof EntityPlayer && Minecraft.getMinecraft().isometricMode) {
            this.motionX = -f1 * 2.0f;
            this.motionZ = f2 * 2.0f;
            return;
        }
        float f4 = MathHelper.sin(this.rotationYaw * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(this.rotationYaw * 3.141593f / 180.0f);
        this.motionX += (double)(f2 * f5 - f1 * f4);
        this.motionZ += (double)(f1 * f5 + f2 * f4);
    }

    public float getEntityBrightness(float f2) {
        int i2 = MathHelper.floor_double(this.posX);
        double d2 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
        int j2 = MathHelper.floor_double(this.posY - (double)this.yOffset + d2);
        int k2 = MathHelper.floor_double(this.posZ);
        if (this.worldObj.checkChunksExist(MathHelper.floor_double(this.boundingBox.minX), MathHelper.floor_double(this.boundingBox.minY), MathHelper.floor_double(this.boundingBox.minZ), MathHelper.floor_double(this.boundingBox.maxX), MathHelper.floor_double(this.boundingBox.maxY), MathHelper.floor_double(this.boundingBox.maxZ))) {
            float f1 = this.worldObj.getLightBrightness(i2, j2, k2);
            if (f1 < this.entityBrightness) {
                f1 = this.entityBrightness;
            }
            return f1;
        }
        return this.entityBrightness;
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public void setPositionAndRotation(double d2, double d1, double d22, float f2, float f1) {
        this.prevPosX = this.posX = d2;
        this.prevPosY = this.posY = d1;
        this.prevPosZ = this.posZ = d22;
        this.prevRotationYaw = this.rotationYaw = f2;
        this.prevRotationPitch = this.rotationPitch = f1;
        this.ySize = 0.0f;
        double d3 = this.prevRotationYaw - f2;
        if (d3 < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (d3 >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(f2, f1);
    }

    public void setLocationAndAngles(double d2, double d1, double d22, float f2, float f1) {
        this.prevPosX = this.posX = d2;
        this.lastTickPosX = this.posX;
        this.prevPosY = this.posY = d1 + (double)this.yOffset;
        this.lastTickPosY = this.posY;
        this.prevPosZ = this.posZ = d22;
        this.lastTickPosZ = this.posZ;
        this.rotationYaw = f2;
        this.rotationPitch = f1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity entity) {
        float f2 = (float)(this.posX - entity.posX);
        float f1 = (float)(this.posY - entity.posY);
        float f22 = (float)(this.posZ - entity.posZ);
        return MathHelper.sqrt_float(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double getDistanceSq(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double getDistance(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d2 = this.posX - entity.posX;
        double d1 = this.posY - entity.posY;
        double d22 = this.posZ - entity.posZ;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    public void applyEntityCollision(Entity entity) {
        if (entity.riddenByEntity == this || entity.ridingEntity == this || entity.noClip) {
            return;
        }
        double d2 = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d22 = MathHelper.abs_max(d2, d1);
        if (d22 >= (double)0.01f) {
            d22 = MathHelper.sqrt_double(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity(-(d2 *= (double)(1.0f - this.entityCollisionReduction)), 0.0, -(d1 *= (double)(1.0f - this.entityCollisionReduction)));
            entity.addVelocity(d2, 0.0, d1);
        }
    }

    public void addVelocity(double d2, double d1, double d22) {
        this.motionX += d2;
        this.motionY += d1;
        this.motionZ += d22;
    }

    protected void setBeenAttacked() {
        this.beenAttacked = true;
    }

    public boolean attackEntityFrom(Entity attacker, int baseDamage, DamageType type) {
        this.setBeenAttacked();
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity entity, int i2) {
    }

    public boolean isInRangeToRenderVec3D(Vec3D vec3d) {
        double d2 = this.posX - vec3d.xCoord;
        double d1 = this.posY - vec3d.yCoord;
        double d22 = this.posZ - vec3d.zCoord;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.isInRangeToRenderDist(d3);
    }

    public boolean isInRangeToRenderDist(double d2) {
        double d1 = this.boundingBox.getAverageEdgeLength();
        return d2 < (d1 *= 64.0 * this.renderDistanceWeight) * d1;
    }

    public String getEntityTexture() {
        return null;
    }

    public boolean addEntityID(NBTTagCompound nbttagcompound) {
        String s2 = this.getEntityString();
        if (this.isDead || s2 == null) {
            return false;
        }
        nbttagcompound.setString("id", s2);
        this.writeToNBT(nbttagcompound);
        return true;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setTag("Pos", this.newDoubleNBTList(new double[]{this.posX, this.posY + (double)this.ySize, this.posZ}));
        nbttagcompound.setTag("Motion", this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbttagcompound.setTag("Rotation", this.newFloatNBTList(new float[]{this.rotationYaw, this.rotationPitch}));
        nbttagcompound.setFloat("FallDistance", this.fallDistance);
        nbttagcompound.setShort("Fire", (short)this.fire);
        nbttagcompound.setShort("Air", (short)this.air);
        nbttagcompound.setBoolean("OnGround", this.onGround);
        this.writeEntityToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.getTagList("Pos");
        NBTTagList nbttaglist1 = nbttagcompound.getTagList("Motion");
        NBTTagList nbttaglist2 = nbttagcompound.getTagList("Rotation");
        this.motionX = ((NBTTagDouble)nbttaglist1.tagAt((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)nbttaglist1.tagAt((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)nbttaglist1.tagAt((int)2)).doubleValue;
        if (Math.abs(this.motionX) > 10.0) {
            this.motionX = 0.0;
        }
        if (Math.abs(this.motionY) > 10.0) {
            this.motionY = 0.0;
        }
        if (Math.abs(this.motionZ) > 10.0) {
            this.motionZ = 0.0;
        }
        this.lastTickPosX = this.posX = ((NBTTagDouble)nbttaglist.tagAt((int)0)).doubleValue;
        this.prevPosX = this.posX;
        this.lastTickPosY = this.posY = ((NBTTagDouble)nbttaglist.tagAt((int)1)).doubleValue;
        this.prevPosY = this.posY;
        this.lastTickPosZ = this.posZ = ((NBTTagDouble)nbttaglist.tagAt((int)2)).doubleValue;
        this.prevPosZ = this.posZ;
        this.prevRotationYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.tagAt((int)0)).floatValue;
        this.prevRotationPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.tagAt((int)1)).floatValue;
        this.fallDistance = nbttagcompound.getFloat("FallDistance");
        this.maxFire = this.fire = (int)nbttagcompound.getShort("Fire");
        this.air = nbttagcompound.getShort("Air");
        this.onGround = nbttagcompound.getBoolean("OnGround");
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        this.readEntityFromNBT(nbttagcompound);
    }

    protected final String getEntityString() {
        return EntityList.getEntityString(this);
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double[] ad2) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d2 : ad2) {
            nbttaglist.setTag(new NBTTagDouble(d2));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float[] af2) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float f2 : af2) {
            nbttaglist.setTag(new NBTTagFloat(f2));
        }
        return nbttaglist;
    }

    public float getShadowSize() {
        return this.height / 2.0f;
    }

    public EntityItem dropItem(int i2, int j2) {
        return this.dropItemWithOffset(i2, j2, 0.0f);
    }

    public EntityItem dropItemWithOffset(int i2, int j2, float f2) {
        return this.entityDropItem(new ItemStack(i2, j2, 0), f2);
    }

    public EntityItem entityDropItem(ItemStack itemstack, float f2) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)f2, this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 10;
        this.worldObj.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        for (int i2 = 0; i2 < 8; ++i2) {
            int l2;
            int k2;
            float f2 = ((float)((i2 >> 0) % 2) - 0.5f) * this.width * 0.9f;
            float f1 = ((float)((i2 >> 1) % 2) - 0.5f) * 0.1f;
            float f22 = ((float)((i2 >> 2) % 2) - 0.5f) * this.width * 0.9f;
            int j2 = MathHelper.floor_double(this.posX + (double)f2);
            if (!this.worldObj.isBlockNormalCube(j2, k2 = MathHelper.floor_double(this.posY + (double)this.getEyeHeight() + (double)f1), l2 = MathHelper.floor_double(this.posZ + (double)f22))) continue;
            return true;
        }
        return false;
    }

    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public AxisAlignedBB getCollisionBox(Entity entity) {
        return null;
    }

    public void updateRidden() {
        if (this.ridingEntity.isDead) {
            this.ridingEntity = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.onUpdate();
        if (this.ridingEntity == null) {
            return;
        }
        this.ridingEntity.updateRiderPosition();
        this.entityRiderYawDelta += (double)(this.ridingEntity.rotationYaw - this.ridingEntity.prevRotationYaw);
        this.entityRiderPitchDelta += (double)(this.ridingEntity.rotationPitch - this.ridingEntity.prevRotationPitch);
        while (this.entityRiderYawDelta >= 180.0) {
            this.entityRiderYawDelta -= 360.0;
        }
        while (this.entityRiderYawDelta < -180.0) {
            this.entityRiderYawDelta += 360.0;
        }
        while (this.entityRiderPitchDelta >= 180.0) {
            this.entityRiderPitchDelta -= 360.0;
        }
        while (this.entityRiderPitchDelta < -180.0) {
            this.entityRiderPitchDelta += 360.0;
        }
        double d2 = this.entityRiderYawDelta * 0.5;
        double d1 = this.entityRiderPitchDelta * 0.5;
        float f2 = 10.0f;
        if (d2 > (double)f2) {
            d2 = f2;
        }
        if (d2 < (double)(-f2)) {
            d2 = -f2;
        }
        if (d1 > (double)f2) {
            d1 = f2;
        }
        if (d1 < (double)(-f2)) {
            d1 = -f2;
        }
        this.entityRiderYawDelta -= d2;
        this.entityRiderPitchDelta -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d2);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    public void updateRiderPosition() {
        this.riddenByEntity.setPosition(this.posX, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ);
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public void mountEntity(Entity entity) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (entity == null) {
            if (this.ridingEntity != null) {
                this.setLocationAndAngles(this.ridingEntity.posX, this.ridingEntity.boundingBox.minY + (double)this.ridingEntity.height, this.ridingEntity.posZ, this.rotationYaw, this.rotationPitch);
                this.ridingEntity.riddenByEntity = null;
            }
            this.ridingEntity = null;
            return;
        }
        if (this.ridingEntity == entity) {
            this.ridingEntity.ejectEntity();
            return;
        }
        if (this.ridingEntity != null) {
            this.ridingEntity.riddenByEntity = null;
        }
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.ridingEntity = null;
        }
        this.ridingEntity = entity;
        entity.riddenByEntity = this;
    }

    public Entity ejectEntity() {
        Entity entity = this.riddenByEntity;
        if (entity == null) {
            return null;
        }
        this.riddenByEntity = null;
        entity.ridingEntity = null;
        entity.setLocationAndAngles(this.posX, this.boundingBox.minY, this.posZ, entity.rotationYaw, entity.rotationPitch);
        return entity;
    }

    public void setPositionAndRotation2(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.setPosition(d2, d1, d22);
        this.setRotation(f2, f1);
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getInsetBoundingBox(0.03125, 0.0, 0.03125));
        if (list.size() > 0) {
            double d3 = 0.0;
            for (int j2 = 0; j2 < list.size(); ++j2) {
                AxisAlignedBB axisalignedbb = list.get(j2);
                if (!(axisalignedbb.maxY > d3)) continue;
                d3 = axisalignedbb.maxY;
            }
            this.setPosition(d2, d1 += d3 - this.boundingBox.minY, d22);
        }
    }

    public float getCollisionBorderSize() {
        return 0.1f;
    }

    public Vec3D getLookVec() {
        return null;
    }

    public void setInPortal(int portalID) {
    }

    public ItemStack[] getInventory() {
        return null;
    }

    public void setVelocity(double d2, double d1, double d22) {
        this.motionX = d2;
        this.motionY = d1;
        this.motionZ = d22;
    }

    public void handleEntityStatus(byte byte0, float attackedAtYaw) {
    }

    public void performHurtAnimation() {
    }

    public void updateCloak() {
    }

    public void outfitWithItem(int i2, int j2, int k2, NBTTagCompound tag) {
    }

    public boolean isBurning() {
        return this.fire > 0 || this.getEntityFlag(0);
    }

    public boolean isRiding() {
        return this.ridingEntity != null || this.getEntityFlag(2);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    public void setSneaking(boolean flag) {
        this.setEntityFlag(1, flag);
    }

    protected boolean getEntityFlag(int i2) {
        return (this.dataWatcher.getWatchableObjectByte(0) & 1 << i2) != 0;
    }

    protected void setEntityFlag(int i2, boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(0);
        if (flag) {
            this.dataWatcher.updateObject(0, (byte)(byte0 | 1 << i2));
        } else {
            this.dataWatcher.updateObject(0, (byte)(byte0 & ~(1 << i2)));
        }
    }

    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
        this.dealFireDamage(5);
        ++this.fire;
        if (this.fire == 0) {
            this.fire = 300;
        }
        this.maxFire = this.fire;
    }

    public void onKillEntity(EntityLiving entityliving) {
    }

    protected boolean pushOutOfBlocks(double d2, double d1, double d22) {
        int i2 = MathHelper.floor_double(d2);
        int j2 = MathHelper.floor_double(d1);
        int k2 = MathHelper.floor_double(d22);
        double d3 = d2 - (double)i2;
        double d4 = d1 - (double)j2;
        double d5 = d22 - (double)k2;
        if (this.worldObj.isBlockNormalCube(i2, j2, k2)) {
            boolean flag = !this.worldObj.isBlockNormalCube(i2 - 1, j2, k2);
            boolean flag1 = !this.worldObj.isBlockNormalCube(i2 + 1, j2, k2);
            boolean flag2 = !this.worldObj.isBlockNormalCube(i2, j2 - 1, k2);
            boolean flag3 = !this.worldObj.isBlockNormalCube(i2, j2 + 1, k2);
            boolean flag4 = !this.worldObj.isBlockNormalCube(i2, j2, k2 - 1);
            boolean flag5 = !this.worldObj.isBlockNormalCube(i2, j2, k2 + 1);
            int byte0 = -1;
            double d6 = 9999.0;
            if (flag && d3 < d6) {
                d6 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d6) {
                d6 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d6) {
                d6 = d4;
                byte0 = 2;
            }
            if (flag3 && 1.0 - d4 < d6) {
                d6 = 1.0 - d4;
                byte0 = 3;
            }
            if (flag4 && d5 < d6) {
                d6 = d5;
                byte0 = 4;
            }
            if (flag5 && 1.0 - d5 < d6) {
                double d7 = 1.0 - d5;
                byte0 = 5;
            }
            float f2 = this.rand.nextFloat() * 0.2f + 0.1f;
            if (byte0 == 0) {
                this.motionX = -f2;
            }
            if (byte0 == 1) {
                this.motionX = f2;
            }
            if (byte0 == 2) {
                this.motionY = -f2;
            }
            if (byte0 == 3) {
                this.motionY = f2;
            }
            if (byte0 == 4) {
                this.motionZ = -f2;
            }
            if (byte0 == 5) {
                this.motionZ = f2;
            }
        }
        return false;
    }
}

