/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityCannonball
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    public EntityLiving owner;

    public EntityCannonball(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
    }

    public EntityCannonball(World world, double d2, double d1, double d22) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.setPosition(d2, d1, d22);
        this.yOffset = 0.0f;
    }

    public EntityCannonball(World world, EntityLiving entityliving) {
        super(world);
        this.owner = entityliving;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY + (double)entityliving.getEyeHeight(), entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f);
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f);
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f);
        this.setCannonballHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    public void setCannonballHeading(double d2, double d1, double d22, float f2, float f1) {
        float f22 = MathHelper.sqrt_double(d2 * d2 + d1 * d1 + d22 * d22);
        d2 /= (double)f22;
        d1 /= (double)f22;
        d22 /= (double)f22;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d22 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d2 *= (double)f2;
        this.motionY = d1 *= (double)f2;
        this.motionZ = d22 *= (double)f2;
        float f3 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
    }

    @Override
    public void setVelocity(double d2, double d1, double d22) {
        this.motionX = d2;
        this.motionY = d1;
        this.motionZ = d22;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f2 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f2) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    @Override
    public void onUpdate() {
        Vec3D vec3d1;
        int i2;
        super.onUpdate();
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f2 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / 3.1415927410125732);
        }
        if ((i2 = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile)) > 0) {
            this.worldObj.newExplosion(this, this.posX, this.posY, this.posZ, 1.5f, false, true);
            this.setEntityDead();
            return;
        }
        Vec3D vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        MovingObjectPosition movingobjectposition = this.worldObj.func_28105_a(vec3d, vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ), false, true);
        if (movingobjectposition != null) {
            this.xTile = movingobjectposition.blockX;
            this.yTile = movingobjectposition.blockY;
            this.zTile = movingobjectposition.blockZ;
            this.motionX = (float)(movingobjectposition.hitVec.xCoord - this.posX);
            this.motionY = (float)(movingobjectposition.hitVec.yCoord - this.posY);
            this.motionZ = (float)(movingobjectposition.hitVec.zCoord - this.posZ);
            float f1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
            this.posX -= this.motionX / (double)f1 * (double)0.05f;
            this.posY -= this.motionY / (double)f1 * (double)0.05f;
            this.posZ -= this.motionZ / (double)f1 * (double)0.05f;
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f2 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f3 = 0.88f;
        float f5 = 0.09f;
        if (this.isInWater()) {
            for (int i1 = 0; i1 < 4; ++i1) {
                float f6 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f6, this.posY - this.motionY * (double)f6, this.posZ - this.motionZ * (double)f6, this.motionX, this.motionY, this.motionZ);
            }
            f3 = 0.8f;
        }
        this.worldObj.spawnParticle("largesmoke", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        this.motionX *= (double)f3;
        this.motionY *= (double)f3;
        this.motionZ *= (double)f3;
        this.motionY -= (double)f5;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("xTile", (short)this.xTile);
        nbttagcompound.setShort("xTile", (short)this.xTile);
        nbttagcompound.setShort("yTile", (short)this.yTile);
        nbttagcompound.setShort("zTile", (short)this.zTile);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.getShort("xTile");
        this.yTile = nbttagcompound.getShort("yTile");
        this.zTile = nbttagcompound.getShort("zTile");
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

