/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.GuiGuidebook;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet107UpdateCreativeInventory;
import net.minecraft.src.Packet108SetHotbarOffset;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet11PlayerPosition;
import net.minecraft.src.Packet12PlayerLook;
import net.minecraft.src.Packet133OpenGuidebook;
import net.minecraft.src.Packet135PlacementMode;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet19EntityAction;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityClientPlayerMP
extends EntityPlayerSP {
    public NetClientHandler sendQueue;
    private int field_9380_bx = 0;
    private boolean field_21093_bH = false;
    private double oldPosX;
    private double field_9378_bz;
    private double oldPosY;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private boolean field_9382_bF = false;
    private boolean wasSneaking = false;
    private int field_12242_bI = 0;

    public EntityClientPlayerMP(Minecraft minecraft, World world, Session session, NetClientHandler netclienthandler) {
        super(minecraft, world, session, 0);
        this.sendQueue = netclienthandler;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        return false;
    }

    @Override
    public void heal(int i2) {
    }

    @Override
    public void onUpdate() {
        if (!this.worldObj.blockExists(MathHelper.floor_double(this.posX), 64, MathHelper.floor_double(this.posZ))) {
            return;
        }
        super.onUpdate();
        this.func_4056_N();
    }

    public void func_4056_N() {
        boolean flag2;
        boolean flag;
        if (this.field_9380_bx++ == 20) {
            this.sendInventoryChanged();
            this.field_9380_bx = 0;
        }
        if ((flag = this.isSneaking()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 1));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 2));
            }
            this.wasSneaking = flag;
        }
        double d2 = this.posX - this.oldPosX;
        double d1 = this.boundingBox.minY - this.field_9378_bz;
        double d22 = this.posY - this.oldPosY;
        double d3 = this.posZ - this.oldPosZ;
        double d4 = this.rotationYaw - this.oldRotationYaw;
        double d5 = this.rotationPitch - this.oldRotationPitch;
        boolean flag1 = d1 != 0.0 || d22 != 0.0 || d2 != 0.0 || d3 != 0.0;
        boolean bl2 = flag2 = d4 != 0.0 || d5 != 0.0;
        if (this.ridingEntity != null) {
            if (flag2) {
                this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.motionX, -999.0, -999.0, this.motionZ, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.motionX, -999.0, -999.0, this.motionZ, this.rotationYaw, this.rotationPitch, this.onGround));
            }
            flag1 = false;
        } else if (flag1 && flag2) {
            this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.rotationYaw, this.rotationPitch, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag1) {
            this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new Packet12PlayerLook(this.rotationYaw, this.rotationPitch, this.onGround));
            this.field_12242_bI = 0;
        } else {
            this.sendQueue.addToSendQueue(new Packet10Flying(this.onGround));
            this.field_12242_bI = this.field_9382_bF != this.onGround || this.field_12242_bI > 200 ? 0 : ++this.field_12242_bI;
        }
        this.field_9382_bF = this.onGround;
        if (flag1) {
            this.oldPosX = this.posX;
            this.field_9378_bz = this.boundingBox.minY;
            this.oldPosY = this.posY;
            this.oldPosZ = this.posZ;
        }
        if (flag2) {
            this.oldRotationYaw = this.rotationYaw;
            this.oldRotationPitch = this.rotationPitch;
        }
    }

    @Override
    public void dropCurrentItem() {
        this.sendQueue.addToSendQueue(new Packet14BlockDig(4, 0, 0, 0, 0));
    }

    private void sendInventoryChanged() {
    }

    @Override
    public void middleClickBlock(int i2, int j2, int k2) {
        this.inventory.setCurrentItem(new ItemStack(this.worldObj.getBlockId(i2, j2, k2), 1, 0), this.gamemode.hasMiddleClick);
        this.sendQueue.addToSendQueue(new Packet14BlockDig(1, i2, j2, k2, 0));
    }

    @Override
    protected void joinEntityItemWithWorld(EntityItem entityitem) {
    }

    @Override
    public void sendChatMessage(String s2) {
        this.sendQueue.addToSendQueue(new Packet3Chat(s2));
    }

    @Override
    public void updateCreativeInventory(int page, String searchText) {
        this.sendQueue.addToSendQueue(new Packet107UpdateCreativeInventory(this.craftingInventory.windowId, page, searchText));
    }

    @Override
    public void setHotbarOffset(int offset) {
        super.setHotbarOffset(offset);
        this.sendQueue.addToSendQueue(new Packet108SetHotbarOffset(offset));
    }

    @Override
    public void displayGUIGuidebook() {
        this.mc.displayGuiScreen(new GuiGuidebook());
        this.sendQueue.addToSendQueue(new Packet133OpenGuidebook(this.mc.currentScreen instanceof GuiGuidebook));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new Packet18Animation(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendInventoryChanged();
        this.sendQueue.addToSendQueue(new Packet9Respawn((byte)this.dimension));
    }

    @Override
    protected void damageEntity(int i2, DamageType damageType) {
        this.health -= i2;
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new Packet101CloseWindow(this.craftingInventory.windowId));
        this.inventory.setHeldItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int i2) {
        if (this.field_21093_bH) {
            super.setHealth(i2);
        } else {
            this.health = i2;
            this.field_21093_bH = true;
        }
    }

    @Override
    public void addStat(StatBase statbase, int i2) {
        if (statbase == null) {
            return;
        }
        if (statbase.clientside) {
            super.addStat(statbase, i2);
        }
    }

    @Override
    public int getStat(StatBase statbase) {
        if (statbase.clientside) {
            return super.getStat(statbase);
        }
        return 0;
    }

    public void func_27027_b(StatBase statbase, int i2) {
        if (statbase == null) {
            return;
        }
        if (!statbase.clientside) {
            super.addStat(statbase, i2);
        }
    }

    @Override
    public void syncPlacementMode() {
        super.syncPlacementMode();
        this.sendQueue.addToSendQueue(new Packet135PlacementMode(this.rotationLock, this.rotationLockHorizontal, this.rotationLockVertical, this.placementMode));
    }
}

