/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    protected Entity entityToAttack;
    protected boolean hasAttacked = false;

    public EntityCreature(World world) {
        super(world);
    }

    protected boolean isMovementCeased() {
        return false;
    }

    @Override
    protected void updatePlayerActionState() {
        this.hasAttacked = this.isMovementCeased();
        float f2 = 16.0f;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, f2);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float f1 = this.entityToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, f1);
            } else {
                this.attackBlockedEntity(this.entityToAttack, f1);
            }
        }
        if (!(this.hasAttacked || this.entityToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0)) {
            this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, f2);
        } else if (!this.hasAttacked && (this.pathToEntity == null && this.rand.nextInt(80) == 0 || this.rand.nextInt(80) == 0)) {
            this.func_31026_E();
        }
        int i2 = MathHelper.floor_double(this.boundingBox.minY + 0.5);
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity == null || this.rand.nextInt(100) == 0) {
            super.updatePlayerActionState();
            this.pathToEntity = null;
            return;
        }
        Vec3D vec3d = this.pathToEntity.getPosition(this);
        double d2 = this.width * 2.0f;
        while (vec3d != null && vec3d.squareDistanceTo(this.posX, vec3d.yCoord, this.posZ) < d2 * d2) {
            this.pathToEntity.incrementPathIndex();
            if (this.pathToEntity.isFinished()) {
                vec3d = null;
                this.pathToEntity = null;
                continue;
            }
            vec3d = this.pathToEntity.getPosition(this);
        }
        this.isJumping = false;
        if (vec3d != null) {
            float f3;
            double d1 = vec3d.xCoord - this.posX;
            double d22 = vec3d.zCoord - this.posZ;
            double d3 = vec3d.yCoord - (double)i2;
            float f22 = (float)(Math.atan2(d22, d1) * 180.0 / 3.1415927410125732) - 90.0f;
            this.moveForward = this.moveSpeed;
            for (f3 = f22 - this.rotationYaw; f3 < -180.0f; f3 += 360.0f) {
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            if (f3 > 30.0f) {
                f3 = 30.0f;
            }
            if (f3 < -30.0f) {
                f3 = -30.0f;
            }
            this.rotationYaw += f3;
            if (this.hasAttacked && this.entityToAttack != null) {
                double d4 = this.entityToAttack.posX - this.posX;
                double d5 = this.entityToAttack.posZ - this.posZ;
                float f5 = this.rotationYaw;
                this.rotationYaw = (float)(Math.atan2(d5, d4) * 180.0 / 3.1415927410125732) - 90.0f;
                float f4 = (f5 - this.rotationYaw + 90.0f) * 3.141593f / 180.0f;
                this.moveStrafing = -MathHelper.sin(f4) * this.moveForward * 1.0f;
                this.moveForward = MathHelper.cos(f4) * this.moveForward * 1.0f;
            }
            if (d3 > 0.0) {
                this.isJumping = true;
            }
        }
        if (this.entityToAttack != null) {
            this.faceEntity(this.entityToAttack, 30.0f, 30.0f);
        }
        if (this.isCollidedHorizontally && !this.hasPath()) {
            this.isJumping = true;
        }
        if (this.rand.nextFloat() < 0.8f && (flag || flag1)) {
            this.isJumping = true;
        }
    }

    protected void func_31026_E() {
        boolean flag = false;
        int i2 = -1;
        int j2 = -1;
        int k2 = -1;
        float f2 = -99999.0f;
        for (int l2 = 0; l2 < 10; ++l2) {
            int k1;
            int j1;
            int i1 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
            float f1 = this.getBlockPathWeight(i1, j1 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), k1 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
            if (!(f1 > f2)) continue;
            f2 = f1;
            i2 = i1;
            j2 = j1;
            k2 = k1;
            flag = true;
        }
        if (flag) {
            this.pathToEntity = this.worldObj.getEntityPathToXYZ(this, i2, j2, k2, 10.0f);
        }
    }

    protected void attackEntity(Entity entity, float f2) {
    }

    protected void attackBlockedEntity(Entity entity, float f2) {
    }

    protected float getBlockPathWeight(int i2, int j2, int k2) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    @Override
    public boolean getCanSpawnHere() {
        int i2 = MathHelper.floor_double(this.posX);
        int j2 = MathHelper.floor_double(this.boundingBox.minY);
        int k2 = MathHelper.floor_double(this.posZ);
        return super.getCanSpawnHere() && this.getBlockPathWeight(i2, j2, k2) >= 0.0f;
    }

    public boolean hasPath() {
        return this.pathToEntity != null;
    }

    public void setPathToEntity(PathEntity pathentity) {
        this.pathToEntity = pathentity;
    }

    public Entity getTarget() {
        return this.entityToAttack;
    }

    public void setTarget(Entity entity) {
        this.entityToAttack = entity;
    }
}

