/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityFX;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;

public class EntityDiggingFX
extends EntityFX {
    private Block block;
    private int field_32001_o = 0;

    public EntityDiggingFX(World world, double d2, double d1, double d22, double d3, double d4, double d5, Block block, int i2, int meta) {
        super(world, d2, d1, d22, d3, d4, d5);
        this.block = block;
        this.particleTextureIndex = block.getBlockTextureFromSideAndMetadata(0, meta);
        this.particleGravity = block.blockParticleGravity;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale /= 2.0f;
        this.field_32001_o = i2;
    }

    public EntityDiggingFX func_4041_a(int i2, int j2, int k2) {
        if (this.block == Block.grass) {
            return this;
        }
        int l2 = this.block.colorMultiplier(this.worldObj, this.worldObj, i2, j2, k2);
        this.particleRed *= (float)(l2 >> 16 & 0xFF) / 255.0f;
        this.particleGreen *= (float)(l2 >> 8 & 0xFF) / 255.0f;
        this.particleBlue *= (float)(l2 & 0xFF) / 255.0f;
        return this;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(Tessellator tessellator, float f2, float f1, float f22, float f3, float f4, float f5) {
        float f6 = ((float)(this.particleTextureIndex % Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterX / 4.0f) / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f7 = f6 + 0.25f / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f8 = ((float)(this.particleTextureIndex / Minecraft.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterY / 4.0f) / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f9 = f8 + 0.25f / (float)Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f2 - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f2 - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f2 - interpPosZ);
        float f14 = this.getEntityBrightness(f2);
        tessellator.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        tessellator.addVertexWithUV(f11 - f1 * f10 - f4 * f10, f12 - f22 * f10, f13 - f3 * f10 - f5 * f10, f6, f9);
        tessellator.addVertexWithUV(f11 - f1 * f10 + f4 * f10, f12 + f22 * f10, f13 - f3 * f10 + f5 * f10, f6, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 + f4 * f10, f12 + f22 * f10, f13 + f3 * f10 + f5 * f10, f7, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 - f4 * f10, f12 - f22 * f10, f13 + f3 * f10 - f5 * f10, f7, f9);
    }
}

