/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLog;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityItem
extends Entity {
    public ItemStack item;
    private int field_803_e;
    public int age = 0;
    public int delayBeforeCanPickup;
    private int health = 5;
    public float field_804_d = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World world, double d2, double d1, double d22, ItemStack itemstack) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(d2, d1, d22);
        this.item = itemstack;
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motionY = 0.2f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        if (this.worldObj.getBlockMaterial(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) == Material.lava) {
            this.motionY = 0.2f;
            this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        this.pushOutOfBlocks(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        float f2 = 0.98f;
        if (this.onGround) {
            f2 = 0.5880001f;
            int i2 = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
            if (i2 > 0) {
                f2 = Block.blocksList[i2].slipperiness * 0.98f;
            }
        }
        this.motionX *= (double)f2;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)f2;
        if (this.inWater && this.motionY < 0.0) {
            this.motionX *= (double)0.95f;
            this.motionY *= (double)0.45f;
            this.motionZ *= (double)0.95f;
        }
        if (this.onGround) {
            this.motionY *= -0.5;
        }
        ++this.field_803_e;
        ++this.age;
        if (this.age >= 6000) {
            this.setEntityDead();
        }
    }

    @Override
    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, this);
    }

    @Override
    protected void dealFireDamage(int i2) {
        this.attackEntityFrom(null, i2, DamageType.FIRE);
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        this.setBeenAttacked();
        this.health -= i2;
        if (this.health <= 0) {
            this.setEntityDead();
        }
        return false;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Health", (byte)this.health);
        nbttagcompound.setShort("Age", (short)this.age);
        nbttagcompound.setCompoundTag("Item", this.item.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health") & 0xFF;
        this.age = nbttagcompound.getShort("Age");
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Item");
        this.item = new ItemStack(nbttagcompound1);
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        int i2 = this.item.stackSize;
        if (this.delayBeforeCanPickup == 0 && entityplayer.inventory.addItemStackToInventoryWithHotbarOffset(this.item)) {
            if (this.item.itemID < 16384 && Block.blocksList[this.item.itemID] instanceof BlockLog) {
                entityplayer.triggerAchievement(AchievementList.mineWood);
            }
            if (this.item.itemID == Item.leather.itemID) {
                entityplayer.triggerAchievement(AchievementList.killCow);
            }
            if (this.item.itemID == Block.ice.blockID) {
                entityplayer.triggerAchievement(AchievementList.crushBlocks);
            }
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup(this, this.item.itemID);
            if (this.item.stackSize <= 0) {
                this.setEntityDead();
            }
        }
    }
}

