/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityWeatherEffect;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityLightningBolt
extends EntityWeatherEffect {
    private int field_27028_b;
    public long field_27029_a = 0L;
    private int field_27030_c;

    public EntityLightningBolt(World world, double d2, double d1, double d22) {
        super(world);
        this.setLocationAndAngles(d2, d1, d22, 0.0f, 0.0f);
        this.field_27028_b = 2;
        this.field_27029_a = this.rand.nextLong();
        this.field_27030_c = this.rand.nextInt(3) + 1;
        if (world.difficultySetting >= 2 && world.doChunksNearChunkExist(MathHelper.floor_double(d2), MathHelper.floor_double(d1), MathHelper.floor_double(d22), 10)) {
            int i1;
            int k2;
            int i2 = MathHelper.floor_double(d2);
            if (world.getBlockId(i2, k2 = MathHelper.floor_double(d1), i1 = MathHelper.floor_double(d22)) == 0 && Block.fire.canPlaceBlockAt(world, i2, k2, i1)) {
                world.setBlockWithNotify(i2, k2, i1, Block.fire.blockID);
            }
            for (int j2 = 0; j2 < 4; ++j2) {
                int k1;
                int j1;
                int l2 = MathHelper.floor_double(d2) + this.rand.nextInt(3) - 1;
                if (world.getBlockId(l2, j1 = MathHelper.floor_double(d1) + this.rand.nextInt(3) - 1, k1 = MathHelper.floor_double(d22) + this.rand.nextInt(3) - 1) != 0 || !Block.fire.canPlaceBlockAt(world, l2, j1, k1)) continue;
                world.setBlockWithNotify(l2, j1, k1, Block.fire.blockID);
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_27028_b == 2) {
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "ambient.weather.thunder", 10000.0f, 0.8f + this.rand.nextFloat() * 0.2f);
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.explode", 2.0f, 0.5f + this.rand.nextFloat() * 0.2f);
        }
        --this.field_27028_b;
        if (this.field_27028_b < 0) {
            if (this.field_27030_c == 0) {
                this.setEntityDead();
            } else if (this.field_27028_b < -this.rand.nextInt(10)) {
                int k2;
                int j2;
                int i2;
                --this.field_27030_c;
                this.field_27028_b = 1;
                this.field_27029_a = this.rand.nextLong();
                if (this.worldObj.doChunksNearChunkExist(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ), 10) && this.worldObj.getBlockId(i2 = MathHelper.floor_double(this.posX), j2 = MathHelper.floor_double(this.posY), k2 = MathHelper.floor_double(this.posZ)) == 0 && Block.fire.canPlaceBlockAt(this.worldObj, i2, j2, k2)) {
                    this.worldObj.setBlockWithNotify(i2, j2, k2, Block.fire.blockID);
                }
            }
        }
        if (this.field_27028_b >= 0) {
            double d2 = 3.0;
            List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, AxisAlignedBB.getBoundingBoxFromPool(this.posX - d2, this.posY - d2, this.posZ - d2, this.posX + d2, this.posY + 6.0 + d2, this.posZ + d2));
            for (int l2 = 0; l2 < list.size(); ++l2) {
                Entity entity = list.get(l2);
                entity.onStruckByLightning(this);
            }
            this.worldObj.lightningFlicker = 2;
        }
    }

    @Override
    protected void entityInit() {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public boolean isInRangeToRenderVec3D(Vec3D vec3d) {
        return this.field_27028_b >= 0;
    }
}

