/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Gamemode;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] cargoItems = new ItemStack[36];
    public int minecartCurrentDamage = 0;
    public int minecartTimeSinceHit = 0;
    public int minecartRockDirection = 1;
    private boolean field_856_i = false;
    public int minecartType;
    public int fuel;
    public double pushX;
    public double pushZ;
    private static final int[][][] field_855_j = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int field_9415_k;
    private double field_9414_l;
    private double field_9413_m;
    private double field_9412_n;
    private double field_9411_o;
    private double field_9410_p;
    private double field_9409_q;
    private double field_9408_r;
    private double field_9407_s;

    public EntityMinecart(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityMinecart(World world, double d2, double d1, double d22, int i2) {
        this(world);
        this.setPosition(d2, d1 + (double)this.yOffset, d22);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d2;
        this.prevPosY = d1;
        this.prevPosZ = d22;
        this.minecartType = i2;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        if (this.worldObj.isMultiplayerAndNotHost || this.isDead) {
            return true;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).getGamemode() == Gamemode.creative) {
            this.setEntityDead();
            return true;
        }
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.setBeenAttacked();
        this.minecartCurrentDamage += i2 * 10;
        if (this.minecartCurrentDamage > 40) {
            if (this.riddenByEntity != null) {
                this.riddenByEntity.mountEntity(this);
            }
            this.setEntityDead();
            this.dropItemWithOffset(Item.minecart.itemID, 1, 0.0f);
            if (this.minecartType == 1) {
                EntityMinecart entityminecart = this;
                for (int j2 = 0; j2 < entityminecart.getSizeInventory(); ++j2) {
                    ItemStack itemstack = entityminecart.getStackInSlot(j2);
                    if (itemstack == null) continue;
                    float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                    float f22 = this.rand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.stackSize > 0) {
                        int k2 = this.rand.nextInt(21) + 10;
                        if (k2 > itemstack.stackSize) {
                            k2 = itemstack.stackSize;
                        }
                        itemstack.stackSize -= k2;
                        EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)f2, this.posY + (double)f1, this.posZ + (double)f22, new ItemStack(itemstack.itemID, k2, itemstack.getMetadata()));
                        float f3 = 0.05f;
                        entityitem.motionX = (float)this.rand.nextGaussian() * f3 * 0.5f;
                        entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                        entityitem.motionZ = (float)this.rand.nextGaussian() * f3 * 0.5f;
                        this.worldObj.entityJoinedWorld(entityitem);
                    }
                }
                this.dropItemWithOffset(Block.chestPlanksOak.blockID, 1, 0.0f);
            } else if (this.minecartType == 2) {
                this.dropItemWithOffset(Block.furnaceStoneIdle.blockID, 1, 0.0f);
            }
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.minecartCurrentDamage += this.minecartCurrentDamage * 10;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setEntityDead() {
        for (int i2 = 0; i2 < this.getSizeInventory(); ++i2) {
            ItemStack itemstack = this.getStackInSlot(i2);
            if (itemstack == null) continue;
            float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
            float f22 = this.rand.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int j2 = this.rand.nextInt(21) + 10;
                if (j2 > itemstack.stackSize) {
                    j2 = itemstack.stackSize;
                }
                itemstack.stackSize -= j2;
                EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)f2, this.posY + (double)f1, this.posZ + (double)f22, new ItemStack(itemstack.itemID, j2, itemstack.getMetadata()));
                float f3 = 0.05f;
                entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                this.worldObj.entityJoinedWorld(entityitem);
            }
        }
        super.setEntityDead();
    }

    @Override
    public void onUpdate() {
        this.onUpdate2();
        this.onUpdate2();
    }

    public void onUpdate2() {
        double d8;
        int k2;
        int j2;
        if (this.minecartTimeSinceHit > 0) {
            --this.minecartTimeSinceHit;
        }
        if (this.minecartCurrentDamage > 0) {
            --this.minecartCurrentDamage;
        }
        if (this.worldObj.isMultiplayerAndNotHost && this.field_9415_k > 0) {
            if (this.field_9415_k > 0) {
                double d4;
                double d2 = this.posX + (this.field_9414_l - this.posX) / (double)this.field_9415_k;
                double d1 = this.posY + (this.field_9413_m - this.posY) / (double)this.field_9415_k;
                double d3 = this.posZ + (this.field_9412_n - this.posZ) / (double)this.field_9415_k;
                for (d4 = this.field_9411_o - (double)this.rotationYaw; d4 < -180.0; d4 += 360.0) {
                }
                while (d4 >= 180.0) {
                    d4 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d4 / (double)this.field_9415_k);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.field_9410_p - (double)this.rotationPitch) / (double)this.field_9415_k);
                --this.field_9415_k;
                this.setPosition(d2, d1, d3);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        int i2 = MathHelper.floor_double(this.posX);
        if (BlockRail.isRailBlockAt(this.worldObj, i2, (j2 = MathHelper.floor_double(this.posY)) - 1, k2 = MathHelper.floor_double(this.posZ))) {
            --j2;
        }
        double d2 = 0.4;
        boolean flag = false;
        double d5 = 0.0078125;
        int l2 = this.worldObj.getBlockId(i2, j2, k2);
        if (BlockRail.isRailBlock(l2)) {
            double d30;
            Vec3D vec3d = this.func_514_g(this.posX, this.posY, this.posZ);
            int i1 = this.worldObj.getBlockMetadata(i2, j2, k2);
            this.posY = j2;
            boolean flag1 = false;
            boolean flag2 = false;
            if (l2 == Block.railPowered.blockID) {
                flag1 = (i1 & 8) != 0;
                boolean bl2 = flag2 = !flag1;
            }
            if (((BlockRail)Block.blocksList[l2]).getIsPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                this.posY = j2 + 1;
            }
            if (i1 == 2) {
                this.motionX -= d5;
            }
            if (i1 == 3) {
                this.motionX += d5;
            }
            if (i1 == 4) {
                this.motionZ += d5;
            }
            if (i1 == 5) {
                this.motionZ -= d5;
            }
            int[][] ai2 = field_855_j[i1];
            double d9 = ai2[1][0] - ai2[0][0];
            double d10 = ai2[1][2] - ai2[0][2];
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            double d12 = this.motionX * d9 + this.motionZ * d10;
            if (d12 < 0.0) {
                d9 = -d9;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = d13 * d9 / d11;
            this.motionZ = d13 * d10 / d11;
            if (flag2) {
                double d16 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d16 < 0.03) {
                    this.motionX *= 0.0;
                    this.motionY *= 0.0;
                    this.motionZ *= 0.0;
                } else {
                    this.motionX *= 0.5;
                    this.motionY *= 0.0;
                    this.motionZ *= 0.5;
                }
            }
            double d17 = 0.0;
            double d18 = (double)i2 + 0.5 + (double)ai2[0][0] * 0.5;
            double d19 = (double)k2 + 0.5 + (double)ai2[0][2] * 0.5;
            double d20 = (double)i2 + 0.5 + (double)ai2[1][0] * 0.5;
            double d21 = (double)k2 + 0.5 + (double)ai2[1][2] * 0.5;
            d9 = d20 - d18;
            d10 = d21 - d19;
            if (d9 == 0.0) {
                this.posX = (double)i2 + 0.5;
                d17 = this.posZ - (double)k2;
            } else if (d10 == 0.0) {
                this.posZ = (double)k2 + 0.5;
                d17 = this.posX - (double)i2;
            } else {
                double d26;
                double d22 = this.posX - d18;
                double d24 = this.posZ - d19;
                d17 = d26 = (d22 * d9 + d24 * d10) * 2.0;
            }
            this.posX = d18 + d9 * d17;
            this.posZ = d19 + d10 * d17;
            this.setPosition(this.posX, this.posY + (double)this.yOffset, this.posZ);
            double d23 = this.motionX;
            double d25 = this.motionZ;
            if (this.riddenByEntity != null) {
                d23 *= 0.75;
                d25 *= 0.75;
            }
            if (d23 < -d2) {
                d23 = -d2;
            }
            if (d23 > d2) {
                d23 = d2;
            }
            if (d25 < -d2) {
                d25 = -d2;
            }
            if (d25 > d2) {
                d25 = d2;
            }
            this.moveEntity(d23, 0.0, d25);
            if (ai2[0][1] != 0 && MathHelper.floor_double(this.posX) - i2 == ai2[0][0] && MathHelper.floor_double(this.posZ) - k2 == ai2[0][2]) {
                this.setPosition(this.posX, this.posY + (double)ai2[0][1], this.posZ);
            } else if (ai2[1][1] != 0 && MathHelper.floor_double(this.posX) - i2 == ai2[1][0] && MathHelper.floor_double(this.posZ) - k2 == ai2[1][2]) {
                this.setPosition(this.posX, this.posY + (double)ai2[1][1], this.posZ);
            }
            if (this.riddenByEntity != null) {
                this.motionX *= (double)0.997f;
                this.motionY *= 0.0;
                this.motionZ *= (double)0.997f;
            } else {
                if (this.minecartType == 2) {
                    double d27 = MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ);
                    if (d27 > 0.01) {
                        flag = true;
                        this.pushX /= d27;
                        this.pushZ /= d27;
                        double d29 = 0.04;
                        this.motionX *= (double)0.8f;
                        this.motionY *= 0.0;
                        this.motionZ *= (double)0.8f;
                        this.motionX += this.pushX * d29;
                        this.motionZ += this.pushZ * d29;
                    } else {
                        this.motionX *= (double)0.9f;
                        this.motionY *= 0.0;
                        this.motionZ *= (double)0.9f;
                    }
                }
                this.motionX *= (double)0.96f;
                this.motionY *= 0.0;
                this.motionZ *= (double)0.96f;
            }
            Vec3D vec3d1 = this.func_514_g(this.posX, this.posY, this.posZ);
            if (vec3d1 != null && vec3d != null) {
                double d28 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
                double d14 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d14 > 0.0) {
                    this.motionX = this.motionX / d14 * (d14 + d28);
                    this.motionZ = this.motionZ / d14 * (d14 + d28);
                }
                this.setPosition(this.posX, vec3d1.yCoord, this.posZ);
            }
            int k1 = MathHelper.floor_double(this.posX);
            int l1 = MathHelper.floor_double(this.posZ);
            if (k1 != i2 || l1 != k2) {
                double d15 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                this.motionX = d15 * (double)(k1 - i2);
                this.motionZ = d15 * (double)(l1 - k2);
            }
            if (this.minecartType == 2 && (d30 = (double)MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ)) > 0.01 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
                this.pushX = this.motionX;
                this.pushZ = this.motionZ;
            }
            if (flag1) {
                double d31 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d31 > 0.01) {
                    double d32 = 0.06;
                    this.motionX += this.motionX / d31 * d32;
                    this.motionZ += this.motionZ / d31 * d32;
                } else if (i1 == 1) {
                    if (this.worldObj.isBlockNormalCube(i2 - 1, j2, k2)) {
                        this.motionX = 0.02;
                    } else if (this.worldObj.isBlockNormalCube(i2 + 1, j2, k2)) {
                        this.motionX = -0.02;
                    }
                } else if (i1 == 0) {
                    if (this.worldObj.isBlockNormalCube(i2, j2, k2 - 1)) {
                        this.motionZ = 0.02;
                    } else if (this.worldObj.isBlockNormalCube(i2, j2, k2 + 1)) {
                        this.motionZ = -0.02;
                    }
                }
            }
        } else {
            if (this.motionX < -d2) {
                this.motionX = -d2;
            }
            if (this.motionX > d2) {
                this.motionX = d2;
            }
            if (this.motionZ < -d2) {
                this.motionZ = -d2;
            }
            if (this.motionZ > d2) {
                this.motionZ = d2;
            }
            if (this.onGround) {
                this.motionX *= 0.5;
                this.motionY *= 0.5;
                this.motionZ *= 0.5;
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (!this.onGround) {
                this.motionX *= (double)0.95f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.95f;
            }
        }
        this.rotationPitch = 0.0f;
        double d6 = this.prevPosX - this.posX;
        double d7 = this.prevPosZ - this.posZ;
        if (d6 * d6 + d7 * d7 > 0.001) {
            this.rotationYaw = (float)(Math.atan2(d7, d6) * 180.0 / Math.PI);
            if (this.field_856_i) {
                this.rotationYaw += 180.0f;
            }
        }
        for (d8 = (double)(this.rotationYaw - this.prevRotationYaw); d8 >= 180.0; d8 -= 360.0) {
        }
        while (d8 < -180.0) {
            d8 += 360.0;
        }
        if (d8 < -170.0 || d8 >= 170.0) {
            this.rotationYaw += 180.0f;
            this.field_856_i = !this.field_856_i;
        }
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = list.get(j1);
                if (entity == this.riddenByEntity || !entity.canBePushed() || !(entity instanceof EntityMinecart)) continue;
                entity.applyEntityCollision(this);
            }
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            this.riddenByEntity = null;
        }
        if (flag && this.rand.nextInt(4) == 0) {
            --this.fuel;
            if (this.fuel < 0) {
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.worldObj.spawnParticle("largesmoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
        }
    }

    public Vec3D func_515_a(double d2, double d1, double d22, double d3) {
        int l2;
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(d2);
        if (BlockRail.isRailBlockAt(this.worldObj, i2, (j2 = MathHelper.floor_double(d1)) - 1, k2 = MathHelper.floor_double(d22))) {
            --j2;
        }
        if (BlockRail.isRailBlock(l2 = this.worldObj.getBlockId(i2, j2, k2))) {
            int i1 = this.worldObj.getBlockMetadata(i2, j2, k2);
            if (((BlockRail)Block.blocksList[l2]).getIsPowered()) {
                i1 &= 7;
            }
            d1 = j2;
            if (i1 >= 2 && i1 <= 5) {
                d1 = j2 + 1;
            }
            int[][] ai2 = field_855_j[i1];
            double d4 = ai2[1][0] - ai2[0][0];
            double d5 = ai2[1][2] - ai2[0][2];
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (ai2[0][1] != 0 && MathHelper.floor_double(d2 += (d4 /= d6) * d3) - i2 == ai2[0][0] && MathHelper.floor_double(d22 += (d5 /= d6) * d3) - k2 == ai2[0][2]) {
                d1 += (double)ai2[0][1];
            } else if (ai2[1][1] != 0 && MathHelper.floor_double(d2) - i2 == ai2[1][0] && MathHelper.floor_double(d22) - k2 == ai2[1][2]) {
                d1 += (double)ai2[1][1];
            }
            return this.func_514_g(d2, d1, d22);
        }
        return null;
    }

    public Vec3D func_514_g(double d2, double d1, double d22) {
        int l2;
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(d2);
        if (BlockRail.isRailBlockAt(this.worldObj, i2, (j2 = MathHelper.floor_double(d1)) - 1, k2 = MathHelper.floor_double(d22))) {
            --j2;
        }
        if (BlockRail.isRailBlock(l2 = this.worldObj.getBlockId(i2, j2, k2))) {
            int i1 = this.worldObj.getBlockMetadata(i2, j2, k2);
            d1 = j2;
            if (((BlockRail)Block.blocksList[l2]).getIsPowered()) {
                i1 &= 7;
            }
            if (i1 >= 2 && i1 <= 5) {
                d1 = j2 + 1;
            }
            int[][] ai2 = field_855_j[i1];
            double d3 = 0.0;
            double d4 = (double)i2 + 0.5 + (double)ai2[0][0] * 0.5;
            double d5 = (double)j2 + 0.5 + (double)ai2[0][1] * 0.5;
            double d6 = (double)k2 + 0.5 + (double)ai2[0][2] * 0.5;
            double d7 = (double)i2 + 0.5 + (double)ai2[1][0] * 0.5;
            double d8 = (double)j2 + 0.5 + (double)ai2[1][1] * 0.5;
            double d9 = (double)k2 + 0.5 + (double)ai2[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                d2 = (double)i2 + 0.5;
                d3 = d22 - (double)k2;
            } else if (d12 == 0.0) {
                d22 = (double)k2 + 0.5;
                d3 = d2 - (double)i2;
            } else {
                double d15;
                double d13 = d2 - d4;
                double d14 = d22 - d6;
                d3 = d15 = (d13 * d10 + d14 * d12) * 2.0;
            }
            d2 = d4 + d10 * d3;
            d1 = d5 + d11 * d3;
            d22 = d6 + d12 * d3;
            if (d11 < 0.0) {
                d1 += 1.0;
            }
            if (d11 > 0.0) {
                d1 += 0.5;
            }
            return Vec3D.createVector(d2, d1, d22);
        }
        return null;
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("Type", this.minecartType);
        if (this.minecartType == 2) {
            nbttagcompound.setDouble("PushX", this.pushX);
            nbttagcompound.setDouble("PushZ", this.pushZ);
            nbttagcompound.setShort("Fuel", (short)this.fuel);
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i2 = 0; i2 < this.cargoItems.length; ++i2) {
                if (this.cargoItems[i2] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i2);
                this.cargoItems[i2].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            nbttagcompound.setTag("Items", nbttaglist);
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.minecartType = nbttagcompound.getInteger("Type");
        if (this.minecartType == 2) {
            this.pushX = nbttagcompound.getDouble("PushX");
            this.pushZ = nbttagcompound.getDouble("PushZ");
            this.fuel = nbttagcompound.getShort("Fuel");
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            for (int i2 = 0; i2 < nbttaglist.tagCount(); ++i2) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i2);
                int j2 = nbttagcompound1.getByte("Slot") & 0xFF;
                if (j2 < 0 || j2 >= this.cargoItems.length) continue;
                this.cargoItems[j2] = new ItemStack(nbttagcompound1);
            }
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        double d1;
        double d2;
        double d22;
        if (this.worldObj.isMultiplayerAndNotHost) {
            return;
        }
        if (entity == this.riddenByEntity) {
            return;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer) && this.minecartType == 0 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && this.riddenByEntity == null && entity.ridingEntity == null) {
            entity.mountEntity(this);
        }
        if ((d22 = (d2 = entity.posX - this.posX) * d2 + (d1 = entity.posZ - this.posZ) * d1) >= (double)1.0E-4f) {
            d22 = MathHelper.sqrt_double(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.1f;
            d1 *= (double)0.1f;
            d2 *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            d2 *= 0.5;
            d1 *= 0.5;
            if (entity instanceof EntityMinecart) {
                double d4 = entity.posX - this.posX;
                double d5 = entity.posZ - this.posZ;
                double d6 = d4 * entity.motionZ + d5 * entity.prevPosX;
                if ((d6 *= d6) > 5.0) {
                    return;
                }
                double d7 = entity.motionX + this.motionX;
                double d8 = entity.motionZ + this.motionZ;
                if (((EntityMinecart)entity).minecartType == 2 && this.minecartType != 2) {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity(entity.motionX - d2, 0.0, entity.motionZ - d1);
                    entity.motionX *= (double)0.7f;
                    entity.motionZ *= (double)0.7f;
                } else if (((EntityMinecart)entity).minecartType != 2 && this.minecartType == 2) {
                    entity.motionX *= (double)0.2f;
                    entity.motionZ *= (double)0.2f;
                    entity.addVelocity(this.motionX + d2, 0.0, this.motionZ + d1);
                    this.motionX *= (double)0.7f;
                    this.motionZ *= (double)0.7f;
                } else {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity((d7 /= 2.0) - d2, 0.0, (d8 /= 2.0) - d1);
                    entity.motionX *= (double)0.2f;
                    entity.motionZ *= (double)0.2f;
                    entity.addVelocity(d7 + d2, 0.0, d8 + d1);
                }
            } else {
                this.addVelocity(-d2, 0.0, -d1);
                entity.addVelocity(d2 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    public int getSizeInventory() {
        return 27;
    }

    @Override
    public ItemStack getStackInSlot(int i2) {
        return this.cargoItems[i2];
    }

    @Override
    public ItemStack decrStackSize(int i2, int j2) {
        if (this.cargoItems[i2] != null) {
            if (this.cargoItems[i2].stackSize <= j2) {
                ItemStack itemstack = this.cargoItems[i2];
                this.cargoItems[i2] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i2].splitStack(j2);
            if (this.cargoItems[i2].stackSize == 0) {
                this.cargoItems[i2] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.cargoItems[i2] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Minecart";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (this.minecartType == 0) {
            if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != entityplayer) {
                return true;
            }
            if (!this.worldObj.isMultiplayerAndNotHost) {
                entityplayer.mountEntity(this);
            }
        } else if (this.minecartType == 1) {
            if (!this.worldObj.isMultiplayerAndNotHost) {
                entityplayer.displayGUIChest(this);
            }
        } else if (this.minecartType == 2) {
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null && itemstack.itemID == Item.coal.itemID) {
                if (--itemstack.stackSize == 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                this.fuel += 1200;
            }
            this.pushX = this.posX - entityplayer.posX;
            this.pushZ = this.posZ - entityplayer.posZ;
        }
        return true;
    }

    @Override
    public void setPositionAndRotation2(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.field_9414_l = d2;
        this.field_9413_m = d1;
        this.field_9412_n = d22;
        this.field_9411_o = f2;
        this.field_9410_p = f1;
        this.field_9415_k = i2 + 2;
        this.motionX = this.field_9409_q;
        this.motionY = this.field_9408_r;
        this.motionZ = this.field_9407_s;
    }

    @Override
    public void setVelocity(double d2, double d1, double d22) {
        this.field_9409_q = this.motionX = d2;
        this.field_9408_r = this.motionY = d1;
        this.field_9407_s = this.motionZ = d22;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.isDead) {
            return false;
        }
        return entityplayer.getDistanceSqToEntity(this) <= 64.0;
    }
}

