/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityCreature;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.IMob;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Season;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityMob
extends EntityCreature
implements IMob {
    protected int attackStrength = 2;

    public EntityMob(World world) {
        super(world);
        this.health = 20;
    }

    @Override
    public void onLivingUpdate() {
        float f2 = this.getEntityBrightness(1.0f);
        if (f2 > 0.5f) {
            this.entityAge += 2;
        }
        super.onLivingUpdate();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isMultiplayerAndNotHost && this.worldObj.difficultySetting == 0) {
            this.setEntityDead();
        }
    }

    @Override
    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer) && entityplayer.getGamemode().areMobsHostile) {
            return entityplayer;
        }
        return null;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.worldObj.getCurrentSeason() == Season.surfaceSpring) {
            return 2;
        }
        if (this.worldObj.getCurrentSeason() == Season.surfaceWinter) {
            return 8;
        }
        return 4;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        if (super.attackEntityFrom(entity, i2, type)) {
            if (this.riddenByEntity == entity || this.ridingEntity == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void attackEntity(Entity entity, float f2) {
        if (this.attackTime <= 0 && f2 < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            entity.attackEntityFrom(this, this.attackStrength, DamageType.COMBAT);
        }
    }

    @Override
    protected float getBlockPathWeight(int i2, int j2, int k2) {
        return 0.5f - this.worldObj.getLightBrightness(i2, j2, k2);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    @Override
    public boolean getCanSpawnHere() {
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(this.posX);
        if (this.worldObj.getSavedLightValue(EnumLightType.Block, i2, j2 = MathHelper.floor_double(this.boundingBox.minY), k2 = MathHelper.floor_double(this.posZ)) > 0) {
            return false;
        }
        if (this.worldObj.getSavedLightValue(EnumLightType.Sky, i2, j2, k2) > this.rand.nextInt(32)) {
            return false;
        }
        int blockLight = this.worldObj.getBlockLightValue(i2, j2, k2);
        if (this.worldObj.currentWeather != null && this.worldObj.currentWeather.doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.getCanSpawnHere();
    }
}

