/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBed;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Container;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityFish;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EnumSleepStatus;
import net.minecraft.src.Gamemode;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatList;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.TileEntityTrommel;
import net.minecraft.src.Weather;
import net.minecraft.src.World;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.helper.DamageType;

public abstract class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory;
    public Container inventorySlots;
    public Container craftingInventory;
    protected Gamemode gamemode = Gamemode.survival;
    public byte field_9371_f = 0;
    public int score = 0;
    public float field_775_e;
    public float field_774_f;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public int dimension;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    protected boolean sleeping;
    public ChunkCoordinates bedChunkCoordinates;
    private int sleepTimer;
    public float field_22063_x;
    public float field_22062_y;
    public float field_22061_z;
    private ChunkCoordinates playerSpawnCoordinate;
    private ChunkCoordinates startMinecartRidingCoordinate;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public int portalID;
    public float timeInPortal;
    public float prevTimeInPortal;
    private int damageRemainder = 0;
    public EntityFish fishEntity = null;
    public volatile String skinURL;
    public volatile String capeURL;

    public EntityPlayer(World world) {
        super(world);
        this.inventory = new InventoryPlayer(this);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !world.isMultiplayerAndNotHost);
        this.yOffset = 1.62f;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        this.setLocationAndAngles((double)chunkcoordinates.x + 0.5, chunkcoordinates.y + 1, (double)chunkcoordinates.z + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.field_9351_C = "humanoid";
        this.field_9353_B = 180.0f;
        this.fireResistance = 20;
        this.texture = "/mob/char.png";
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
    }

    @Override
    public void onUpdate() {
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.worldObj.isMultiplayerAndNotHost) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true);
                } else if (this.worldObj.isDaytime() && this.worldObj.currentWeather != Weather.weatherStorm) {
                    this.wakeUpPlayer(false, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (!this.worldObj.isMultiplayerAndNotHost && this.craftingInventory != null && !this.craftingInventory.isUsableByPlayer(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d2 = this.posX - this.field_20063_u;
        double d1 = this.posY - this.field_20062_v;
        double d22 = this.posZ - this.field_20061_w;
        double d3 = 10.0;
        if (d2 > d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d22 > d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        if (d2 < -d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d22 < -d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        this.field_20063_u += d2 * 0.25;
        this.field_20061_w += d22 * 0.25;
        this.field_20062_v += d1 * 0.25;
        this.addStat(StatList.minutesPlayedStat, 1);
        if (this.ridingEntity == null) {
            this.startMinecartRidingCoordinate = null;
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.health <= 0 || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    @Override
    public void updateRidden() {
        double d2 = this.posX;
        double d1 = this.posY;
        double d22 = this.posZ;
        super.updateRidden();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
        this.addMountedMovementStat(this.posX - d2, this.posY - d1, this.posZ - d22);
    }

    @Override
    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.health = 20;
        this.deathTime = 0;
    }

    @Override
    protected void updatePlayerActionState() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    @Override
    public void onLivingUpdate() {
        List<Entity> list;
        if (this.worldObj.difficultySetting == 0 && this.health < 20 && this.ticksExisted % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.field_775_e = this.field_774_f;
        super.onLivingUpdate();
        float f2 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (f2 > 0.1f) {
            f2 = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            f2 = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (f2 - this.field_774_f) * 0.4f;
        this.field_9328_R += (f1 - this.field_9328_R) * 0.8f;
        if (this.health > 0 && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.5, 1.0))) != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (entity.isDead) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    private void collideWithPlayer(Entity entity) {
        entity.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void onDeath(Entity entity) {
        super.onDeath(entity);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.username.equals("MaggAndGeez")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.ammoFireball, 1), true);
        } else if (this.username.equals("jonkadelic")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.foodCookie, 1), true);
        }
        this.inventory.dropAllItems();
        if (entity != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
        this.addStat(StatList.deathsStat, 1);
    }

    @Override
    protected void dropFewItems() {
    }

    @Override
    public void addToPlayerScore(Entity entity, int i2) {
        this.score += i2;
        if (entity instanceof EntityPlayer) {
            this.addStat(StatList.playerKillsStat, 1);
        } else {
            this.addStat(StatList.mobKillsStat, 1);
        }
    }

    public void dropCurrentItem() {
        this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, 1), false);
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropPlayerItemWithRandomChoice(itemstack, false);
    }

    public void setHotbarOffset(int offset) {
        this.inventory.hotbarOffset = offset;
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (this.noClip) {
            return;
        }
        super.applyEntityCollision(entity);
    }

    public void middleClickBlock(int i2, int j2, int k2) {
        this.inventory.setCurrentItem(new ItemStack(this.worldObj.getBlockId(i2, j2, k2), 1, 0), this.gamemode.hasMiddleClick);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack itemstack, boolean flag) {
        if (itemstack == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.getEyeHeight(), this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        float f2 = 0.1f;
        if (flag) {
            float f22 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f22;
            entityitem.motionZ = MathHelper.cos(f4) * f22;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.joinEntityItemWithWorld(entityitem);
        this.addStat(StatList.dropStat, 1);
    }

    protected void joinEntityItemWithWorld(EntityItem entityitem) {
        this.worldObj.entityJoinedWorld(entityitem);
    }

    public float getCurrentPlayerStrVsBlock(Block block) {
        float f2 = this.inventory.getStrVsBlock(block);
        if (this.isInsideOfMaterial(Material.water)) {
            f2 /= 5.0f;
        }
        if (!this.onGround) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean canHarvestBlock(Block block) {
        return this.inventory.canHarvestBlock(block);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        int dim = nbttagcompound.getInteger("Dimension");
        if (dim == -1) {
            dim = 1;
        }
        this.dimension = dim;
        this.sleeping = nbttagcompound.getBoolean("Sleeping");
        this.sleepTimer = nbttagcompound.getShort("SleepTimer");
        this.setGamemodeOnLogin(Gamemode.gamemodesList[nbttagcompound.getInteger("Gamemode")]);
        boolean bl2 = this.noClip = nbttagcompound.getBoolean("Noclip") && this.gamemode.canPlayerFly;
        if (this.sleeping) {
            this.bedChunkCoordinates = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
            this.wakeUpPlayer(true, true);
        }
        if (nbttagcompound.hasKey("SpawnX") && nbttagcompound.hasKey("SpawnY") && nbttagcompound.hasKey("SpawnZ")) {
            this.playerSpawnCoordinate = new ChunkCoordinates(nbttagcompound.getInteger("SpawnX"), nbttagcompound.getInteger("SpawnY"), nbttagcompound.getInteger("SpawnZ"));
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        nbttagcompound.setInteger("Dimension", this.dimension);
        nbttagcompound.setBoolean("Sleeping", this.sleeping);
        nbttagcompound.setShort("SleepTimer", (short)this.sleepTimer);
        nbttagcompound.setInteger("Gamemode", this.gamemode.id);
        nbttagcompound.setBoolean("Noclip", this.noClip && this.gamemode.canPlayerFly);
        if (this.playerSpawnCoordinate != null) {
            nbttagcompound.setInteger("SpawnX", this.playerSpawnCoordinate.x);
            nbttagcompound.setInteger("SpawnY", this.playerSpawnCoordinate.y);
            nbttagcompound.setInteger("SpawnZ", this.playerSpawnCoordinate.z);
        }
    }

    @Override
    public String getDisplayName() {
        String name = this.nickname;
        name = name.isEmpty() ? this.username : "~" + name;
        return ChatColor.get(this.chatColor) + name;
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayGUIWorkbench(int i2, int j2, int k2) {
    }

    public void displayGUIEditLabel(ItemStack itemstack, int slot) {
    }

    public void onItemPickup(Entity entity, int i2) {
    }

    @Override
    public float getEyeHeight() {
        return 0.12f;
    }

    protected void resetHeight() {
        this.yOffset = 1.62f;
    }

    public boolean killPlayer() {
        return super.attackEntityFrom(null, 100, null);
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        if (this.gamemode.isPlayerInvulnerable) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.worldObj.isMultiplayerAndNotHost) {
            this.wakeUpPlayer(true, true);
        }
        if (entity instanceof EntityMob || entity instanceof EntityArrow) {
            if (this.worldObj.difficultySetting == 0) {
                i2 = 0;
            }
            if (this.worldObj.difficultySetting == 1) {
                i2 = i2 / 3 + 1;
            }
            if (this.worldObj.difficultySetting == 3) {
                i2 = i2 * 3 / 2;
            }
        }
        if (i2 == 0) {
            return false;
        }
        Entity obj = entity;
        if (obj instanceof EntityArrow && ((EntityArrow)obj).owner != null) {
            obj = ((EntityArrow)obj).owner;
        }
        if (obj instanceof EntityLiving) {
            this.alertWolves((EntityLiving)obj, false);
        }
        this.addStat(StatList.damageTakenStat, i2);
        return super.attackEntityFrom(entity, i2, type);
    }

    protected boolean func_27025_G() {
        return false;
    }

    protected void alertWolves(EntityLiving entityliving, boolean flag) {
        EntityWolf entitywolf;
        if (entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast) {
            return;
        }
        if (entityliving instanceof EntityWolf && (entitywolf = (EntityWolf)entityliving).isWolfTamed() && this.username.equals(entitywolf.getWolfOwner())) {
            return;
        }
        if (entityliving instanceof EntityPlayer && !this.func_27025_G()) {
            return;
        }
        List<Entity> list = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
        for (Entity entity : list) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (!entitywolf1.isWolfTamed() || entitywolf1.getTarget() != null || !this.username.equals(entitywolf1.getWolfOwner()) || flag && entitywolf1.isWolfSitting()) continue;
            entitywolf1.setWolfSitting(false);
            entitywolf1.setTarget(entityliving);
        }
    }

    @Override
    protected void damageEntity(int damage, DamageType damageType) {
        if (!Minecraft.isServer) {
            System.out.println(" >> Damage: " + damage + " Type: " + (Object)((Object)damageType));
        }
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        if (!Minecraft.isServer) {
            System.out.println("Protection Value: " + (1.0f - protection));
        }
        double d2 = (float)damage * protection;
        int newDamage = (int)((double)this.rand.nextFloat() > 0.5 ? Math.floor(d2) : Math.ceil(d2));
        int preventedDamage = damage - newDamage;
        if (!Minecraft.isServer) {
            System.out.println("Damage prevented by armor: " + preventedDamage);
        }
        if (damageType != null && damageType.damageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            if (!Minecraft.isServer) {
                System.out.println("Armor Damage: " + armorDamage);
            }
            this.inventory.damageArmor(armorDamage);
        }
        if (!Minecraft.isServer) {
            System.out.println("Damage Taken: " + newDamage);
        }
        super.damageEntity(newDamage, damageType);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUITrommel(TileEntityTrommel tileEntityTrommel) {
    }

    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIGuidebook(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public void useCurrentItemOnEntity(Entity entity) {
        if (entity.interact(this)) {
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            if (itemstack.useItemOnEntity((EntityLiving)entity, this)) {
                this.swingItem();
            }
            if (itemstack.stackSize <= 0) {
                itemstack.func_1097_a(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        int i2 = this.inventory.getDamageVsEntity(entity);
        if (i2 > 0) {
            if (this.motionY < 0.0) {
                ++i2;
            }
            entity.attackEntityFrom(this, i2, DamageType.COMBAT);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity, this);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
            if (entity instanceof EntityLiving) {
                if (entity.isEntityAlive()) {
                    this.alertWolves((EntityLiving)entity, true);
                }
                this.addStat(StatList.damageDealtStat, i2);
            }
        }
    }

    public void respawnPlayer() {
    }

    public abstract void func_6420_o();

    public void onItemStackChanged(ItemStack itemstack) {
    }

    @Override
    public void setEntityDead() {
        super.setEntityDead();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public EnumSleepStatus sleepInBedAt(int x2, int y2, int z2) {
        if (!this.worldObj.isMultiplayerAndNotHost) {
            if (this.isPlayerSleeping() || !this.isEntityAlive()) {
                return EnumSleepStatus.OTHER_PROBLEM;
            }
            if (!this.worldObj.dimension.worldType.worldProvider.canRespawnHere()) {
                return EnumSleepStatus.NOT_POSSIBLE_HERE;
            }
            if (Math.abs(this.posX - (double)x2) > 3.0 || Math.abs(this.posY - (double)y2) > 3.0 || Math.abs(this.posZ - (double)z2) > 3.0) {
                return EnumSleepStatus.TOO_FAR_AWAY;
            }
            if (!(this.bedChunkCoordinates != null && this.bedChunkCoordinates.equals(x2, y2, z2) || this.playerSpawnCoordinate != null && this.playerSpawnCoordinate.equals(x2, y2, z2))) {
                this.addChatMessage("bed.setSpawn");
                this.setPlayerSpawnCoordinate(new ChunkCoordinates(x2, y2, z2));
            }
            if (this.worldObj.isDaytime() && this.worldObj.currentWeather != Weather.weatherStorm) {
                this.addChatMessage("bed.noSleep");
                return EnumSleepStatus.NOT_POSSIBLE_NOW;
            }
        }
        this.setPlayerSleeping(x2, y2, z2);
        return EnumSleepStatus.OK;
    }

    private void setPlayerSleeping(int x2, int y2, int z2) {
        this.setSize(0.2f, 0.2f);
        this.yOffset = 0.2f;
        if (this.worldObj.blockExists(x2, y2, z2)) {
            int meta = this.worldObj.getBlockMetadata(x2, y2, z2);
            int dir = BlockBed.getDirectionFromMetadata(meta);
            float xOff = 0.5f;
            float zOff = 0.5f;
            if (dir == 0) {
                zOff = 0.9f;
            } else if (dir == 1) {
                xOff = 0.1f;
            } else if (dir == 2) {
                zOff = 0.1f;
            } else if (dir == 3) {
                xOff = 0.9f;
            }
            this.func_22052_e(dir);
            this.setPosition((float)x2 + xOff, (float)y2 + 0.9375f, (float)z2 + zOff);
        } else {
            this.setPosition((float)x2 + 0.5f, (float)y2 + 0.9375f, (float)z2 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.motionX = 0.0;
        this.bedChunkCoordinates = new ChunkCoordinates(x2, y2, z2);
        if (!this.worldObj.isMultiplayerAndNotHost) {
            this.worldObj.updateEnoughPlayersSleepingFlag(this);
        }
    }

    private void func_22052_e(int i2) {
        this.field_22063_x = 0.0f;
        this.field_22061_z = 0.0f;
        switch (i2) {
            case 0: {
                this.field_22061_z = -1.8f;
                break;
            }
            case 2: {
                this.field_22061_z = 1.8f;
                break;
            }
            case 1: {
                this.field_22063_x = 1.8f;
                break;
            }
            case 3: {
                this.field_22063_x = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean flag, boolean flag1) {
        this.setSize(0.6f, 1.8f);
        this.resetHeight();
        ChunkCoordinates chunkcoordinates = this.bedChunkCoordinates;
        if (chunkcoordinates != null && this.worldObj.getBlockId(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z) == Block.bed.blockID) {
            BlockBed.setBedOccupied(this.worldObj, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, false);
            ChunkCoordinates chunkcoordinates2 = BlockBed.getNearestEmptyChunkCoordinates(this.worldObj, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, 0);
            if (chunkcoordinates2 == null) {
                chunkcoordinates2 = new ChunkCoordinates(chunkcoordinates.x, chunkcoordinates.y + 1, chunkcoordinates.z);
            }
            this.setPosition((float)chunkcoordinates2.x + 0.5f, (float)chunkcoordinates2.y + this.yOffset + 0.1f, (float)chunkcoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.worldObj.isMultiplayerAndNotHost && flag1) {
            this.worldObj.updateEnoughPlayersSleepingFlag(this);
        }
        this.sleepTimer = flag ? 0 : 100;
    }

    private boolean isInBed() {
        return this.worldObj.getBlockId(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z) == Block.bed.blockID;
    }

    public static ChunkCoordinates func_25060_a(World world, ChunkCoordinates chunkcoordinates) {
        IChunkProvider ichunkprovider = world.getIChunkProvider();
        ichunkprovider.prepareChunk(chunkcoordinates.x - 3 >> 4, chunkcoordinates.z - 3 >> 4);
        ichunkprovider.prepareChunk(chunkcoordinates.x + 3 >> 4, chunkcoordinates.z - 3 >> 4);
        ichunkprovider.prepareChunk(chunkcoordinates.x - 3 >> 4, chunkcoordinates.z + 3 >> 4);
        ichunkprovider.prepareChunk(chunkcoordinates.x + 3 >> 4, chunkcoordinates.z + 3 >> 4);
        if (world.getBlockId(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z) != Block.bed.blockID) {
            return null;
        }
        ChunkCoordinates chunkcoordinates1 = BlockBed.getNearestEmptyChunkCoordinates(world, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, 0);
        return chunkcoordinates1;
    }

    public float getBedOrientationInDegrees() {
        if (this.bedChunkCoordinates != null) {
            int i2 = this.worldObj.getBlockMetadata(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z);
            int j2 = BlockBed.getDirectionFromMetadata(i2);
            switch (j2) {
                case 0: {
                    return 90.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 270.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int func_22060_M() {
        return this.sleepTimer;
    }

    public void addChatMessage(String s2) {
    }

    public void updateCreativeInventory(int page, String searchText) {
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates chunkcoordinates) {
        this.playerSpawnCoordinate = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates) : null;
    }

    public void triggerAchievement(StatBase statbase) {
        this.addStat(statbase, 1);
    }

    public void addStat(StatBase statbase, int i2) {
    }

    public int getStat(StatBase statbase) {
        return 0;
    }

    @Override
    protected void jump() {
        super.jump();
        this.addStat(StatList.jumpStat, 1);
    }

    @Override
    public void moveEntityWithHeading(float f2, float f1) {
        double d2 = this.posX;
        double d1 = this.posY;
        double d22 = this.posZ;
        super.moveEntityWithHeading(f2, f1);
        this.addMovementStat(this.posX - d2, this.posY - d1, this.posZ - d22);
    }

    private void addMovementStat(double d2, double d1, double d22) {
        if (this.ridingEntity != null) {
            return;
        }
        if (this.isInsideOfMaterial(Material.water)) {
            int i2 = Math.round(MathHelper.sqrt_double(d2 * d2 + d1 * d1 + d22 * d22) * 100.0f);
            if (i2 > 0) {
                this.addStat(StatList.distanceDoveStat, i2);
            }
        } else if (this.isInWater()) {
            int j2 = Math.round(MathHelper.sqrt_double(d2 * d2 + d22 * d22) * 100.0f);
            if (j2 > 0) {
                this.addStat(StatList.distanceSwumStat, j2);
            }
        } else if (this.isOnLadder()) {
            if (d1 > 0.0) {
                this.addStat(StatList.distanceClimbedStat, (int)Math.round(d1 * 100.0));
            }
        } else if (this.onGround) {
            int k2 = Math.round(MathHelper.sqrt_double(d2 * d2 + d22 * d22) * 100.0f);
            if (k2 > 0) {
                this.addStat(StatList.distanceWalkedStat, k2);
            }
        } else {
            int l2 = Math.round(MathHelper.sqrt_double(d2 * d2 + d22 * d22) * 100.0f);
            if (l2 > 25) {
                this.addStat(StatList.distanceFlownStat, l2);
            }
        }
    }

    private void addMountedMovementStat(double d2, double d1, double d22) {
        int i2;
        if (this.ridingEntity != null && (i2 = Math.round(MathHelper.sqrt_double(d2 * d2 + d1 * d1 + d22 * d22) * 100.0f)) > 0) {
            if (this.ridingEntity instanceof EntityMinecart) {
                this.addStat(StatList.distanceByMinecartStat, i2);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
                } else if (this.startMinecartRidingCoordinate.getSqDistanceTo(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) >= 1000.0) {
                    this.addStat(AchievementList.onARail, 1);
                }
            } else if (this.ridingEntity instanceof EntityBoat) {
                this.addStat(StatList.distanceByBoatStat, i2);
            } else if (this.ridingEntity instanceof EntityPig) {
                this.addStat(StatList.distanceByPigStat, i2);
            }
        }
    }

    @Override
    protected void fall(float f2) {
        if (f2 >= 2.0f) {
            this.addStat(StatList.distanceFallenStat, (int)Math.round((double)f2 * 100.0));
        }
        super.fall(f2);
    }

    @Override
    public void onKillEntity(EntityLiving entityliving) {
        if (entityliving instanceof EntityMob) {
            this.triggerAchievement(AchievementList.killEnemy);
        }
    }

    @Override
    public int getItemIcon(ItemStack itemstack) {
        int i2 = super.getItemIcon(itemstack);
        if (itemstack.itemID == Item.toolFishingrod.itemID && this.fishEntity != null) {
            i2 = Item.iconCoordToIndex(5, 5);
        }
        return i2;
    }

    @Override
    public void setInPortal(int portalID) {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
            return;
        }
        this.portalID = portalID;
        this.inPortal = true;
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.gamemode.isPlayerInvulnerable;
    }

    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemodeOnLogin(Gamemode gamemode) {
        this.gamemode = gamemode;
        ContainerPlayer newContainer = gamemode.getContainer(this.inventory, !this.worldObj.isMultiplayerAndNotHost);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly) {
            this.noClip = false;
        }
        this.isImmuneToFire = gamemode.isImmuneToFire;
    }

    public void setGamemode(Gamemode gamemode) {
    }

    public void setNoclip(boolean noclip) {
        this.noClip = noclip;
        if (this.noClip) {
            this.motionY += (double)0.079f;
        }
    }
}

