/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Achievement;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPickupFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiChest;
import net.minecraft.src.GuiCrafting;
import net.minecraft.src.GuiDispenser;
import net.minecraft.src.GuiEditLabel;
import net.minecraft.src.GuiEditSign;
import net.minecraft.src.GuiFurnace;
import net.minecraft.src.GuiGuidebook;
import net.minecraft.src.GuiTrommel;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MouseFilter;
import net.minecraft.src.MovementInput;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatList;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.TileEntityTrommel;
import net.minecraft.src.World;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.ClientCommandHandler;
import net.minecraft.src.command.ClientPlayerCommandSender;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.Commands;
import net.minecraft.src.helper.PlacementMode;
import net.minecraft.src.utils.GetSkinUrlThread;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput movementInput;
    protected Minecraft mc;
    private MouseFilter field_21903_bJ = new MouseFilter();
    private MouseFilter field_21904_bK = new MouseFilter();
    private MouseFilter field_21902_bL = new MouseFilter();
    protected List<Command> allowedCommands;
    public final ClientPlayerCommandSender sender;

    public EntityPlayerSP(Minecraft minecraft, World world, Session session, int i2) {
        super(world);
        this.mc = minecraft;
        this.sender = new ClientPlayerCommandSender(minecraft, this);
        this.dimension = i2;
        this.username = session.username;
        new GetSkinUrlThread(this);
        System.out.println("logged in with session name: " + this.username);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.noClip) {
            return null;
        }
        return super.getBoundingBox();
    }

    @Override
    public void moveEntity(double d2, double d1, double d22) {
        super.moveEntity(d2, d1, d22);
    }

    @Override
    public void updatePlayerActionState() {
        super.updatePlayerActionState();
        this.moveStrafing = this.movementInput.moveStrafe;
        this.moveForward = this.movementInput.moveForward;
        this.isJumping = this.movementInput.jump;
        this.lookYaw = this.movementInput.lookYaw;
        this.lookPitch = this.movementInput.lookPitch;
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
        ContainerPlayer newContainer = gamemode.getContainer(this.inventory, !this.worldObj.isMultiplayerAndNotHost);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly) {
            this.noClip = false;
        }
        this.isImmuneToFire = gamemode.isImmuneToFire;
    }

    @Override
    public void onLivingUpdate() {
        if (this.rotationPitch + this.lookPitch <= 90.0f && this.rotationPitch + this.lookPitch >= -90.0f) {
            this.rotationPitch += this.lookPitch;
        }
        this.rotationYaw += this.lookYaw;
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal) {
            if (!this.worldObj.isMultiplayerAndNotHost && this.ridingEntity != null) {
                this.mountEntity(null);
            }
            if (this.mc.currentScreen != null) {
                this.mc.displayGuiScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSoundFX("portal.trigger", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel) {
                this.timeInPortal = 1.0f;
                if (!this.worldObj.isMultiplayerAndNotHost) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSoundFX("portal.travel", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                    int targetDim = ((BlockPortal)Block.blocksList[this.portalID]).targetDimension;
                    if (this.dimension == targetDim) {
                        this.mc.usePortal(0);
                    } else {
                        this.mc.usePortal(targetDim);
                    }
                }
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        this.movementInput.updatePlayerMoveState(this);
        if (this.movementInput.sneak && this.ySize < 0.45f) {
            this.ySize = 0.45f;
        }
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        super.onLivingUpdate();
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        super.wakeUpPlayer(flag, flag1);
        this.mc.displayGuiScreen(null);
    }

    public void resetPlayerKeyState() {
        this.movementInput.resetKeyState();
    }

    public void handleKeyPress(int i2, boolean flag) {
        this.movementInput.checkKeyForMovementInput(i2, flag);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Score", this.score);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.score = nbttagcompound.getInteger("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void displayGUIEditSign(TileEntitySign tileentitysign) {
        this.mc.displayGuiScreen(new GuiEditSign(tileentitysign));
    }

    @Override
    public void displayGUIChest(IInventory iinventory) {
        this.mc.displayGuiScreen(new GuiChest(this.inventory, iinventory));
    }

    @Override
    public void displayGUIWorkbench(int i2, int j2, int k2) {
        this.mc.displayGuiScreen(new GuiCrafting(this.inventory, this.worldObj, i2, j2, k2));
    }

    @Override
    public void displayGUIEditLabel(ItemStack itemstack, int slot) {
        this.mc.displayGuiScreen(new GuiEditLabel(itemstack, slot));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.mc.displayGuiScreen(new GuiFurnace(this.inventory, tileentityfurnace));
    }

    @Override
    public void displayGUITrommel(TileEntityTrommel tileEntityTrommel) {
        this.mc.displayGuiScreen(new GuiTrommel(this.inventory, tileEntityTrommel));
    }

    @Override
    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
        this.mc.displayGuiScreen(new GuiDispenser(this.inventory, tileentitydispenser));
    }

    public void displayGUIGuidebook() {
        this.mc.displayGuiScreen(new GuiGuidebook());
    }

    @Override
    public void onItemPickup(Entity entity, int i2) {
        this.addStat(StatList.pickUpItemStats[i2], 1);
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, entity, this, -0.5f));
    }

    public int getPlayerProtectionAmount() {
        return this.inventory.getTotalArmourPoints();
    }

    public void sendChatMessage(String s2) {
        if (s2.startsWith("/")) {
            try {
                String[] args = s2.substring(1).split(" ");
                String[] args1 = new String[args.length - 1];
                System.arraycopy(args, 1, args1, 0, args.length - 1);
                ClientCommandHandler handler = this.mc.commandHandler;
                for (Command command : Commands.commands) {
                    if (!command.isName(args[0])) continue;
                    if (!this.sender.isAdmin() && command.opRequired(args1)) {
                        this.sender.sendMessage("You don't have permission to use this command!");
                        return;
                    }
                    try {
                        boolean success = command.execute(handler, this.sender, args1);
                        if (!success) {
                            command.sendCommandSyntax(handler, this.sender);
                        }
                    }
                    catch (CommandError e2) {
                        this.sender.sendMessage("\u00a7" + ChatColor.red + e2.getMessage());
                    }
                    return;
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                this.mc.ingameGUI.addChatMessage("Error!");
                return;
            }
        }
        this.mc.ingameGUI.addChatMessage("<" + this.getDisplayName() + "\u00a7f> " + s2);
    }

    @Override
    public boolean isSneaking() {
        return this.movementInput.sneak && !this.sleeping;
    }

    public void setHealth(int i2) {
        int j2 = this.health - i2;
        if (j2 <= 0) {
            this.health = i2;
            if (j2 < 0) {
                this.heartsFlashTime = this.heartsHalvesLife / 2;
            }
        } else {
            this.field_9346_af = j2;
            this.prevHealth = this.health;
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(j2, null);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public void addChatMessage(String s2) {
        this.mc.ingameGUI.addChatMessageTranslate(s2);
    }

    @Override
    public void addStat(StatBase statbase, int i2) {
        if (statbase == null) {
            return;
        }
        if (statbase.isAchievement()) {
            Achievement achievement = (Achievement)statbase;
            if (achievement.parent == null || this.mc.statFileWriter.hasAchievementUnlocked(achievement.parent)) {
                if (!this.mc.statFileWriter.hasAchievementUnlocked(achievement)) {
                    this.mc.guiAchievement.queueTakenAchievement(achievement);
                }
                this.mc.statFileWriter.writeStat(statbase, i2);
            }
        } else {
            this.mc.statFileWriter.writeStat(statbase, i2);
        }
    }

    @Override
    public int getStat(StatBase statbase) {
        return this.mc.statFileWriter.readStat(statbase);
    }

    private boolean isBlockTranslucent(int i2, int j2, int k2) {
        return this.worldObj.isBlockNormalCube(i2, j2, k2);
    }

    @Override
    protected boolean pushOutOfBlocks(double d2, double d1, double d22) {
        if (this.noClip) {
            return false;
        }
        int i2 = MathHelper.floor_double(d2);
        int j2 = MathHelper.floor_double(d1);
        int k2 = MathHelper.floor_double(d22);
        double d3 = d2 - (double)i2;
        double d4 = d22 - (double)k2;
        if (this.isBlockTranslucent(i2, j2, k2) || this.isBlockTranslucent(i2, j2 + 1, k2)) {
            boolean flag = !this.isBlockTranslucent(i2 - 1, j2, k2) && !this.isBlockTranslucent(i2 - 1, j2 + 1, k2);
            boolean flag1 = !this.isBlockTranslucent(i2 + 1, j2, k2) && !this.isBlockTranslucent(i2 + 1, j2 + 1, k2);
            boolean flag2 = !this.isBlockTranslucent(i2, j2, k2 - 1) && !this.isBlockTranslucent(i2, j2 + 1, k2 - 1);
            boolean flag3 = !this.isBlockTranslucent(i2, j2, k2 + 1) && !this.isBlockTranslucent(i2, j2 + 1, k2 + 1);
            int byte0 = -1;
            double d5 = 9999.0;
            if (flag && d3 < d5) {
                d5 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d5) {
                d5 = d4;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d4 < d5) {
                double d6 = 1.0 - d4;
                byte0 = 5;
            }
            float f2 = 0.1f;
            if (byte0 == 0) {
                this.motionX = -f2;
            }
            if (byte0 == 1) {
                this.motionX = f2;
            }
            if (byte0 == 4) {
                this.motionZ = -f2;
            }
            if (byte0 == 5) {
                this.motionZ = f2;
            }
        }
        return false;
    }

    public void syncPlacementMode() {
        this.placementMode = (Boolean)this.mc.gameSettings.placementMode.value != false ? PlacementMode.SIDE : PlacementMode.FACING;
    }
}

