/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] fleeceColorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int growthTimer;
    public int timeSheepEating;
    public int prevTimeSheepEating;

    public EntitySheep(World world) {
        super(world);
        this.texture = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(17, (byte)0);
    }

    @Override
    public void entityInitOnSpawn() {
        super.entityInit();
        this.setFleeceColor(EntitySheep.getRandomFleeceColor(this.rand));
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i2, DamageType type) {
        return super.attackEntityFrom(entity, i2, type);
    }

    @Override
    protected void dropFewItems() {
        if (!this.getSheared()) {
            this.entityDropItem(new ItemStack(Block.wool.blockID, 1, this.getFleeceColor()), 0.0f);
        }
    }

    @Override
    protected int getDropItemId() {
        return Block.wool.blockID;
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.toolShears.itemID && !this.getSheared()) {
            if (!this.worldObj.isMultiplayerAndNotHost) {
                this.setSheared(true);
                int i2 = 2 + this.rand.nextInt(3);
                for (int j2 = 0; j2 < i2; ++j2) {
                    EntityItem entityitem = this.entityDropItem(new ItemStack(Block.wool.blockID, 1, this.getFleeceColor()), 1.0f);
                    entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                    entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                    entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, entityplayer);
        }
        return false;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Sheared", this.getSheared());
        nbttagcompound.setByte("Color", (byte)this.getFleeceColor());
        nbttagcompound.setShort("GrowthTimer", (short)this.growthTimer);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSheared(nbttagcompound.getBoolean("Sheared"));
        this.setFleeceColor(nbttagcompound.getByte("Color"));
        this.setGrowthTimer(nbttagcompound.getShort("GrowthTimer"));
    }

    @Override
    protected boolean isMovementBlocked() {
        return super.isMovementBlocked() || this.getIsSheepEating();
    }

    protected boolean getIsSheepEating() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    protected void setIsSheepEating(boolean value) {
        this.dataWatcher.updateObject(17, (byte)(value ? 1 : 0));
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getSheared()) {
            ++this.growthTimer;
        }
        if (this.growthTimer > 400) {
            this.growthTimer = 0;
            if (this.worldObj.getBlockId((int)this.posX, (int)this.posY - 1, (int)this.posZ) == Block.grass.blockID || this.worldObj.getBlockId((int)this.posX, (int)this.posY - 1, (int)this.posZ) == Block.grassRetro.blockID) {
                this.setIsSheepEating(true);
            }
            this.timeSheepEating = 0;
            this.prevTimeSheepEating = 0;
        }
        if (this.getIsSheepEating()) {
            if (this.timeSheepEating >= 5 && this.timeSheepEating <= 35 && this.timeSheepEating % 5 == 0) {
                this.worldObj.playSoundEffect(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, Block.grass.stepSound.func_1145_d(), (Block.grass.stepSound.getVolume() + 1.0f) / 8.0f, Block.grass.stepSound.getPitch() * 0.5f);
            }
            this.prevTimeSheepEating = this.timeSheepEating++;
            if (this.prevTimeSheepEating == 35) {
                this.worldObj.playSoundEffectForPlayer(null, 2001, (int)this.posX, (int)this.posY - 1, (int)this.posZ, this.worldObj.getBlockId((int)this.posX, (int)this.posY - 1, (int)this.posZ));
                this.worldObj.setBlockWithNotify((int)this.posX, (int)this.posY - 1, (int)this.posZ, Block.dirt.blockID);
                this.setSheared(false);
            }
            if (this.prevTimeSheepEating >= 40) {
                this.prevTimeSheepEating = 0;
                this.timeSheepEating = 0;
                this.setIsSheepEating(false);
            }
        }
    }

    @Override
    protected String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getFleeceColor() {
        return this.dataWatcher.getWatchableObjectByte(16) & 0xF;
    }

    public void setFleeceColor(int i2) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        this.dataWatcher.updateObject(16, (byte)(byte0 & 0xF0 | i2 & 0xF));
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 0x10));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFEF));
        }
    }

    public static int getRandomFleeceColor(Random random) {
        int i2 = random.nextInt(100);
        if (i2 < 5) {
            return 15;
        }
        if (i2 < 10) {
            return 7;
        }
        if (i2 < 15) {
            return 8;
        }
        if (i2 < 18) {
            return 12;
        }
        return random.nextInt(500) != 0 ? 0 : 6;
    }

    public void setGrowthTimer(int growthTimer) {
        this.growthTimer = growthTimer;
    }
}

