/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityMob;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class EntitySkeleton
extends EntityMob {
    private static final ItemStack defaultHeldItem = new ItemStack(Item.toolBow, 1);

    public EntitySkeleton(World world) {
        super(world);
        this.texture = "/mob/skeleton.png";
        this.scoreValue = 500;
    }

    @Override
    protected String getLivingSound() {
        return "mob.skeleton";
    }

    @Override
    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    public void onLivingUpdate() {
        float f2;
        if (this.worldObj.isDaytime() && (f2 = this.getEntityBrightness(1.0f)) > 0.5f && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f2 - 0.4f) * 2.0f && this.worldObj.getCurrentWeather() != Weather.weatherFog) {
            this.fire = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(Entity entity, float f2) {
        if (f2 < 10.0f) {
            double d2 = entity.posX - this.posX;
            double d1 = entity.posZ - this.posZ;
            if (this.attackTime == 0) {
                if (!this.worldObj.isMultiplayerAndNotHost) {
                    EntityArrow entityarrow = new EntityArrow(this.worldObj, this, false, 0);
                    entityarrow.posY += (double)1.4f;
                    double d22 = entity.posY + (double)entity.getEyeHeight() - (double)0.2f - entityarrow.posY;
                    float f1 = MathHelper.sqrt_double(d2 * d2 + d1 * d1) * 0.2f;
                    this.worldObj.playSoundAtEntity(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.worldObj.entityJoinedWorld(entityarrow);
                    entityarrow.setArrowHeading(d2, d22 + (double)f1, d1, 0.6f, 12.0f);
                }
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(d1, d2) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    @Override
    protected int getDropItemId() {
        return Item.ammoArrow.itemID;
    }

    @Override
    protected void dropFewItems() {
        int i2 = this.rand.nextInt(3);
        for (int j2 = 0; j2 < i2; ++j2) {
            this.dropItem(Item.ammoArrow.itemID, 1);
        }
        i2 = this.rand.nextInt(3);
        for (int k2 = 0; k2 < i2; ++k2) {
            this.dropItem(Item.bone.itemID, 1);
        }
    }

    @Override
    public ItemStack getHeldItem() {
        return defaultHeldItem;
    }
}

