/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntitySnowball
extends Entity {
    private int xTileSnowball = -1;
    private int yTileSnowball = -1;
    private int zTileSnowball = -1;
    private int inTileSnowball = 0;
    private boolean inGroundSnowball = false;
    public int shakeSnowball = 0;
    private EntityLiving thrower;
    private int ticksInGroundSnowball;
    private int ticksInAirSnowball = 0;

    public EntitySnowball(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean isInRangeToRenderDist(double d2) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return d2 < (d1 *= 64.0) * d1;
    }

    public EntitySnowball(World world, EntityLiving entityliving) {
        super(world);
        this.thrower = entityliving;
        this.setSize(0.25f, 0.25f);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY + (double)entityliving.getEyeHeight(), entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        float f2 = 0.4f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.setSnowballHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public EntitySnowball(World world, double d2, double d1, double d22) {
        super(world);
        this.ticksInGroundSnowball = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(d2, d1, d22);
        this.yOffset = 0.0f;
    }

    public void setSnowballHeading(double d2, double d1, double d22, float f2, float f1) {
        float f22 = MathHelper.sqrt_double(d2 * d2 + d1 * d1 + d22 * d22);
        d2 /= (double)f22;
        d1 /= (double)f22;
        d22 /= (double)f22;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d22 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d2 *= (double)f2;
        this.motionY = d1 *= (double)f2;
        this.motionZ = d22 *= (double)f2;
        float f3 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGroundSnowball = 0;
    }

    @Override
    public void setVelocity(double d2, double d1, double d22) {
        this.motionX = d2;
        this.motionY = d1;
        this.motionZ = d22;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f2 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f2) * 180.0 / 3.1415927410125732);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdate() {
        block18: {
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
            super.onUpdate();
            if (this.shakeSnowball > 0) {
                --this.shakeSnowball;
            }
            if (this.inGroundSnowball) {
                int i2 = this.worldObj.getBlockId(this.xTileSnowball, this.yTileSnowball, this.zTileSnowball);
                if (i2 != this.inTileSnowball) {
                    this.inGroundSnowball = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.ticksInGroundSnowball = 0;
                    this.ticksInAirSnowball = 0;
                    break block18;
                } else {
                    ++this.ticksInGroundSnowball;
                    if (this.ticksInGroundSnowball == 1200) {
                        this.setEntityDead();
                    }
                    return;
                }
            }
            ++this.ticksInAirSnowball;
        }
        Vec3D vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        Vec3D vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec3d1 = Vec3D.createVector(movingobjectposition.hitVec.xCoord, movingobjectposition.hitVec.yCoord, movingobjectposition.hitVec.zCoord);
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            Entity entity = null;
            List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d2 = 0.0;
            for (int l2 = 0; l2 < list.size(); ++l2) {
                double d1;
                float f4;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = list.get(l2);
                if (!entity1.canBeCollidedWith() || entity1 == this.thrower && this.ticksInAirSnowball < 5 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand(f4 = 0.3f, f4, f4)).func_1169_a(vec3d, vec3d1)) == null || !((d1 = vec3d.distanceTo(movingobjectposition1.hitVec)) < d2) && d2 != 0.0) continue;
                entity = entity1;
                d2 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entityHit == null || !movingobjectposition.entityHit.attackEntityFrom(this.thrower, 0, DamageType.COMBAT)) {
                // empty if block
            }
            for (int j2 = 0; j2 < 8; ++j2) {
                this.worldObj.spawnParticle("snowballpoof", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
            }
            this.setEntityDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f2 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f1 = 0.99f;
        float f22 = 0.03f;
        if (this.isInWater()) {
            for (int k2 = 0; k2 < 4; ++k2) {
                float f3 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
            }
            f1 = 0.8f;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.motionY -= (double)f22;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("xTile", (short)this.xTileSnowball);
        nbttagcompound.setShort("yTile", (short)this.yTileSnowball);
        nbttagcompound.setShort("zTile", (short)this.zTileSnowball);
        nbttagcompound.setShort("inTile", (short)this.inTileSnowball);
        nbttagcompound.setByte("shake", (byte)this.shakeSnowball);
        nbttagcompound.setByte("inGround", (byte)(this.inGroundSnowball ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xTileSnowball = nbttagcompound.getShort("xTile");
        this.yTileSnowball = nbttagcompound.getShort("yTile");
        this.zTileSnowball = nbttagcompound.getShort("zTile");
        this.inTileSnowball = nbttagcompound.getShort("inTile") & 0x3FFF;
        this.shakeSnowball = nbttagcompound.getByte("shake") & 0xFF;
        this.inGroundSnowball = nbttagcompound.getByte("inGround") == 1;
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.inGroundSnowball && this.thrower == entityplayer && this.shakeSnowball <= 0 && entityplayer.inventory.addItemStackToInventory(new ItemStack(Item.ammoArrow, 1))) {
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup(this, 1);
            this.setEntityDead();
        }
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

