/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.DataWatcher;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityCannonball;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityFireball;
import net.minecraft.src.EntityFish;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPebble;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.IAnimals;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet17Sleep;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet25EntityPainting;
import net.minecraft.src.Packet28EntityVelocity;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet31RelEntityMove;
import net.minecraft.src.Packet32EntityLook;
import net.minecraft.src.Packet33RelEntityMoveLook;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet35EntityNickname;
import net.minecraft.src.Packet40EntityMetadata;
import net.minecraft.src.Packet5PlayerInventory;

public class EntityTrackerEntry {
    public Entity trackedEntity;
    public int trackingDistanceThreshold;
    public int field_9234_e;
    public int encodedPosX;
    public int encodedPosY;
    public int encodedPosZ;
    public int encodedRotationYaw;
    public int encodedRotationPitch;
    public double lastTrackedEntityMotionX;
    public double lastTrackedEntityMotionY;
    public double lastTrackedEntityMotionZ;
    public int updateCounter = 0;
    private double lastTrackedEntityPosX;
    private double lastTrackedEntityPosY;
    private double lastTrackedEntityPosZ;
    private boolean firstUpdateDone = false;
    private boolean shouldSendMotionUpdates;
    private int field_28165_t = 0;
    public boolean playerEntitiesUpdated = false;
    public Set trackedPlayers = new HashSet();

    public EntityTrackerEntry(Entity entity, int trackingDistanceThreshold, int j2, boolean shouldSendMotionUpdates) {
        this.trackedEntity = entity;
        this.trackingDistanceThreshold = trackingDistanceThreshold;
        this.field_9234_e = j2;
        this.shouldSendMotionUpdates = shouldSendMotionUpdates;
        this.encodedPosX = MathHelper.floor_double(entity.posX * 32.0);
        this.encodedPosY = MathHelper.floor_double(entity.posY * 32.0);
        this.encodedPosZ = MathHelper.floor_double(entity.posZ * 32.0);
        this.encodedRotationYaw = MathHelper.floor_float(entity.rotationYaw * 256.0f / 360.0f);
        this.encodedRotationPitch = MathHelper.floor_float(entity.rotationPitch * 256.0f / 360.0f);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)obj).trackedEntity.entityId == this.trackedEntity.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.trackedEntity.entityId;
    }

    public void updatePlayerList(List list) {
        this.playerEntitiesUpdated = false;
        if (!this.firstUpdateDone || this.trackedEntity.getDistanceSq(this.lastTrackedEntityPosX, this.lastTrackedEntityPosY, this.lastTrackedEntityPosZ) > 16.0) {
            this.lastTrackedEntityPosX = this.trackedEntity.posX;
            this.lastTrackedEntityPosY = this.trackedEntity.posY;
            this.lastTrackedEntityPosZ = this.trackedEntity.posZ;
            this.firstUpdateDone = true;
            this.playerEntitiesUpdated = true;
            this.updatePlayerEntities(list);
        }
        ++this.field_28165_t;
        if (++this.updateCounter % this.field_9234_e == 0) {
            DataWatcher datawatcher;
            double d3;
            double d2;
            double d1;
            double d4;
            double d42;
            boolean hasLooked;
            int entityX = MathHelper.floor_double(this.trackedEntity.posX * 32.0);
            int entityY = MathHelper.floor_double(this.trackedEntity.posY * 32.0);
            int entityZ = MathHelper.floor_double(this.trackedEntity.posZ * 32.0);
            int entityYaw = MathHelper.floor_float(this.trackedEntity.rotationYaw * 256.0f / 360.0f);
            int entityPitch = MathHelper.floor_float(this.trackedEntity.rotationPitch * 256.0f / 360.0f);
            int dx2 = entityX - this.encodedPosX;
            int dy2 = entityY - this.encodedPosY;
            int dz2 = entityZ - this.encodedPosZ;
            Packet obj = null;
            boolean hasMoved = Math.abs(entityX) >= 8 || Math.abs(entityY) >= 8 || Math.abs(entityZ) >= 8;
            boolean bl2 = hasLooked = Math.abs(entityYaw - this.encodedRotationYaw) >= 8 || Math.abs(entityPitch - this.encodedRotationPitch) >= 8;
            if (dx2 < -128 || dx2 >= 128 || dy2 < -128 || dy2 >= 128 || dz2 < -128 || dz2 >= 128 || this.field_28165_t > 400) {
                this.field_28165_t = 0;
                this.trackedEntity.posX = (double)entityX / 32.0;
                this.trackedEntity.posY = (double)entityY / 32.0;
                this.trackedEntity.posZ = (double)entityZ / 32.0;
                obj = new Packet34EntityTeleport(this.trackedEntity.entityId, entityX, entityY, entityZ, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved && hasLooked) {
                obj = new Packet33RelEntityMoveLook(this.trackedEntity.entityId, (byte)dx2, (byte)dy2, (byte)dz2, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved) {
                obj = new Packet31RelEntityMove(this.trackedEntity.entityId, (byte)dx2, (byte)dy2, (byte)dz2);
            } else if (hasLooked) {
                obj = new Packet32EntityLook(this.trackedEntity.entityId, (byte)entityYaw, (byte)entityPitch);
            }
            if (this.shouldSendMotionUpdates && ((d42 = (d4 = this.trackedEntity.motionX - this.lastTrackedEntityMotionX) * d4 + (d1 = this.trackedEntity.motionY - this.lastTrackedEntityMotionY) * d1 + (d2 = this.trackedEntity.motionZ - this.lastTrackedEntityMotionZ) * d2) > (d3 = 0.02) * d3 || d42 > 0.0 && this.trackedEntity.motionX == 0.0 && this.trackedEntity.motionY == 0.0 && this.trackedEntity.motionZ == 0.0)) {
                this.lastTrackedEntityMotionX = this.trackedEntity.motionX;
                this.lastTrackedEntityMotionY = this.trackedEntity.motionY;
                this.lastTrackedEntityMotionZ = this.trackedEntity.motionZ;
                this.sendPacketToTrackedPlayers(new Packet28EntityVelocity(this.trackedEntity.entityId, this.lastTrackedEntityMotionX, this.lastTrackedEntityMotionY, this.lastTrackedEntityMotionZ));
            }
            if (obj != null) {
                this.sendPacketToTrackedPlayers(obj);
            }
            if ((datawatcher = this.trackedEntity.getDataWatcher()).hasObjectChanged()) {
                this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet40EntityMetadata(this.trackedEntity.entityId, datawatcher));
            }
            if (hasMoved) {
                this.encodedPosX = entityX;
                this.encodedPosY = entityY;
                this.encodedPosZ = entityZ;
            }
            if (hasLooked) {
                this.encodedRotationYaw = entityYaw;
                this.encodedRotationPitch = entityPitch;
            }
        }
        if (this.trackedEntity.beenAttacked) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet28EntityVelocity(this.trackedEntity));
            this.trackedEntity.beenAttacked = false;
        }
        if (this.trackedEntity.hadNicknameSet) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet35EntityNickname(this.trackedEntity.entityId, ((EntityLiving)this.trackedEntity).nickname, ((EntityLiving)this.trackedEntity).chatColor));
            this.trackedEntity.hadNicknameSet = false;
        }
    }

    public void sendPacketToTrackedPlayers(Packet packet) {
        for (EntityPlayerMP entityplayermp : this.trackedPlayers) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Packet packet) {
        this.sendPacketToTrackedPlayers(packet);
        if (this.trackedEntity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.trackedEntity).playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendDestroyEntityPacketToTrackedPlayers() {
        this.sendPacketToTrackedPlayers(new Packet29DestroyEntity(this.trackedEntity.entityId));
    }

    public void removeFromTrackedPlayers(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
        }
    }

    public void updatePlayerEntity(EntityPlayerMP entityplayermp) {
        if (entityplayermp == this.trackedEntity) {
            return;
        }
        double d2 = entityplayermp.posX - (double)(this.encodedPosX / 32);
        double d1 = entityplayermp.posZ - (double)(this.encodedPosZ / 32);
        if (d2 >= (double)(-this.trackingDistanceThreshold) && d2 <= (double)this.trackingDistanceThreshold && d1 >= (double)(-this.trackingDistanceThreshold) && d1 <= (double)this.trackingDistanceThreshold) {
            if (!this.trackedPlayers.contains(entityplayermp)) {
                EntityPlayer entityplayer;
                ItemStack[] aitemstack;
                this.trackedPlayers.add(entityplayermp);
                entityplayermp.playerNetServerHandler.sendPacket(this.getSpawnPacket());
                if (this.shouldSendMotionUpdates) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet28EntityVelocity(this.trackedEntity.entityId, this.trackedEntity.motionX, this.trackedEntity.motionY, this.trackedEntity.motionZ));
                }
                if ((aitemstack = this.trackedEntity.getInventory()) != null) {
                    for (int i2 = 0; i2 < aitemstack.length; ++i2) {
                        entityplayermp.playerNetServerHandler.sendPacket(new Packet5PlayerInventory(this.trackedEntity.entityId, i2, aitemstack[i2]));
                    }
                }
                if (this.trackedEntity instanceof EntityPlayer && (entityplayer = (EntityPlayer)this.trackedEntity).isPlayerSleeping()) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet17Sleep(this.trackedEntity, 0, MathHelper.floor_double(this.trackedEntity.posX), MathHelper.floor_double(this.trackedEntity.posY), MathHelper.floor_double(this.trackedEntity.posZ)));
                }
            }
        } else if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.entityId));
        }
    }

    public void updatePlayerEntities(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.updatePlayerEntity((EntityPlayerMP)list.get(i2));
        }
    }

    private Packet getSpawnPacket() {
        EntityLiving entityliving;
        if (this.trackedEntity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)this.trackedEntity;
            Packet21PickupSpawn packet21pickupspawn = new Packet21PickupSpawn(entityitem);
            entityitem.posX = (double)packet21pickupspawn.xPosition / 32.0;
            entityitem.posY = (double)packet21pickupspawn.yPosition / 32.0;
            entityitem.posZ = (double)packet21pickupspawn.zPosition / 32.0;
            return packet21pickupspawn;
        }
        if (this.trackedEntity instanceof EntityPlayerMP) {
            return new Packet20NamedEntitySpawn((EntityPlayer)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityMinecart) {
            EntityMinecart entityminecart = (EntityMinecart)this.trackedEntity;
            if (entityminecart.minecartType == 0) {
                return new Packet23VehicleSpawn(this.trackedEntity, 10);
            }
            if (entityminecart.minecartType == 1) {
                return new Packet23VehicleSpawn(this.trackedEntity, 11);
            }
            if (entityminecart.minecartType == 2) {
                return new Packet23VehicleSpawn(this.trackedEntity, 12);
            }
        }
        if (this.trackedEntity instanceof EntityBoat) {
            return new Packet23VehicleSpawn(this.trackedEntity, 1);
        }
        if (this.trackedEntity instanceof IAnimals) {
            return new Packet24MobSpawn((EntityLiving)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityFish) {
            return new Packet23VehicleSpawn(this.trackedEntity, 90);
        }
        if (this.trackedEntity instanceof EntityArrow) {
            entityliving = ((EntityArrow)this.trackedEntity).owner;
            return new Packet23VehicleSpawn(this.trackedEntity, 60, entityliving == null ? this.trackedEntity.entityId : entityliving.entityId);
        }
        if (this.trackedEntity instanceof EntityCannonball) {
            entityliving = ((EntityCannonball)this.trackedEntity).owner;
            return new Packet23VehicleSpawn(this.trackedEntity, 72, entityliving == null ? this.trackedEntity.entityId : entityliving.entityId);
        }
        if (this.trackedEntity instanceof EntitySnowball) {
            return new Packet23VehicleSpawn(this.trackedEntity, 61);
        }
        if (this.trackedEntity instanceof EntityFireball) {
            EntityFireball entityfireball = (EntityFireball)this.trackedEntity;
            Packet23VehicleSpawn packet23vehiclespawn = new Packet23VehicleSpawn(this.trackedEntity, 63, ((EntityFireball)this.trackedEntity).owner.entityId);
            packet23vehiclespawn.field_28047_e = (int)(entityfireball.field_9405_b * 8000.0);
            packet23vehiclespawn.field_28046_f = (int)(entityfireball.field_9404_c * 8000.0);
            packet23vehiclespawn.field_28045_g = (int)(entityfireball.field_9403_d * 8000.0);
            return packet23vehiclespawn;
        }
        if (this.trackedEntity instanceof EntityEgg) {
            return new Packet23VehicleSpawn(this.trackedEntity, 62);
        }
        if (this.trackedEntity instanceof EntityPebble) {
            return new Packet23VehicleSpawn(this.trackedEntity, 64);
        }
        if (this.trackedEntity instanceof EntityTNTPrimed) {
            return new Packet23VehicleSpawn(this.trackedEntity, 50);
        }
        if (this.trackedEntity instanceof EntityFallingSand) {
            EntityFallingSand entityfallingsand = (EntityFallingSand)this.trackedEntity;
            if (entityfallingsand.blockID == Block.sand.blockID) {
                return new Packet23VehicleSpawn(this.trackedEntity, 70);
            }
            if (entityfallingsand.blockID == Block.gravel.blockID) {
                return new Packet23VehicleSpawn(this.trackedEntity, 71);
            }
        }
        if (this.trackedEntity instanceof EntityPainting) {
            return new Packet25EntityPainting((EntityPainting)this.trackedEntity);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.trackedEntity.getClass() + "!");
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.entityId));
        }
    }
}

