/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Entity;
import net.minecraft.src.Explosion;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class ExplosionCannonball
extends Explosion {
    public ExplosionCannonball(World world, Entity entity, double d2, double d1, double d22, float f2) {
        super(world, entity, d2, d1, d22, f2);
    }

    @Override
    public void doExplosionA() {
        int i2 = 16;
        for (int j2 = 0; j2 < i2; ++j2) {
            for (int l2 = 0; l2 < i2; ++l2) {
                for (int j1 = 0; j1 < i2; ++j1) {
                    if (j2 != 0 && j2 != i2 - 1 && l2 != 0 && l2 != i2 - 1 && j1 != 0 && j1 != i2 - 1) continue;
                    double d2 = (float)j2 / ((float)i2 - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)l2 / ((float)i2 - 1.0f) * 2.0f - 1.0f;
                    double d22 = (float)j1 / ((float)i2 - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22);
                    d2 /= d3;
                    d1 /= d3;
                    d22 /= d3;
                    double d5 = this.explosionX;
                    double d7 = this.explosionY;
                    double d9 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.worldObj.rand.nextFloat() * 0.6f); !(f1 <= 0.0f); f1 -= f2 * 0.75f) {
                        int l4;
                        int k4;
                        int j4 = MathHelper.floor_double(d5);
                        int i5 = this.worldObj.getBlockId(j4, k4 = MathHelper.floor_double(d7), l4 = MathHelper.floor_double(d9));
                        if (i5 > 0) {
                            f1 -= (Block.blocksList[i5].getExplosionResistance(this.exploder) + 0.3f) * f2;
                        }
                        if (f1 > 0.0f) {
                            this.destroyedBlockPositions.add(new ChunkPosition(j4, k4, l4));
                        }
                        d5 += d2 * (double)f2;
                        d7 += d1 * (double)f2;
                        d9 += d22 * (double)f2;
                    }
                }
            }
        }
        this.explosionSize *= 2.0f;
        int k2 = MathHelper.floor_double(this.explosionX - (double)this.explosionSize - 1.0);
        int i1 = MathHelper.floor_double(this.explosionX + (double)this.explosionSize + 1.0);
        int k1 = MathHelper.floor_double(this.explosionY - (double)this.explosionSize - 1.0);
        int l1 = MathHelper.floor_double(this.explosionY + (double)this.explosionSize + 1.0);
        int i22 = MathHelper.floor_double(this.explosionZ - (double)this.explosionSize - 1.0);
        int j2 = MathHelper.floor_double(this.explosionZ + (double)this.explosionSize + 1.0);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBoxFromPool(k2, k1, i22, i1, l1, j2));
        Vec3D vec3d = Vec3D.createVector(this.explosionX, this.explosionY, this.explosionZ);
        for (int k22 = 0; k22 < list.size(); ++k22) {
            Entity entity = list.get(k22);
            double d4 = entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(d4 <= 1.0)) continue;
            double d6 = entity.posX - this.explosionX;
            double d8 = entity.posY - this.explosionY;
            double d10 = entity.posZ - this.explosionZ;
            double d11 = MathHelper.sqrt_double(d6 * d6 + d8 * d8 + d10 * d10);
            d6 *= 2.5;
            d8 /= d11;
            d10 *= 2.5;
            double d12 = this.worldObj.func_675_a(vec3d, entity.boundingBox);
            double d13 = (1.0 - d4) * d12;
            entity.attackEntityFrom(this.exploder, (int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)this.explosionSize + 1.0), DamageType.BLAST);
            double d14 = d13;
            entity.motionX += d6 * d14;
            entity.motionY += d8 * d14 + 0.5;
            entity.motionZ += d10 * d14;
        }
        ArrayList arraylist = new ArrayList();
        arraylist.addAll(this.destroyedBlockPositions);
        if (this.isFlaming) {
            for (int l2 = arraylist.size() - 1; l2 >= 0; --l2) {
                ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l2);
                int i3 = chunkposition.x;
                int j3 = chunkposition.y;
                int k3 = chunkposition.z;
                int l3 = this.worldObj.getBlockId(i3, j3, k3);
                int i4 = this.worldObj.getBlockId(i3, j3 - 1, k3);
                if (l3 != 0 || !Block.opaqueCubeLookup[i4] || this.ExplosionRNG.nextInt(3) != 0) continue;
                this.worldObj.setBlockWithNotify(i3, j3, k3, Block.fire.blockID);
            }
        }
    }

    @Override
    public void doExplosionB(boolean flag) {
        this.worldObj.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
        ArrayList arraylist = new ArrayList();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int i2 = arraylist.size() - 1; i2 >= 0; --i2) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i2);
            int j2 = chunkposition.x;
            int k2 = chunkposition.y;
            int l2 = chunkposition.z;
            int i1 = this.worldObj.getBlockId(j2, k2, l2);
            if (flag) {
                double d2 = (float)j2 + this.worldObj.rand.nextFloat();
                double d1 = (float)k2 + this.worldObj.rand.nextFloat();
                double d22 = (float)l2 + this.worldObj.rand.nextFloat();
                double d3 = d2 - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d22 - this.explosionZ;
                double d6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                this.worldObj.spawnParticle("explode", (d2 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d22 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.rand.nextFloat() * this.worldObj.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.worldObj.spawnParticle("smoke", d2, d1, d22, d3, d4, d5);
            }
            if (i1 <= 0 || Block.blocksList[i1].blockID != Block.glass.blockID && Block.blocksList[i1].blockMaterial != Material.snow && Block.blocksList[i1].blockMaterial != Material.plants && Block.blocksList[i1].blockMaterial != Material.web && Block.blocksList[i1].blockMaterial != Material.circuits && Block.blocksList[i1].blockMaterial != Material.ice) continue;
            Block.blocksList[i1].dropBlockAsItemWithChance(this.worldObj, j2, k2, l2, this.worldObj.getBlockMetadata(j2, k2, l2), 0.3f);
            this.worldObj.setBlockWithNotify(j2, k2, l2, 0);
            Block.blocksList[i1].onBlockDestroyedByExplosion(this.worldObj, j2, k2, l2);
        }
    }
}

