/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;
import net.minecraft.src.helper.Color;
import net.minecraft.src.helper.Colors;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] charWidth;
    public int fontTextureID = 0;
    private final int fontLists = GLAllocation.generateDisplayLists(288);
    private IntBuffer listBuffer;

    public FontRenderer(GameSettings gamesettings, String fontPath, RenderEngine renderengine) {
        BufferedImage image;
        this.charWidth = new int[256];
        this.listBuffer = GLAllocation.createDirectIntBuffer(1024);
        try {
            image = ImageIO.read(renderengine.texturePacks.selectedTexturePack.getResourceAsStream(fontPath));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        for (int charIndex = 0; charIndex < 256; ++charIndex) {
            int currentWidth;
            int charX = charIndex % 16;
            int charY = charIndex / 16;
            for (currentWidth = 8 * (width / 128) - 1; currentWidth >= 0; --currentWidth) {
                int xIndex = charX * (8 * (width / 128)) + currentWidth;
                boolean isPixelEmpty = true;
                for (int y2 = 0; y2 < 8 * (width / 128) && isPixelEmpty; ++y2) {
                    int yIndex = (charY * (8 * (width / 128)) + y2) * width;
                    int pixelRGB = pixels[xIndex + yIndex] & 0xFF;
                    if (pixelRGB <= 0) continue;
                    isPixelEmpty = false;
                }
                if (!isPixelEmpty) break;
            }
            if (charIndex == 32) {
                currentWidth = 2;
            }
            this.charWidth[charIndex] = currentWidth / (width / 128) + 2;
        }
        this.fontTextureID = renderengine.allocateAndSetupTexture(image);
        Tessellator t2 = Tessellator.instance;
        for (int charIndex = 0; charIndex < 256; ++charIndex) {
            GL11.glNewList((int)(this.fontLists + charIndex), (int)4864);
            t2.startDrawingQuads();
            int x2 = charIndex % 16 * 8;
            int y3 = charIndex / 16 * 8;
            float charSize = 7.99f;
            float xOffset = 0.0f;
            float yOffset = 0.0f;
            t2.addVertexWithUV(0.0, 0.0f + charSize, 0.0, (float)x2 / 128.0f + xOffset, ((float)y3 + charSize) / 128.0f + yOffset);
            t2.addVertexWithUV(0.0f + charSize, 0.0f + charSize, 0.0, ((float)x2 + charSize) / 128.0f + xOffset, ((float)y3 + charSize) / 128.0f + yOffset);
            t2.addVertexWithUV(0.0f + charSize, 0.0, 0.0, ((float)x2 + charSize) / 128.0f + xOffset, (float)y3 / 128.0f + yOffset);
            t2.addVertexWithUV(0.0, 0.0, 0.0, (float)x2 / 128.0f + xOffset, (float)y3 / 128.0f + yOffset);
            t2.draw();
            GL11.glTranslatef((float)this.charWidth[charIndex], (float)0.0f, (float)0.0f);
            GL11.glEndList();
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            Color color = Colors.allChatColors[i2 & 0xF];
            int r2 = color.getRed();
            int g2 = color.getGreen();
            int b2 = color.getBlue();
            if (i2 >= 16) {
                r2 /= 4;
                g2 /= 4;
                b2 /= 4;
            }
            GL11.glNewList((int)(this.fontLists + 256 + i2), (int)4864);
            GL11.glColor3f((float)((float)r2 / 255.0f), (float)((float)g2 / 255.0f), (float)((float)b2 / 255.0f));
            GL11.glEndList();
        }
    }

    public void drawCenteredString(String string, int x2, int y2, int color) {
        int length = this.getStringWidth(string);
        this.drawStringWithShadow(string, x2 - length / 2, y2, color);
    }

    public void drawStringWithShadow(String string, int x2, int y2, int color) {
        this.renderString(string, x2 + 1, y2 + 1, color, true);
        this.drawString(string, x2, y2, color);
    }

    public void drawString(String string, int x2, int y2, int color) {
        this.renderString(string, x2, y2, color, false);
    }

    private void renderString(String string, int x2, int y2, int color, boolean isShadow) {
        if (string == null) {
            return;
        }
        if (isShadow) {
            int alphaChannelOnly = color & 0xFF000000;
            color = (color & 0xFCFCFC) >> 2;
            color += alphaChannelOnly;
        }
        GL11.glBindTexture((int)3553, (int)this.fontTextureID);
        float r2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a2 == 0.0f) {
            a2 = 1.0f;
        }
        GL11.glColor4f((float)r2, (float)g2, (float)b2, (float)a2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x2, (float)y2, (float)0.0f);
        this.listBuffer.clear();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int charIndex;
            while (string.length() > i2 + 1 && string.charAt(i2) == '\u00a7') {
                int colorCode = "0123456789abcdef".indexOf(string.toLowerCase().charAt(i2 + 1));
                this.bufferList(this.fontLists + 256 + colorCode + (isShadow ? 16 : 0));
                i2 += 2;
            }
            if (i2 >= string.length() || (charIndex = ChatAllowedCharacters.allowedCharacters.indexOf(string.charAt(i2))) < 0) continue;
            this.bufferList(this.fontLists + charIndex + 32);
        }
        this.drawLists();
        GL11.glPopMatrix();
    }

    public void bufferList(int i2) {
        this.listBuffer.put(i2);
        if (this.listBuffer.remaining() == 0) {
            this.drawLists();
        }
    }

    public void drawLists() {
        this.listBuffer.flip();
        GL11.glCallLists((IntBuffer)this.listBuffer);
        this.listBuffer.clear();
    }

    public int getStringWidth(String s2) {
        if (s2 == null) {
            return 0;
        }
        int i2 = 0;
        for (int j2 = 0; j2 < s2.length(); ++j2) {
            if (s2.charAt(j2) == '\u00a7') {
                ++j2;
                continue;
            }
            int k2 = ChatAllowedCharacters.allowedCharacters.indexOf(s2.charAt(j2));
            if (k2 < 0) continue;
            i2 += this.charWidth[k2 + 32];
        }
        return i2;
    }

    public void func_27278_a(String s2, int i2, int j2, int k2, int l2) {
        String[] as2 = s2.split("\n");
        if (as2.length > 1) {
            for (int i1 = 0; i1 < as2.length; ++i1) {
                this.func_27278_a(as2[i1], i2, j2, k2, l2);
                j2 += this.func_27277_a(as2[i1], k2);
            }
            return;
        }
        String[] as1 = s2.split(" ");
        int j1 = 0;
        while (j1 < as1.length) {
            String s1 = as1[j1++] + " ";
            while (j1 < as1.length && this.getStringWidth(s1 + as1[j1]) < k2) {
                s1 = s1 + as1[j1++] + " ";
            }
            while (this.getStringWidth(s1) > k2) {
                int k1 = 0;
                while (this.getStringWidth(s1.substring(0, k1 + 1)) <= k2) {
                    ++k1;
                }
                if (s1.substring(0, k1).trim().length() > 0) {
                    this.drawString(s1.substring(0, k1), i2, j2, l2);
                    j2 += 8;
                }
                s1 = s1.substring(k1);
            }
            if (s1.trim().length() <= 0) continue;
            this.drawString(s1, i2, j2, l2);
            j2 += 8;
        }
    }

    public int func_27277_a(String s2, int i2) {
        String[] as2 = s2.split("\n");
        if (as2.length > 1) {
            int j2 = 0;
            for (int k2 = 0; k2 < as2.length; ++k2) {
                j2 += this.func_27277_a(as2[k2], i2);
            }
            return j2;
        }
        String[] as1 = s2.split(" ");
        int l2 = 0;
        int i1 = 0;
        while (l2 < as1.length) {
            String s1 = as1[l2++] + " ";
            while (l2 < as1.length && this.getStringWidth(s1 + as1[l2]) < i2) {
                s1 = s1 + as1[l2++] + " ";
            }
            while (this.getStringWidth(s1) > i2) {
                int j1 = 0;
                while (this.getStringWidth(s1.substring(0, j1 + 1)) <= i2) {
                    ++j1;
                }
                if (s1.substring(0, j1).trim().length() > 0) {
                    i1 += 8;
                }
                s1 = s1.substring(j1);
            }
            if (s1.trim().length() <= 0) continue;
            i1 += 8;
        }
        if (i1 < 8) {
            i1 += 8;
        }
        return i1;
    }
}

