/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    public static List<Integer> displayLists = new ArrayList<Integer>();
    public static List<Integer> textureNames = new ArrayList<Integer>();

    public static synchronized int generateDisplayLists(int range) {
        int list = GL11.glGenLists((int)range);
        displayLists.add(list);
        displayLists.add(range);
        return list;
    }

    public static synchronized void generateTextureNames(IntBuffer intbuffer) {
        GL11.glGenTextures((IntBuffer)intbuffer);
        for (int i2 = intbuffer.position(); i2 < intbuffer.limit(); ++i2) {
            textureNames.add(intbuffer.get(i2));
        }
    }

    public static synchronized int generateTexture() {
        int tex = GL11.glGenTextures();
        textureNames.add(tex);
        return tex;
    }

    public static synchronized void func_28194_b(int i2) {
        int j2 = displayLists.indexOf(i2);
        GL11.glDeleteLists((int)displayLists.get(j2), (int)displayLists.get(j2 + 1));
        displayLists.remove(j2);
        displayLists.remove(j2);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        for (int i2 = 0; i2 < displayLists.size(); i2 += 2) {
            GL11.glDeleteLists((int)displayLists.get(i2), (int)displayLists.get(i2 + 1));
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(textureNames.size());
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        for (int j2 = 0; j2 < textureNames.size(); ++j2) {
            intbuffer.put(textureNames.get(j2));
        }
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        displayLists.clear();
        textureNames.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int i2) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i2).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int i2) {
        return GLAllocation.createDirectByteBuffer(i2 << 2).asIntBuffer();
    }

    public static FloatBuffer createDirectFloatBuffer(int i2) {
        return GLAllocation.createDirectByteBuffer(i2 << 2).asFloatBuffer();
    }
}

