/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import b100.utils.ReflectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.src.KeyBinding;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.helper.Color;
import net.minecraft.src.option.BooleanOption;
import net.minecraft.src.option.ColorOption;
import net.minecraft.src.option.FloatOption;
import net.minecraft.src.option.ImmersiveModeOption;
import net.minecraft.src.option.IntegerOption;
import net.minecraft.src.option.Option;
import net.minecraft.src.option.StringOption;
import net.minecraft.src.option.VolumeOption;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"options.renderDistance.extreme", "options.renderDistance.far", "options.renderDistance.normal", "options.renderDistance.short", "options.renderDistance.tiny"};
    private static final String[] DIFFICULTIES = new String[]{"options.difficulty.peaceful", "options.difficulty.easy", "options.difficulty.normal", "options.difficulty.hard"};
    private static final String[] LIMIT_FRAMERATES = new String[]{"performance.max", "performance.balanced", "performance.powersaver", "performance.vsync"};
    private static final String[] ANIMATIONS = new String[]{"options.animations.off", "options.animations.procedural", "options.animations.custom"};
    public final Minecraft mc;
    private File optionsFile;
    public VolumeOption musicVolume = new VolumeOption(this, "music", 1.0f);
    public VolumeOption soundVolume = new VolumeOption(this, "sound", 1.0f);
    public FloatOption FoV = new FloatOption(this, "fov", 0.40140846f);
    public FloatOption mouseSensitivity = new FloatOption(this, "mouseSensitivity", 0.5f);
    public FloatOption field_22272_F = new FloatOption(this, "field_22272_F", 1.0f);
    public FloatOption field_22271_G = new FloatOption(this, "field_22271_G", 1.0f);
    public FloatOption screenPadding = new FloatOption(this, "screenPadding", 0.0f);
    public FloatOption gamma = new FloatOption(this, "gamma", 0.5f);
    public FloatOption controllerSensitivity = new FloatOption(this, "controllerSensitivity", 0.5f);
    public FloatOption controllerMenuSensitivity = new FloatOption(this, "controllerMenuSensitivity", 0.5f);
    public FloatOption controllerDeadzoneLeft = new FloatOption(this, "controllerDeadzoneL", 0.25f);
    public FloatOption controllerDeadzoneRight = new FloatOption(this, "controllerDeadzoneR", 0.25f);
    public BooleanOption invertMouse = new BooleanOption(this, "invertYMouse", false);
    public BooleanOption rawMouseInput = new BooleanOption(this, "rawMouseInput", false);
    public BooleanOption viewBobbing = new BooleanOption(this, "bobView", true);
    public BooleanOption anaglyph = new BooleanOption(this, "anaglyph3d", false);
    public BooleanOption advancedOpenGL = new BooleanOption(this, "advancedOpengl", false);
    public BooleanOption fancyGraphics = new BooleanOption(this, "fancyGraphics", true);
    public BooleanOption treeShadows = new BooleanOption(this, "treeShadows", true);
    public BooleanOption ambientOcclusion = new BooleanOption(this, "ambientOcclusion", true);
    public BooleanOption chunkLoading = new BooleanOption(this, "chunkLoading", true);
    public BooleanOption items3D = new BooleanOption(this, "3Ditems", false);
    public BooleanOption field_22275_C = new BooleanOption(this, "field_22275_C", false);
    public BooleanOption smoothCamera = new BooleanOption(this, "smoothCamera", false);
    public BooleanOption lockCamera = new BooleanOption(this, "lockCamera", false);
    public BooleanOption biomeWater = new BooleanOption(this, "biomeWater", true);
    public BooleanOption vignette = new BooleanOption(this, "vignette", true);
    public BooleanOption showPlayerList = new BooleanOption(this, "showPlayerList", false);
    public BooleanOption slimeParticles = new BooleanOption(this, "slimeParticles", true);
    public BooleanOption disableAllShaders = new BooleanOption(this, "disableAllShaders", false);
    public BooleanOption shaders = new BooleanOption(this, "shaders", true);
    public BooleanOption placementMode = new BooleanOption(this, "placementMode", false);
    public BooleanOption customShaders = new BooleanOption(this, "customShaders", false);
    public BooleanOption autoHit = new BooleanOption(this, "autoHit", true);
    public BooleanOption foodHealthRegenOverlay = new BooleanOption(this, "foodHealthRegenOverlay", true);
    public BooleanOption fpsInOverlay = new BooleanOption(this, "fpsInOverlay", false);
    public BooleanOption controllerSwapShoulderButtons = new BooleanOption(this, "controllerSwapShoulderButtons", false);
    public BooleanOption controllerSwapAB = new BooleanOption(this, "controllerSwapAB", false);
    public BooleanOption controllerSwapXY = new BooleanOption(this, "controllerSwapXY", false);
    public BooleanOption worldHoleFix = new BooleanOption(this, "worldHoleFix", false);
    public BooleanOption clouds = new BooleanOption(this, "clouds", true);
    public BooleanOption armorDurabilityOverlay = new BooleanOption(this, "armorDurabilityOverlay", false);
    public BooleanOption armorProtectionOverlay = new BooleanOption(this, "armorProtectionOverlay", true);
    public BooleanOption heldItemCountOverlay = new BooleanOption(this, "heldItemCountOverlay", false);
    public BooleanOption pauseOnLostFocus = new BooleanOption(this, "pauseOnLostFocus", true);
    public BooleanOption showDebugScreen = new BooleanOption(this, "showDebugScreen", false);
    public BooleanOption showFrameTimes = new BooleanOption(this, "showFrameTimes", false);
    public BooleanOption showItemDurability = new BooleanOption(this, "showItemDurability", false);
    public BooleanOption swapCraftingButtons = new BooleanOption(this, "swapCraftingButtons", false);
    public BooleanOption downloadSoundfiles = new BooleanOption(this, "downloadSoundfiles", true);
    public BooleanOption allowSoundOverrides = new BooleanOption(this, "allowSoundOverrides", false);
    public BooleanOption loadAllSounds = new BooleanOption(this, "loadAllSounds", false);
    public BooleanOption overlayShowCoords = new BooleanOption(this, "overlayShowCoords", true);
    public BooleanOption overlayShowDirection = new BooleanOption(this, "overlayShowDirection", true);
    public BooleanOption overlayShowTime = new BooleanOption(this, "overlayShowTime", true);
    public BooleanOption overlayShowSeason = new BooleanOption(this, "overlayShowSeason", true);
    public BooleanOption overlayShowWeather = new BooleanOption(this, "overlayShowWeather", true);
    public BooleanOption overlayShowBiome = new BooleanOption(this, "overlayShowBiome", true);
    public BooleanOption[] overlayElements = new BooleanOption[]{this.overlayShowCoords, this.overlayShowDirection, this.overlayShowTime, this.overlayShowSeason, this.overlayShowWeather, this.overlayShowBiome};
    public IntegerOption difficulty = new IntegerOption(this, "difficulty", 2);
    public IntegerOption thirdPersonView = new IntegerOption(this, "thirdPersonView", 0);
    public IntegerOption renderDistance = new IntegerOption(this, "renderDistance", 0);
    public IntegerOption limitFramerate = new IntegerOption(this, "limitFramerate", 0);
    public IntegerOption guiScale = new IntegerOption(this, "guiScale", 0);
    public IntegerOption overlayMode = new IntegerOption(this, "overlayMode", 0);
    public IntegerOption rotationOverlayMode = new IntegerOption(this, "rotationOverlayMode", 0);
    public IntegerOption animations = new IntegerOption(this, "animations", 2);
    public IntegerOption playerListPosition = new IntegerOption(this, "playerListPosition", 2);
    public StringOption lastServer = new StringOption(this, "lastServer", "");
    public StringOption skin = new StringOption(this, "skin", "Default");
    public StringOption shaderpack = new StringOption(this, "shaderpack", "");
    public StringOption selectedController = new StringOption(this, "selectedController", "");
    public ImmersiveModeOption immersiveMode = new ImmersiveModeOption(this);
    public ColorOption guiBackgroundColor = new ColorOption(this, "guiBackgroundColor", new Color().setARGB(-1072689136));
    public IntegerOption mipmapLevels = new IntegerOption(this, "mipmapLevels", 0);
    public BooleanOption mipmapSmooth = new BooleanOption(this, "mipmapSmooth", true);
    public KeyBinding keyForward = new KeyBinding("key.forward", 17);
    public KeyBinding keyLeft = new KeyBinding("key.left", 30);
    public KeyBinding keyBack = new KeyBinding("key.back", 31);
    public KeyBinding keyRight = new KeyBinding("key.right", 32);
    public KeyBinding keyJump = new KeyBinding("key.jump", 57);
    public KeyBinding keyInventory = new KeyBinding("key.inventory", 18);
    public KeyBinding keyDrop = new KeyBinding("key.drop", 16);
    public KeyBinding keyChat = new KeyBinding("key.chat", 20);
    public KeyBinding keyToggleFog = new KeyBinding("key.fog", 33);
    public KeyBinding keySneak = new KeyBinding("key.sneak", 42);
    public KeyBinding keyFly = new KeyBinding("key.fly", 29);
    public KeyBinding keyGuidebook = new KeyBinding("key.guidebook", 19);
    public KeyBinding keyHotBarLeft = new KeyBinding("key.hotbar.left", 51);
    public KeyBinding keyHotBarRight = new KeyBinding("key.hotbar.right", 52);
    public KeyBinding keyHotBarSwitch = new KeyBinding("key.hotbar.switch", 15);
    public KeyBinding keyLookLeft = new KeyBinding("key.look.left", 203);
    public KeyBinding keyLookRight = new KeyBinding("key.look.right", 205);
    public KeyBinding keyLookUp = new KeyBinding("key.look.up", 200);
    public KeyBinding keyLookDown = new KeyBinding("key.look.down", 208);
    public KeyBinding keyCenterView = new KeyBinding("key.look.center", 207);
    public KeyBinding keyZoom = new KeyBinding("key.zoom", 46);
    public KeyBinding keyPlayerList = new KeyBinding("key.playerList", 38);
    public KeyBinding keyPhotoMode = new KeyBinding("key.photoMode", 25);
    public KeyBinding keyLockRotation = new KeyBinding("key.lockRotation", 44);
    public KeyBinding keyScreenshot = new KeyBinding("key.screenshot", 60);
    public KeyBinding keyCinematicCamera = new KeyBinding("key.cinematicCamera", 66);
    public KeyBinding keySwitchPerspective = new KeyBinding("key.switchPerspective", 63);
    public KeyBinding keyHideGui = new KeyBinding("key.immersiveMode", 59);
    public KeyBinding[] keys = ReflectUtils.getAllObjects(GameSettings.class, KeyBinding.class, this);

    public Option<?>[] getAllOptions() {
        return ReflectUtils.getAllObjects(GameSettings.class, Option.class, this);
    }

    public KeyBinding getKey(int i2) {
        return this.keys[i2];
    }

    public String getKeyName(int i2) {
        i2 = this.getKey((int)i2).key;
        return i2 == -1 ? "DISABLED" : Keyboard.getKeyName((int)i2);
    }

    public String getKeyBindName(int id2) {
        return StringTranslate.getInstance().translateKey(this.getKey((int)id2).name);
    }

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.loadOptions();
    }

    public String getDisplayString(Option<?> option) {
        if (option == null) {
            return "";
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        String s2 = stringtranslate.translateKey("options." + option.name) + ": ";
        if (option instanceof FloatOption) {
            Float f2 = (Float)option.value;
            if (option == this.mouseSensitivity) {
                if (f2.floatValue() == 0.0f) {
                    return s2 + stringtranslate.translateKey("options.mouseSensitivity.min");
                }
                if (f2.floatValue() == 1.0f) {
                    return s2 + stringtranslate.translateKey("options.mouseSensitivity.max");
                }
                return s2 + (int)(f2.floatValue() * 200.0f) + "%";
            }
            if (option == this.FoV) {
                if (f2.floatValue() == 0.0f) {
                    return s2 + stringtranslate.translateKey("options.fov.min");
                }
                if (f2.floatValue() == 1.0f) {
                    return s2 + stringtranslate.translateKey("options.fov.max");
                }
                return s2 + (int)(f2.floatValue() * 100.0f + 30.0f);
            }
            if (option == this.screenPadding) {
                int percent = (int)(f2.floatValue() * 100.0f);
                return s2 + percent + "%";
            }
            if (option == this.gamma) {
                int percent = (int)(f2.floatValue() * 100.0f);
                return s2 + percent + "%";
            }
            if (f2.floatValue() == 0.0f) {
                return s2 + stringtranslate.translateKey("options.off");
            }
            return s2 + (int)(f2.floatValue() * 100.0f) + "%";
        }
        if (option == this.renderDistance) {
            return s2 + stringtranslate.translateKey(RENDER_DISTANCES[(Integer)this.renderDistance.value]);
        }
        if (option == this.difficulty) {
            return s2 + stringtranslate.translateKey(DIFFICULTIES[(Integer)this.difficulty.value]);
        }
        if (option == this.guiScale) {
            if ((Integer)this.guiScale.value == 0) {
                return s2 + stringtranslate.translateKey("options.guiScale.auto");
            }
            return s2 + this.guiScale.value;
        }
        if (option == this.limitFramerate) {
            return s2 + stringtranslate.translateKey(LIMIT_FRAMERATES[(Integer)this.limitFramerate.value]);
        }
        if (option == this.animations) {
            return s2 + stringtranslate.translateKey(ANIMATIONS[(Integer)this.animations.value]);
        }
        if (option == this.fancyGraphics) {
            if (((Boolean)this.fancyGraphics.value).booleanValue()) {
                return s2 + stringtranslate.translateKey("options.graphics.fancy");
            }
            return s2 + stringtranslate.translateKey("options.graphics.fast");
        }
        if (option == this.chunkLoading) {
            if (((Boolean)this.chunkLoading.value).booleanValue()) {
                return s2 + stringtranslate.translateKey("options.chunkloading.dynamic");
            }
            return s2 + stringtranslate.translateKey("options.chunkloading.static");
        }
        if (option == this.placementMode) {
            if (((Boolean)this.placementMode.value).booleanValue()) {
                return s2 + stringtranslate.translateKey("options.placementMode.side");
            }
            return s2 + stringtranslate.translateKey("options.placementMode.direction");
        }
        if (option instanceof BooleanOption) {
            Boolean flag = (Boolean)option.value;
            if (flag.booleanValue()) {
                return s2 + stringtranslate.translateKey("options.on");
            }
            return s2 + stringtranslate.translateKey("options.off");
        }
        if (option instanceof IntegerOption) {
            return s2 + option.value;
        }
        return s2;
    }

    public void setOptionValue(Option<?> option, int delta) {
        Option option2;
        if (option instanceof IntegerOption) {
            option2 = (IntegerOption)option;
            option2.set((Integer)((IntegerOption)option2).value + delta);
        }
        if (option instanceof BooleanOption) {
            option2 = (BooleanOption)option;
            ((BooleanOption)option2).toggle();
        }
        if (option == this.renderDistance) {
            this.renderDistance.value = ((Integer)this.renderDistance.value + 5) % 5;
        }
        if (option == this.guiScale) {
            int max = this.mc.resolution.getMaxScale() + 1;
            this.guiScale.value = ((Integer)this.guiScale.value + max) % max;
        }
        if (option == this.limitFramerate) {
            this.limitFramerate.value = ((Integer)this.limitFramerate.value + 4) % 4;
            Display.setVSyncEnabled(((Integer)this.limitFramerate.value == 3 ? 1 : 0) != 0);
        }
        if (option == this.difficulty) {
            this.difficulty.value = ((Integer)this.difficulty.value + 4) % 4;
        }
        if (option == this.fancyGraphics) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.ambientOcclusion) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.advancedOpenGL) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.biomeWater) {
            this.mc.renderGlobal.loadRenderers();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.treeShadows) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.anaglyph) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.placementMode && this.mc.thePlayer != null) {
            this.mc.thePlayer.syncPlacementMode();
        }
        if (option == this.animations) {
            this.animations.value = ((Integer)this.animations.value + 3) % 3;
            this.mc.renderEngine.refreshTextures();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.mipmapLevels) {
            this.mipmapLevels.value = ((Integer)this.mipmapLevels.value + 4) % 4;
        }
    }

    public float getOptionFloatValue(Option<?> option) {
        if (option instanceof FloatOption) {
            FloatOption option2 = (FloatOption)option;
            return option2.get();
        }
        return 0.0f;
    }

    public void setOptionFloatValue(Option<?> option, float sliderValue) {
        option.update();
        if (option instanceof FloatOption) {
            FloatOption option2 = (FloatOption)option;
            option2.set(Float.valueOf(sliderValue));
        }
        if (option == this.gamma) {
            this.shaders.value = true;
        }
    }

    public void loadOptions() {
        if (!this.optionsFile.exists()) {
            return;
        }
        try {
            BufferedReader br2 = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            while ((line = br2.readLine()) != null) {
                try {
                    String[] as2 = line.split(":");
                    String key = as2[0];
                    String value = as2[1];
                    for (Option<?> option : this.getAllOptions()) {
                        if (!option.name.equalsIgnoreCase(key)) continue;
                        option.parse(value);
                    }
                    for (int i2 = 0; i2 < this.keys.length; ++i2) {
                        if (!key.equals("key_" + this.keys[i2].name)) continue;
                        this.keys[i2].setKeyCode(Integer.parseInt(value));
                    }
                }
                catch (Exception exception1) {
                    System.out.println("Skipping bad option: " + line);
                }
            }
            br2.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (Option<?> option : this.getAllOptions()) {
                printwriter.println(option.name + ":" + option.getValueString());
            }
            for (KeyBinding key : this.keys) {
                printwriter.println("key_" + key.name + ":" + key.keyCode());
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

