/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GamemodeCreative;
import net.minecraft.src.GamemodeSurvival;
import net.minecraft.src.GuiInventory;
import net.minecraft.src.InventoryPlayer;

public abstract class Gamemode {
    public int id;
    public String languageKey = "";
    public boolean isPlayerInvulnerable = false;
    public boolean canPlayerFly = false;
    public boolean consumeBlocks = false;
    public boolean doBlockBreakingAnim = false;
    public boolean toolDurability = false;
    public boolean dropBlockOnBreak = false;
    public boolean areMobsHostile = false;
    public boolean hasMiddleClick = false;
    public boolean isImmuneToFire = false;
    public boolean instantPortalTravel = false;
    public static final Gamemode[] gamemodesList = new Gamemode[2];
    public static final Gamemode survival = new GamemodeSurvival(0).setLanguageKey("gamemode.survival").setConsumeBlocks().setDoBlockBreakingAnim().setToolDurability().setDropBlockOnBreak().setAreMobsHostile();
    public static final Gamemode creative = new GamemodeCreative(1).setLanguageKey("gamemode.creative").setIsPlayerInvulnerable().setCanPlayerFly().setHasMiddleClick().setIsImmuneToFire().setInstantPortalTravel();

    public Gamemode(int id2) {
        this.id = id2;
        Gamemode.gamemodesList[id2] = this;
    }

    public Gamemode setLanguageKey(String key) {
        this.languageKey = key;
        return this;
    }

    public Gamemode setIsPlayerInvulnerable() {
        this.isPlayerInvulnerable = true;
        return this;
    }

    public Gamemode setCanPlayerFly() {
        this.canPlayerFly = true;
        return this;
    }

    public Gamemode setConsumeBlocks() {
        this.consumeBlocks = true;
        return this;
    }

    public Gamemode setDoBlockBreakingAnim() {
        this.doBlockBreakingAnim = true;
        return this;
    }

    public Gamemode setToolDurability() {
        this.toolDurability = true;
        return this;
    }

    public Gamemode setDropBlockOnBreak() {
        this.dropBlockOnBreak = true;
        return this;
    }

    public Gamemode setAreMobsHostile() {
        this.areMobsHostile = true;
        return this;
    }

    public Gamemode setHasMiddleClick() {
        this.hasMiddleClick = true;
        return this;
    }

    public Gamemode setIsImmuneToFire() {
        this.isImmuneToFire = true;
        return this;
    }

    public Gamemode setInstantPortalTravel() {
        this.instantPortalTravel = true;
        return this;
    }

    public abstract ContainerPlayer getContainer(InventoryPlayer var1, boolean var2);

    public abstract GuiInventory getInventoryGui(EntityPlayer var1);
}

