/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.gui.GuiElement;
import net.minecraft.src.helper.Listener;
import org.lwjgl.opengl.GL11;

public class GuiButton
extends Gui
implements GuiElement {
    protected int width = 200;
    protected int height = 20;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    public Listener<GuiButton> listener;

    public GuiButton(int id2, int xPosition, int yPosition, String s2) {
        this(id2, xPosition, yPosition, 200, 20, s2);
    }

    public GuiButton(int id2, int xPosition, int yPosition, int width, int height, String s2) {
        this.id = id2;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayString = s2;
    }

    protected int getButtonState(boolean hovered) {
        int byte0 = 1;
        if (!this.enabled) {
            byte0 = 0;
        } else if (hovered) {
            byte0 = 2;
        }
        return byte0;
    }

    public void drawButton(Minecraft minecraft, int i2, int j2) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = minecraft.fontRenderer;
        GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean flag = i2 >= this.xPosition && j2 >= this.yPosition && i2 < this.xPosition + this.width && j2 < this.yPosition + this.height;
        int k2 = this.getButtonState(flag);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46 + k2 * 20, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46 + k2 * 20, this.width / 2, this.height);
        this.mouseDragged(minecraft, i2, j2);
        if (!this.enabled) {
            this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, -6250336);
        } else if (flag) {
            this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xFFFFA0);
        } else {
            this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
        }
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    protected void mouseDragged(Minecraft minecraft, int i2, int j2) {
    }

    public void mouseReleased(int i2, int j2) {
    }

    public boolean mousePressed(Minecraft minecraft, int i2, int j2) {
        return this.enabled && i2 >= this.xPosition && j2 >= this.yPosition && i2 < this.xPosition + this.width && j2 < this.yPosition + this.height;
    }

    public GuiButton setListener(Listener<GuiButton> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void setX(int x2) {
        this.xPosition = x2;
    }

    @Override
    public void setY(int y2) {
        this.yPosition = y2;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.xPosition;
    }

    @Override
    public int getY() {
        return this.yPosition;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

