/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Container;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotCrafting;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TextureFX;
import net.minecraft.src.command.ChatColor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    public int xSize = 176;
    public int ySize = 166;
    public Container inventorySlots;

    public GuiContainer(Container container) {
        this.inventorySlots = container;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    protected void drawGuiContainerForegroundLayer() {
    }

    @Override
    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        this.drawDefaultBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(renderPartialTicks);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        Slot slot = null;
        for (int i1 = 0; i1 < this.inventorySlots.inventorySlots.size(); ++i1) {
            Slot slot1 = this.inventorySlots.inventorySlots.get(i1);
            this.drawSlotInventory(slot1);
            if (!this.getIsMouseOverSlot(slot1, x2, y2)) continue;
            slot = slot1;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int j1 = slot1.xDisplayPosition;
            int l1 = slot1.yDisplayPosition;
            this.drawGradientRect(j1, l1, j1 + 16, l1 + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        if (inventoryplayer.getHeldItemStack() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, inventoryplayer.getHeldItemStack(), x2 - centerX - 8, y2 - centerY - 8, 1.0f);
            itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, inventoryplayer.getHeldItemStack(), x2 - centerX - 8, y2 - centerY - 8, 1.0f);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.drawScreen(x2, y2, renderPartialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (inventoryplayer.getHeldItemStack() == null && slot != null && slot.hasStack()) {
            StringTranslate trans = StringTranslate.getInstance();
            StringBuilder text = new StringBuilder();
            boolean multiLine = false;
            boolean control = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            boolean showDescription = control;
            if (slot.discovered) {
                boolean isCrafting = slot instanceof SlotCrafting;
                if (isCrafting) {
                    showDescription = false;
                    if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                        boolean a2 = shift;
                        shift = control;
                        control = a2;
                    }
                }
                String itemName = trans.translateKey(slot.getStack().getItemName() + ".name");
                String itemNick = slot.getStack().getItem().getItemNickname(slot.getStack());
                if (itemNick != null && itemNick.length() > 0 && slot.getStack().tag.getBoolean("overrideName")) {
                    itemName = itemNick;
                }
                if (slot.getStack().tag.getBoolean("overrideColor")) {
                    text.append(ChatColor.get(slot.getStack().getItem().getItemNameColor(slot.getStack())));
                }
                text.append(itemName);
                boolean debug = (Boolean)this.mc.gameSettings.showDebugScreen.value;
                if (debug) {
                    text.append(" #" + slot.getStack().itemID + ":" + slot.getStack().getMetadata());
                }
                if (debug) {
                    multiLine = true;
                    text.append('\n').append(ChatColor.lightGray + slot.getStack().getItemName());
                }
                if (slot.getStack().isItemStackDamageable() && !showDescription && slot.discovered && ((Boolean)this.mc.gameSettings.showItemDurability.value).booleanValue()) {
                    multiLine = true;
                    int durability = slot.getStack().getMaxDamage();
                    int remainingUses = durability - slot.getStack().getMetadata();
                    text.append('\n').append(ChatColor.lightGray + "" + remainingUses + " / " + durability);
                }
                if (showDescription) {
                    multiLine = true;
                    text.append('\n').append(GuiContainer.formatDescription(trans.translateKey(slot.getStack().getItemName() + ".desc"), 16));
                }
                if (isCrafting) {
                    if (shift && !control) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft Stack");
                    }
                    if (control && !shift) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft Once");
                    }
                    if (control && shift) {
                        text.append('\n').append(ChatColor.lightGray).append("Craft All");
                    }
                }
            } else {
                text.append("???");
                if (showDescription) {
                    multiLine = true;
                    text.append("\n").append(trans.translateKey("item.unknown.desc"));
                }
            }
            String str = text.toString();
            if (str.length() > 0) {
                this.drawTooltip(str, x2, y2, 8, -8, multiLine);
            }
        }
        GL11.glEnable((int)2929);
    }

    public static String formatDescription(String description, int preferredLineLength) {
        StringBuilder string = new StringBuilder();
        string.append(ChatColor.lightGray);
        int lineLength = 0;
        for (int i2 = 0; i2 < description.length(); ++i2) {
            char c2 = description.charAt(i2);
            if (c2 == ' ') {
                if (lineLength > preferredLineLength) {
                    lineLength = 0;
                    string.append("\n").append(ChatColor.lightGray);
                    continue;
                }
                string.append(c2);
                continue;
            }
            ++lineLength;
            string.append(c2);
        }
        return string.toString();
    }

    public void drawTooltip(String string, int x2, int y2, int offsetX, int offsetY, boolean multiLine) {
        String[] lines = string.split("\n");
        if (lines.length == 0) {
            return;
        }
        int lineSpacing = 3;
        int padding = 3;
        int width = 0;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            width = Math.max(width, this.fontRenderer.getStringWidth(lines[i2]));
        }
        int height = lines.length * 8 + (lines.length - 1) * lineSpacing;
        if (x2 + offsetX + width + padding * 2 > this.mc.resolution.scaledWidth) {
            offsetX = -offsetX - width;
        }
        offsetY -= Math.max(0, y2 + height + offsetY + padding * 2 - this.mc.resolution.scaledHeight);
        this.drawGradientRect(x2 += offsetX, y2 += offsetY, x2 + width + padding * 2, y2 + height + padding * 2, -1073741824, -1073741824);
        for (int i3 = 0; i3 < lines.length; ++i3) {
            this.fontRenderer.drawStringWithShadow(lines[i3], x2 + padding, y2 + padding + i3 * (8 + lineSpacing), 0xFFFFFF);
        }
    }

    private void drawSlotInventory(Slot slot) {
        int k2;
        int i2 = slot.xDisplayPosition;
        int j2 = slot.yDisplayPosition;
        ItemStack itemstack = slot.getStack();
        if (itemstack == null && (k2 = slot.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable((int)2896);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/gui/items.png"));
            this.drawTexturedModalRect(i2, j2, k2 % Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems, k2 / Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems, 16, 16, TextureFX.tileWidthItems, 1.0f / (float)(Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthItems));
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderItemIntoGUI(this.fontRenderer, this.mc.renderEngine, itemstack, i2, j2, slot.discovered ? 1.0f : 0.0f, 1.0f);
        itemRenderer.renderItemOverlayIntoGUI(this.fontRenderer, this.mc.renderEngine, itemstack, i2, j2, slot.discovered);
    }

    private boolean getIsMouseOverSlot(Slot slot, int i2, int j2) {
        int k2 = (this.width - this.xSize) / 2;
        int l2 = (this.height - this.ySize) / 2;
        return (i2 -= k2) >= slot.xDisplayPosition - 1 && i2 < slot.xDisplayPosition + 16 + 1 && (j2 -= l2) >= slot.yDisplayPosition - 1 && j2 < slot.yDisplayPosition + 16 + 1;
    }

    private Slot getSlotAtPosition(int i2, int j2) {
        for (int k2 = 0; k2 < this.inventorySlots.inventorySlots.size(); ++k2) {
            Slot slot = this.inventorySlots.inventorySlots.get(k2);
            if (!this.getIsMouseOverSlot(slot, i2, j2)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void keyTyped(char c2, int i2) {
        if (i2 == 1 || this.mc.gameSettings.keyInventory.isKey(i2) || i2 == 14) {
            this.mc.thePlayer.closeScreen();
        }
    }

    @Override
    public void mouseClicked(int x2, int y2, int button) {
        super.mouseClicked(x2, y2, button);
        if (button == 0 || button == 1 || button == 10) {
            Slot slot = this.getSlotAtPosition(x2, y2);
            int l2 = (this.width - this.xSize) / 2;
            int i1 = (this.height - this.ySize) / 2;
            boolean flag = x2 < l2 || y2 < i1 || x2 >= l2 + this.xSize || y2 >= i1 + this.ySize;
            int j1 = -1;
            if (slot != null) {
                j1 = slot.id;
            }
            if (flag) {
                j1 = -999;
            }
            if (j1 != -1) {
                boolean control;
                boolean shift = j1 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || button == 10);
                boolean bl2 = control = j1 != -999 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157));
                if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                    boolean a2 = shift;
                    shift = control;
                    control = a2;
                }
                this.mc.playerController.itemPickUpFromInventory(this.inventorySlots.windowId, j1, button == 10 ? 0 : button, shift, control, this.mc.thePlayer);
            }
        }
    }

    @Override
    public void mouseMovedOrUp(int i2, int j2, int k2) {
        if (k2 != 0) {
            // empty if block
        }
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isEntityAlive() || this.mc.thePlayer.isDead) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

