/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiControllerSetup;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSettingsBase;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.input.InputHandler;
import net.minecraft.src.input.controller.ControllerInput;

public class GuiController
extends GuiSettingsBase {
    public GuiController(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
        this.setOptions(this.gameSettings.controllerSensitivity, this.gameSettings.controllerMenuSensitivity, this.gameSettings.controllerDeadzoneLeft, this.gameSettings.controllerDeadzoneRight, this.gameSettings.controllerSwapShoulderButtons, this.gameSettings.controllerSwapAB, this.gameSettings.controllerSwapXY);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.controlList.add(new GuiButton(100, this.width / 2 - 100, 180, StringTranslate.getInstance().translateKey("options.selectController")));
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        super.actionPerformed(button);
        if (button.id == 100) {
            this.mc.displayGuiScreen(new GuiControllerSetup(this));
            this.mc.gameSettings.saveOptions();
            for (ControllerInput controller : InputHandler.controllers) {
                controller.setup();
                controller.cancelButtonPresses();
            }
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.mc.gameSettings.saveOptions();
        for (ControllerInput controller : InputHandler.controllers) {
            controller.setup();
            controller.cancelButtonPresses();
        }
    }
}

