/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.java.games.input.Component;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.input.InputHandler;
import net.minecraft.src.input.InputType;
import net.minecraft.src.input.controller.ControllerInput;
import net.minecraft.src.input.controller.Joystick;
import org.lwjgl.opengl.GL11;

public class GuiControllerSetup
extends GuiScreen {
    private int selectedController = 0;
    private GuiButton controllerButton;

    public GuiControllerSetup(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initGui() {
        this.addButtons();
    }

    public void addButtons() {
        this.controllerButton = new GuiButton(0, 0, 0, "");
        this.controllerButton.xPosition = this.width / 2 - 100;
        this.controllerButton.yPosition = 16;
        this.controllerButton.width = 200;
        this.controllerButton.height = 20;
        this.controlList.add(this.controllerButton);
        this.controlList.add(new GuiButton(-1, this.width / 2 - 100, this.height - 40, "Back").setListener(e2 -> this.mc.displayGuiScreen(this.parentScreen)));
        this.updateController();
    }

    @Override
    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(x2, y2, renderPartialTicks);
        ControllerInput controller = this.selectedController >= 0 && InputHandler.controllers.size() > 0 ? InputHandler.controllers.get(this.selectedController) : null;
        if (controller != null) {
            int i2 = 0;
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            for (Component comp : controller.getController().getComponents()) {
                float data = comp.getPollData();
                int dataD = (int)(data * 256.0f);
                if (comp.isAnalog()) {
                    data = data * 0.5f + 0.5f;
                }
                int x1 = 8;
                int y1 = 16 + i2 * 10;
                int w2 = 32;
                GL11.glDisable((int)3553);
                GL11.glBegin((int)7);
                GL11.glColor3d((double)0.2, (double)0.2, (double)0.2);
                this.rectangle(x1, y1, w2, 10.0);
                GL11.glEnd();
                GL11.glBegin((int)7);
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                this.rectangle((float)x1 + data * (float)w2 - 1.0f, y1, 2.0, 10.0);
                GL11.glEnd();
                GL11.glEnable((int)3553);
                if (comp.isAnalog()) {
                    this.fontRenderer.drawStringWithShadow(comp.getIdentifier() + ": " + data, 48, 16 + i2++ * 10, 0xFFFFFF);
                    continue;
                }
                this.fontRenderer.drawStringWithShadow(comp.getIdentifier() + ": " + dataD, 48, 16 + i2++ * 10, 0xFFFFFF);
            }
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3553);
            this.drawJoystick(controller.joyLeft, this.width / 2 - 48, 64);
            this.drawJoystick(controller.joyRight, this.width / 2 - 48 + 64, 64);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3553);
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            int x1 = this.width / 2 - 200;
            GL11.glEnable((int)3553);
            this.fontRenderer.drawStringWithShadow("ZL", x1 + 168, 132, controller.buttonZL.isPressed() ? 0xFFFFFF : 0x505050);
            this.fontRenderer.drawStringWithShadow("ZR", x1 + 188, 132, controller.buttonZR.isPressed() ? 0xFFFFFF : 0x505050);
            this.fontRenderer.drawStringWithShadow("-", x1 + 208, 132, controller.buttonMinus.isPressed() ? 0xFFFFFF : 0x505050);
            this.fontRenderer.drawStringWithShadow("+", x1 + 218, 132, controller.buttonPlus.isPressed() ? 0xFFFFFF : 0x505050);
            this.fontRenderer.drawStringWithShadow("L", x1 + 228, 132, controller.buttonL.isPressed() ? 0xFFFFFF : 0x505050);
            this.fontRenderer.drawStringWithShadow("R", x1 + 238, 132, controller.buttonR.isPressed() ? 0xFFFFFF : 0x505050);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/controller/xbox360.png"));
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            GL11.glBegin((int)7);
            int x22 = this.width / 2 + 50;
            int y22 = this.height / 2;
            int w2 = 20;
            this.rectangle(x22 + w2 * 1, y22 + w2 * 2, w2, w2, 0, controller.buttonA.isPressed() ? 20 : 0, 20, 20);
            this.rectangle(x22 + w2 * 2, y22 + w2 * 1, w2, w2, 20, controller.buttonB.isPressed() ? 20 : 0, 20, 20);
            this.rectangle(x22 + w2 * 0, y22 + w2 * 1, w2, w2, 40, controller.buttonX.isPressed() ? 20 : 0, 20, 20);
            this.rectangle(x22 + w2 * 1, y22 + w2 * 0, w2, w2, 60, controller.buttonY.isPressed() ? 20 : 0, 20, 20);
            x22 = this.width / 2 - 100;
            y22 = this.height / 2 + 4;
            this.rectangle(x22, y22, 48.0, 48.0, 0, 64, 48, 48);
            if (controller.digitalPad.up.isPressed()) {
                this.rectangle(x22 + 18, y22 + 0, 12.0, 18.0, 66, 64, 12, 18);
            }
            if (controller.digitalPad.down.isPressed()) {
                this.rectangle(x22 + 18, y22 + 30, 12.0, 18.0, 66, 94, 12, 18);
            }
            if (controller.digitalPad.left.isPressed()) {
                this.rectangle(x22 + 0, y22 + 18, 18.0, 12.0, 48, 82, 18, 12);
            }
            if (controller.digitalPad.right.isPressed()) {
                this.rectangle(x22 + 30, y22 + 18, 18.0, 12.0, 78, 82, 18, 12);
            }
            GL11.glEnd();
        }
    }

    @Override
    public void keyTyped(char c2, int i2) {
    }

    public void drawJoystick(Joystick joystick, int x2, int y2) {
        GL11.glBegin((int)7);
        GL11.glColor3d((double)0.5, (double)0.5, (double)0.5);
        this.rectangle(x2, y2, 32.0, 32.0);
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        if (joystick.getButton().isPressed()) {
            GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        }
        this.rectangle((double)x2 + ((double)joystick.getX() * 0.5 + 0.5) * 32.0 - 1.0, (double)y2 + ((double)joystick.getY() * 0.5 + 0.5) * 32.0 - 1.0, 2.0, 2.0);
        GL11.glEnd();
    }

    public void rectangle(double x2, double y2, double w2, double h2) {
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)(x2 + w2), (double)y2);
        GL11.glVertex2d((double)(x2 + w2), (double)(y2 + h2));
        GL11.glVertex2d((double)x2, (double)(y2 + h2));
    }

    public void rectangle(double x2, double y2, double w2, double h2, int u0, int v0, int uw2, int vh2) {
        double u1 = u0 + uw2;
        double v1 = v0 + vh2;
        GL11.glTexCoord2d((double)((double)u0 / 256.0), (double)((double)v0 / 256.0));
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glTexCoord2d((double)(u1 / 256.0), (double)((double)v0 / 256.0));
        GL11.glVertex2d((double)(x2 + w2), (double)y2);
        GL11.glTexCoord2d((double)(u1 / 256.0), (double)(v1 / 256.0));
        GL11.glVertex2d((double)(x2 + w2), (double)(y2 + h2));
        GL11.glTexCoord2d((double)((double)u0 / 256.0), (double)(v1 / 256.0));
        GL11.glVertex2d((double)x2, (double)(y2 + h2));
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        if (guibutton.id == 0) {
            ++this.selectedController;
            if (this.selectedController >= InputHandler.controllers.size()) {
                this.selectedController = -1;
            }
            this.controlList.clear();
            this.addButtons();
        }
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.inputType == InputType.CONTROLLER) {
            this.mc.mouseInput.grabCursor();
        }
    }

    public void updateController() {
        ControllerInput controllerInput;
        if (this.selectedController >= 0 && InputHandler.controllers.size() > 0) {
            this.mc.setInputType(InputType.CONTROLLER);
            controllerInput = InputHandler.controllers.get(this.selectedController);
            this.controllerButton.displayString = controllerInput.getController().toString();
        } else {
            this.mc.setInputType(InputType.KEYBOARD);
            controllerInput = null;
            this.controllerButton.displayString = "No Controller Selected!";
        }
        this.mc.controllerInput = controllerInput;
        this.mc.gameSettings.selectedController.value = this.mc.controllerInput != null ? this.mc.controllerInput.getController().toString() : "";
        this.mc.gameSettings.saveOptions();
    }
}

