/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiController;
import net.minecraft.src.GuiKeybinds;
import net.minecraft.src.GuiOptionsButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSettingsBase;
import net.minecraft.src.GuiSlider;
import net.minecraft.src.StringTranslate;

public class GuiControls
extends GuiSettingsBase {
    public GuiControls(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
        this.setOptions(this.gameSettings.placementMode, this.gameSettings.autoHit, this.gameSettings.rawMouseInput, this.gameSettings.swapCraftingButtons);
        this.languageKey = "controls.title";
    }

    @Override
    public void initGui() {
        super.initGui();
        for (GuiButton button : this.controlList) {
            if (!(button instanceof GuiOptionsButton) && !(button instanceof GuiSlider)) continue;
            button.yPosition += 24;
        }
        StringTranslate t2 = StringTranslate.getInstance();
        this.controlList.add(new GuiOptionsButton(100, 0, 0, t2.translateKey("options.keybinds")));
        this.controlList.add(new GuiOptionsButton(101, 0, 0, t2.translateKey("options.controller")));
        this.autoAlignButtons();
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        super.actionPerformed(button);
        if (button.id == 100) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiKeybinds(this, this.gameSettings));
        }
        if (button.id == 101) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiController(this, this.gameSettings));
        }
    }
}

