/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.ContainerGuidebook;
import net.minecraft.src.ContainerGuidebookRecipeBase;
import net.minecraft.src.ContainerGuidebookRecipeCrafting;
import net.minecraft.src.ContainerGuidebookRecipeFurnace;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.IRecipe;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeShaped;
import net.minecraft.src.RecipeShapeless;
import net.minecraft.src.RecipesBlastFurnace;
import net.minecraft.src.RecipesFurnace;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGuidebook
extends GuiContainer {
    protected static int page;
    protected static int maxPage;
    private static int totalRecipes;
    private static Object[] storedRecipes;
    protected int xSize = 316;
    protected int ySize = 220;
    protected GuiButton lastPageButton;
    protected GuiButton nextPageButton;
    protected String pageString = "1/1";
    protected ContainerGuidebookRecipeBase[] recipes;

    public GuiGuidebook() {
        super(new ContainerGuidebook());
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton == this.lastPageButton) {
            this.scroll(1);
        }
        if (guibutton == this.nextPageButton) {
            this.scroll(-1);
        }
    }

    public void scroll(int direction) {
        int count = 1;
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            count = 10;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                count = 100;
            }
        }
        while (this.lastPageButton.enabled && direction > 0 && count > 0) {
            this.lastPage();
            this.updatePageSwitcher();
            --count;
        }
        while (this.nextPageButton.enabled && direction < 0 && count > 0) {
            this.nextPage();
            this.updatePageSwitcher();
            --count;
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f2) {
        this.scroll(Mouse.getDWheel());
        int i2 = this.mc.renderEngine.getTexture("/gui/guidebook.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i2);
        int j2 = (this.width - this.xSize) / 2;
        int k2 = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j2, k2, 0, 0, this.xSize / 2, this.ySize);
        this.drawTexturedModalRect(j2 + this.xSize / 2, k2, 0, 0, this.xSize / 2, this.ySize);
        for (int q2 = 0; q2 < 6; ++q2) {
            ContainerGuidebookRecipeBase r2;
            int xPos = j2 + 29 + 158 * (q2 / 3);
            int yPos = k2 + 30 + 62 * (q2 % 3);
            int yOffset = 0;
            if (this.recipes[q2] instanceof ContainerGuidebookRecipeCrafting) {
                r2 = (ContainerGuidebookRecipeCrafting)this.recipes[q2];
                yOffset = r2.inventorySlots.size() > 5 ? 54 : 0;
            } else {
                if (!(this.recipes[q2] instanceof ContainerGuidebookRecipeFurnace)) continue;
                r2 = (ContainerGuidebookRecipeFurnace)this.recipes[q2];
                if (((ContainerGuidebookRecipeFurnace)r2).furnaceType == 0) {
                    yOffset = 108;
                } else if (((ContainerGuidebookRecipeFurnace)r2).furnaceType == 1) {
                    yOffset = 162;
                }
            }
            this.drawTexturedModalRect(xPos, yPos, 158, yOffset, 98, 54);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.drawStringNoShadow(this.fontRenderer, "Guidebook", -58, -15, 0x404040);
        this.drawStringNoShadow(this.fontRenderer, this.pageString, 304 - this.fontRenderer.getStringWidth(this.pageString) - 70, -15, 0x404040);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.lastPageButton = new GuiButton(0, (this.width - this.xSize) / 2 + 132, (this.height - this.ySize) / 2 + 6, 20, 20, "<");
        this.controlList.add(this.lastPageButton);
        this.nextPageButton = new GuiButton(1, (this.width - this.xSize) / 2 + 164, (this.height - this.ySize) / 2 + 6, 20, 20, ">");
        this.controlList.add(this.nextPageButton);
        this.updatePages();
    }

    @Override
    public void keyTyped(char c2, int i2) {
        if (i2 == 1 || this.mc.gameSettings.keyGuidebook.isKey(i2)) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void lastPage() {
        --page;
        this.updatePages();
    }

    public void nextPage() {
        ++page;
        this.updatePages();
    }

    protected void updatePages() {
        this.updateRecipesByPage(page);
        this.updatePageSwitcher();
    }

    protected void updatePageSwitcher() {
        this.lastPageButton.enabled = page != 0;
        this.nextPageButton.enabled = page != maxPage;
        this.pageString = "" + (page + 1) + "/" + (maxPage + 1);
    }

    public void updateRecipesByPage(int page) {
        int startIndex = page * 6;
        this.recipes = new ContainerGuidebookRecipeBase[6];
        for (int i2 = 0; i2 < 6 && startIndex + i2 < totalRecipes; ++i2) {
            if (storedRecipes[startIndex + i2] instanceof IRecipe) {
                this.recipes[i2] = new ContainerGuidebookRecipeCrafting((IRecipe)storedRecipes[startIndex + i2]);
                continue;
            }
            if (storedRecipes[startIndex + i2] instanceof ItemStack[]) {
                this.recipes[i2] = new ContainerGuidebookRecipeFurnace(((ItemStack[])storedRecipes[startIndex + i2])[0], ((ItemStack[])storedRecipes[startIndex + i2])[1], ((ItemStack[])storedRecipes[startIndex + i2])[2]);
                continue;
            }
            System.out.println("Unknown guidebook recipe!");
        }
        ((ContainerGuidebook)this.inventorySlots).setRecipes(this.mc.thePlayer, this.recipes, this.mc.statFileWriter);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isEntityAlive() || this.mc.thePlayer.isDead) {
            this.mc.thePlayer.closeScreen();
        }
    }

    static {
        int i2;
        page = 0;
        maxPage = 0;
        totalRecipes = 0;
        List recipes = CraftingManager.getInstance().getRecipeList();
        for (int i3 = 0; i3 < recipes.size(); ++i3) {
            if (!(recipes.get(i3) instanceof RecipeShaped) && !(recipes.get(i3) instanceof RecipeShapeless)) continue;
            ++totalRecipes;
        }
        totalRecipes += RecipesFurnace.smelting().getSmeltingList().size();
        maxPage = (totalRecipes += RecipesBlastFurnace.smelting().getSmeltingList().size()) / 6 - 1;
        int index = 0;
        storedRecipes = new Object[totalRecipes];
        for (int i4 = 0; i4 < recipes.size(); ++i4) {
            if (!(recipes.get(i4) instanceof RecipeShaped) && !(recipes.get(i4) instanceof RecipeShapeless)) continue;
            GuiGuidebook.storedRecipes[index++] = recipes.get(i4);
        }
        ArrayList keys = new ArrayList(RecipesFurnace.smelting().getSmeltingList().keySet());
        for (i2 = 0; i2 < keys.size(); ++i2) {
            GuiGuidebook.storedRecipes[index++] = new ItemStack[]{new ItemStack(Block.furnaceStoneActive), new ItemStack((Integer)keys.get(i2), 1, 0), (ItemStack)RecipesFurnace.smelting().getSmeltingList().get(keys.get(i2))};
        }
        keys = new ArrayList(RecipesBlastFurnace.smelting().getSmeltingList().keySet());
        for (i2 = 0; i2 < keys.size(); ++i2) {
            GuiGuidebook.storedRecipes[index++] = new ItemStack[]{new ItemStack(Block.furnaceBlastActive), new ItemStack((Integer)keys.get(i2), 1, 0), (ItemStack)RecipesBlastFurnace.smelting().getSmeltingList().get(keys.get(i2))};
        }
    }
}

