/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Gamemode;
import net.minecraft.src.Gui;
import net.minecraft.src.IRecipe;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeShaped;
import net.minecraft.src.RecipeShapeless;
import net.minecraft.src.RecipesBlastFurnace;
import net.minecraft.src.RecipesFurnace;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.StatList;
import org.lwjgl.opengl.GL11;

public class GuiGuidebookRecipe
extends Gui {
    private static RenderItem itemRenderer = new RenderItem();
    protected IRecipe recipe = null;
    protected int furnaceType;
    protected int recipeId;
    protected int xPosition;
    protected int yPosition;
    protected int width = 98;
    protected int height = 54;
    protected Minecraft mc;

    public GuiGuidebookRecipe(Minecraft mc2, int x2, int y2, int furnaceType, int recipeId) {
        this.xPosition = x2;
        this.yPosition = y2;
        this.furnaceType = furnaceType;
        this.recipeId = recipeId;
    }

    public GuiGuidebookRecipe(Minecraft mc2, int x2, int y2, IRecipe recipe) throws IllegalArgumentException {
        this.xPosition = x2;
        this.yPosition = y2;
        this.recipe = recipe;
        if (!(recipe instanceof RecipeShaped) && !(recipe instanceof RecipeShapeless)) {
            throw new IllegalArgumentException();
        }
    }

    public void draw(Minecraft minecraft) {
        GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/guidebook.png"));
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 158, this.getRecipeImageYCoord(), 98, 54);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        this.mc = minecraft;
        for (int i2 = 0; i2 < this.slotCount(); ++i2) {
            int[] coords = this.getSlotCoords(i2);
            this.drawItemInSlot(coords[0], coords[1], this.getStackInSlot(i2));
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    private void drawItemInSlot(int x2, int y2, ItemStack stack) {
        if (stack == null) {
            return;
        }
        boolean seen = this.mc.thePlayer.getGamemode() == Gamemode.creative || this.hasSeenItemWithId(stack.itemID);
        itemRenderer.drawItemIntoGui(this.mc.fontRenderer, this.mc.renderEngine, stack.itemID, stack.getMetadata(), stack.getIconIndex(), this.xPosition + x2, this.yPosition + y2, seen ? 1.0f : 0.0f, 1.0f);
        if (!seen) {
            String s2 = "?";
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.mc.fontRenderer.drawStringWithShadow("?", this.xPosition + (x2 + 19) - 2 - this.mc.fontRenderer.getStringWidth("?"), this.yPosition + y2 + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        } else {
            itemRenderer.renderItemOverlayIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, stack, this.xPosition + x2, this.yPosition + y2, 1.0f);
        }
    }

    public boolean getIsMouseOverSlot(int slot, int mouseX, int mouseY) {
        int[] coords = this.getSlotCoords(slot);
        return mouseX >= coords[0] - 1 && mouseX < coords[0] + 16 + 1 && mouseY >= coords[1] - 1 && mouseY < coords[1] + 16 + 1;
    }

    protected int getRecipeImageYCoord() {
        return this.getRecipeType() * 54;
    }

    protected int getRecipeType() {
        if (this.recipe != null) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r2 = (RecipeShaped)this.recipe;
                if (r2.recipeHeight > 2 || r2.recipeWidth > 2) {
                    return 1;
                }
                return 0;
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r3 = (RecipeShapeless)this.recipe;
                if (r3.recipeItems.size() > 4) {
                    return 1;
                }
                return 0;
            }
        } else {
            if (this.furnaceType == 0) {
                return 2;
            }
            if (this.furnaceType == 1) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int[] getSlotCoords(int slot) {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            if (slot < 4) {
                return new int[]{13 + 18 * (slot % 2), 10 + 18 * (slot / 2)};
            }
            return new int[]{69, 20};
        }
        if (recipeType == 1) {
            if (slot < 9) {
                return new int[]{1 + 18 * (slot % 3), 1 + 18 * (slot / 3)};
            }
            return new int[]{81, 19};
        }
        if (recipeType == 2 || recipeType == 3) {
            if (slot == 0) {
                return new int[]{9, 10};
            }
            return new int[]{69, 19};
        }
        return new int[]{0, 0};
    }

    public ItemStack getStackInSlot(int slot) {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r2 = (RecipeShaped)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r2.recipeOutput;
                }
                int slotX = slot % 2;
                int slotY = slot / 2;
                if (slotX >= r2.recipeWidth || slotY >= r2.recipeHeight) {
                    return null;
                }
                return r2.recipeItems[slotX + slotY * r2.recipeWidth];
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r3 = (RecipeShapeless)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r3.recipeOutput;
                }
                if (slot >= r3.recipeItems.size()) {
                    return null;
                }
                return (ItemStack)r3.recipeItems.get(slot);
            }
        } else if (recipeType == 1) {
            if (this.recipe instanceof RecipeShaped) {
                RecipeShaped r4 = (RecipeShaped)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r4.recipeOutput;
                }
                int slotX = slot % 3;
                int slotY = slot / 3;
                if (slotX >= r4.recipeWidth || slotY >= r4.recipeHeight) {
                    return null;
                }
                return r4.recipeItems[slotX + slotY * r4.recipeWidth];
            }
            if (this.recipe instanceof RecipeShapeless) {
                RecipeShapeless r5 = (RecipeShapeless)this.recipe;
                if (slot == this.slotCount() - 1) {
                    return r5.recipeOutput;
                }
                if (slot > r5.recipeItems.size()) {
                    return null;
                }
                return (ItemStack)r5.recipeItems.get(slot);
            }
        } else {
            if (recipeType == 2) {
                ItemStack input = new ItemStack(this.recipeId, 1, 0);
                ItemStack output = RecipesFurnace.smelting().getSmeltingResult(this.recipeId);
                if (slot == 0) {
                    return input;
                }
                return output;
            }
            if (recipeType == 3) {
                ItemStack input = new ItemStack(this.recipeId, 1, 0);
                ItemStack output = RecipesBlastFurnace.smelting().getSmeltingResult(this.recipeId);
                if (slot == 0) {
                    return input;
                }
                return output;
            }
        }
        return null;
    }

    public boolean hasSeenItemWithId(int id2) {
        if (id2 >= Block.blocksList.length) {
            return this.mc.statFileWriter.readStat(StatList.craftedItemStats[id2]) > 0 || this.mc.statFileWriter.readStat(StatList.pickUpItemStats[id2]) > 0;
        }
        return this.mc.statFileWriter.readStat(StatList.craftedItemStats[id2]) > 0 || this.mc.statFileWriter.readStat(StatList.mineBlockStatArray[id2]) > 0 || this.mc.statFileWriter.readStat(StatList.pickUpItemStats[id2]) > 0;
    }

    public int slotCount() {
        int recipeType = this.getRecipeType();
        if (recipeType == 0) {
            return 5;
        }
        if (recipeType == 1) {
            return 10;
        }
        if (recipeType == 2 || recipeType == 3) {
            return 2;
        }
        return 0;
    }
}

