/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ChatLine;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gamemode;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiChat;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerProfile;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Season;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Weather;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.Utils;
import org.lwjgl.opengl.GL11;

public class GuiIngame
extends Gui {
    public static final String[] directions = new String[]{"North", "East", "South", "West"};
    private static RenderItem itemRenderer = new RenderItem();
    private List<ChatLine> chatMessageList = new ArrayList<ChatLine>();
    private Random rand = new Random();
    private Minecraft mc;
    public String field_933_a;
    private int updateCounter = 0;
    private String recordPlaying = "";
    private int recordPlayingUpFor = 0;
    private boolean field_22065_l = false;
    public float damageGuiPartialTime;
    float prevVignetteBrightness = 1.0f;
    private FontRenderer fontrenderer;
    private int debugLine = 0;
    private int debugLineRight = 0;
    private int debugOffset = 0;
    private int debugOffsetRight = 0;
    private int debugLineHeight = 10;
    private List<String> playerListScoreStrings = new ArrayList<String>();

    public GuiIngame(Minecraft minecraft) {
        this.mc = minecraft;
        this.fontrenderer = this.mc.fontRenderer;
    }

    public void renderGameOverlay(float partialTicks, boolean flag, int mouseX, int mouseY) {
        ItemStack heldItemStack;
        int l2;
        int y2;
        float portalIntensity;
        if (this.mc.isometricMode) {
            return;
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        int sp2 = (int)(((Float)this.mc.gameSettings.screenPadding.value).floatValue() * (float)height / 8.0f);
        FontRenderer fontrenderer = this.mc.fontRenderer;
        this.mc.entityRenderer.setupScaledResolution();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.mc.gameSettings.immersiveMode.drawVignette() && ((Boolean)this.mc.gameSettings.vignette.value).booleanValue()) {
            this.renderVignette(this.mc.thePlayer.getEntityBrightness(partialTicks), width, height);
        }
        ItemStack headSlotItem = this.mc.thePlayer.inventory.armorItemInSlot(3);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && headSlotItem != null && headSlotItem.itemID == Block.pumpkinCarvedIdle.blockID) {
            this.renderPumpkinBlur(width, height);
        }
        if ((portalIntensity = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * partialTicks) > 0.0f) {
            this.renderPortalOverlay(portalIntensity, width, height);
        }
        if (this.mc.gameSettings.immersiveMode.drawHotbar()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/gui.png"));
            InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
            this.zLevel = -90.0f;
            int x2 = width / 2 - 91;
            y2 = height - 22 - sp2;
            this.drawTexturedModalRect(x2, y2, 0, 0, 182, 22);
            int selectedHotbar = (inventoryplayer.hotbarOffset + 27) % 36 / 9;
            this.drawTexturedModalRect(x2 - 5, y2, 24, 22, 6, 22);
            this.drawTexturedModalRect(x2 - 5, y2 + 1 + selectedHotbar * 5, 30, 23 + selectedHotbar * 5, 6, 5);
            this.drawTexturedModalRect(x2 - 1 + inventoryplayer.currentItem % 9 * 20, y2 - 1, 0, 22, 24, 22 + (sp2 > 0 ? 2 : 0));
        }
        if (this.mc.gameSettings.immersiveMode.drawCrosshair()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/icons.png"));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)775, (int)769);
            this.drawTexturedModalRect(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
            GL11.glDisable((int)3042);
            this.drawRotationOverlay(width, height, sp2);
        }
        if (this.mc.gameSettings.immersiveMode.drawHotbar()) {
            int y3;
            int itemIndex;
            boolean heartsFlash;
            boolean bl2 = heartsFlash = this.mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
            if (this.mc.thePlayer.heartsFlashTime < 10) {
                heartsFlash = false;
            }
            int health = this.mc.thePlayer.health;
            int prevHealth = this.mc.thePlayer.prevHealth;
            this.rand.setSeed((long)this.updateCounter * 312871L);
            if (this.mc.playerController.shouldDrawHUD()) {
                int y4;
                int armorValue = this.mc.thePlayer.getPlayerProtectionAmount();
                for (int index = 0; index < 10; ++index) {
                    y4 = height - 32 - sp2;
                    if (armorValue > 0) {
                        int x3 = width / 2 + 91 - index * 8 - 9;
                        if (index * 2 + 1 < armorValue) {
                            this.drawTexturedModalRect(x3, y4, 34, 9, 9, 9);
                        }
                        if (index * 2 + 1 == armorValue) {
                            this.drawTexturedModalRect(x3, y4, 25, 9, 9, 9);
                        }
                        if (index * 2 + 1 > armorValue) {
                            this.drawTexturedModalRect(x3, y4, 16, 9, 9, 9);
                        }
                    }
                    if (this.mc.thePlayer.getGamemode().isPlayerInvulnerable) continue;
                    int heartOffset = 0;
                    if (heartsFlash) {
                        heartOffset = 1;
                    }
                    int x4 = width / 2 - 91 + index * 8;
                    if (health <= 4) {
                        y4 += this.rand.nextInt(2);
                    }
                    this.drawTexturedModalRect(x4, y4, 16 + heartOffset * 9, 0, 9, 9);
                    if (heartsFlash) {
                        if (index * 2 + 1 < prevHealth) {
                            this.drawTexturedModalRect(x4, y4, 70, 0, 9, 9);
                        }
                        if (index * 2 + 1 == prevHealth) {
                            this.drawTexturedModalRect(x4, y4, 79, 0, 9, 9);
                        }
                    }
                    if (index * 2 + 1 < health) {
                        this.drawTexturedModalRect(x4, y4, 52, 0, 9, 9);
                    }
                    if (index * 2 + 1 == health) {
                        this.drawTexturedModalRect(x4, y4, 61, 0, 9, 9);
                    }
                    if (this.mc.thePlayer.inventory.getCurrentItem() == null || !(this.mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood) || !((Boolean)this.mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
                    int healing = ((ItemFood)this.mc.thePlayer.inventory.getCurrentItem().getItem()).healAmount;
                    if (index * 2 + 1 < health) continue;
                    if (index * 2 + 1 == health) {
                        this.drawTexturedModalRect(x4, y4, 106, 0, 9, 9);
                        continue;
                    }
                    if (index * 2 + 1 < health + healing) {
                        this.drawTexturedModalRect(x4, y4, 88, 0, 9, 9);
                        continue;
                    }
                    if (index * 2 + 1 != health + healing) continue;
                    this.drawTexturedModalRect(x4, y4, 97, 0, 9, 9);
                }
                if (this.mc.thePlayer.isInsideOfMaterial(Material.water) && !this.mc.thePlayer.getGamemode().isPlayerInvulnerable) {
                    int k2 = (int)Math.ceil((double)(this.mc.thePlayer.air - 2) * 10.0 / 300.0);
                    int l3 = (int)Math.ceil((double)this.mc.thePlayer.air * 10.0 / 300.0) - k2;
                    for (int l5 = 0; l5 < k2 + l3; ++l5) {
                        if (l5 < k2) {
                            this.drawTexturedModalRect(width / 2 - 91 + l5 * 8, height - 32 - 9 - sp2, 16, 18, 9, 9);
                            continue;
                        }
                        this.drawTexturedModalRect(width / 2 - 91 + l5 * 8, height - 32 - 9 - sp2, 25, 18, 9, 9);
                    }
                }
                if (this.mc.thePlayer.fire > 0) {
                    int x5 = width / 2 - 91;
                    y4 = height - 42 - sp2;
                    float fire = (float)this.mc.thePlayer.fire / (float)this.mc.thePlayer.maxFire;
                    int fireBar = (int)(fire * 20.0f);
                    for (int k2 = 0; k2 < fireBar / 2; ++k2) {
                        this.drawTexturedModalRect(x5 + 8 * k2, y4, 16, 27, 9, 9);
                    }
                    if (fireBar % 2 == 1) {
                        this.drawTexturedModalRect(x5 + 8 * (fireBar / 2), y4, 25, 27, 9, 9);
                    }
                }
            }
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderHelper.enableStandardItemLighting();
            GL11.glPopMatrix();
            int lastHotbarStart = (this.mc.thePlayer.inventory.hotbarOffset + 27) % 36;
            int nextHotbarStart = (this.mc.thePlayer.inventory.hotbarOffset + 9) % 36;
            if (this.mc.hotbarSwapAnimationProgress > 0.0f) {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((width / 2 - 90 + 2) * this.mc.resolution.scale), (int)((3 + sp2) * this.mc.resolution.scale), (int)(182 * this.mc.resolution.scale), (int)(16 * this.mc.resolution.scale));
                this.mc.hotbarSwapAnimationProgress -= partialTicks * this.mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    int x6 = width / 2 - 90 + itemIndex * 20 + 2;
                    y3 = height - 16 - 3 - 22 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(itemIndex + lastHotbarStart, x6, y3 - sp2, partialTicks, 1.0f);
                }
                if (this.mc.hotbarSwapAnimationProgress < 0.05f) {
                    this.mc.hotbarSwapAnimationProgress = 0.0f;
                }
            } else if (this.mc.hotbarSwapAnimationProgress < 0.0f) {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((width / 2 - 90 + 2) * this.mc.resolution.scale), (int)((3 + sp2) * this.mc.resolution.scale), (int)(182 * this.mc.resolution.scale), (int)(16 * this.mc.resolution.scale));
                this.mc.hotbarSwapAnimationProgress += partialTicks * -this.mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    int x7 = width / 2 - 90 + itemIndex * 20 + 2;
                    y3 = height - 16 - 3 + 22 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(itemIndex + nextHotbarStart, x7, y3 - sp2, partialTicks, 1.0f);
                }
                if (this.mc.hotbarSwapAnimationProgress > -0.05f) {
                    this.mc.hotbarSwapAnimationProgress = 0.0f;
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                int x8 = width / 2 - 90 + itemIndex * 20 + 2;
                y3 = height - 16 - 3 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                this.renderInventorySlot(itemIndex + this.mc.thePlayer.inventory.hotbarOffset, x8, y3 - sp2, partialTicks, 1.0f);
            }
            GL11.glDisable((int)3089);
        }
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
        if (this.mc.thePlayer.func_22060_M() > 0) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            int i2 = this.mc.thePlayer.func_22060_M();
            float f3 = (float)i2 / 100.0f;
            if (f3 > 1.0f) {
                f3 = 1.0f - (float)(i2 - 100) / 10.0f;
            }
            int j4 = (int)(220.0f * f3) << 24 | 0x101020;
            this.drawRect(0, 0, width, height, j4);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays()) {
            this.drawRecordPlayingOverlay(width, height, partialTicks);
            int tsp = 2 + sp2;
            int line = 0;
            int lineHeight = 10;
            boolean clock = false;
            boolean compass = false;
            boolean rotaryCalendar = false;
            if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
                clock = true;
                compass = true;
                rotaryCalendar = true;
            } else {
                for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getSizeInventory(); ++iinv) {
                    ItemStack item = this.mc.thePlayer.inventory.getStackInSlot(iinv);
                    if (item == null) continue;
                    if (item.itemID == Item.toolClock.itemID) {
                        clock = true;
                    }
                    if (item.itemID == Item.toolCompass.itemID) {
                        compass = true;
                    }
                    if (item.itemID != Item.toolCalendar.itemID) continue;
                    rotaryCalendar = true;
                }
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                this.drawPlayerList(width, height, sp2);
            }
            if (((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                this.debugLine = 0;
                this.debugLineRight = 0;
                this.debugOffset = 0;
                this.debugOffsetRight = 0;
                long memMax = Runtime.getRuntime().maxMemory();
                long memTotal = Runtime.getRuntime().totalMemory();
                long memFree = Runtime.getRuntime().freeMemory();
                long memUsed = memTotal - memFree;
                int space = 6;
                this.drawDebugScreenLineRight("Used memory: " + memUsed * 100L / memMax + "% (" + memUsed / 1024L / 1024L + "MB) of " + memMax / 1024L / 1024L + "MB");
                this.drawDebugScreenLineRight("Allocated memory: " + memTotal * 100L / memMax + "% (" + memTotal / 1024L / 1024L + "MB)");
                this.drawDebugScreenLineRight("JRE: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
                this.debugOffsetRight += space;
                this.drawDebugScreenLineRight(GL11.glGetString((int)7936));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7937));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7938));
                this.drawDebugScreenLine("Better than Adventure! 1.7.6.2_01");
                this.drawDebugScreenLine(this.mc.debug);
                this.drawDebugScreenLine(this.mc.func_6241_m());
                this.drawDebugScreenLine(this.mc.func_6262_n());
                this.drawDebugScreenLine(this.mc.func_6245_o());
                this.drawDebugScreenLine(this.mc.func_21002_o());
                this.debugOffset += space;
                this.debugOffsetRight += space;
                if (compass) {
                    this.drawDebugScreenLine("X: " + this.mc.thePlayer.posX);
                    this.drawDebugScreenLine("Y: " + this.mc.thePlayer.posY);
                    this.drawDebugScreenLine("Z: " + this.mc.thePlayer.posZ);
                    int yaw = DynamicTexture.pmod(Math.round(this.mc.thePlayer.rotationYaw), 360);
                    int pitch = Math.round(this.mc.thePlayer.rotationPitch);
                    this.drawDebugScreenLine("Facing: " + yaw + "\ufffd, " + pitch + "\ufffd (" + GuiIngame.getFacingDirection(this.mc.thePlayer) + ")");
                } else {
                    this.drawDebugScreenLine("Hold a compass for more information");
                }
                if (clock) {
                    if (!compass) {
                        this.debugOffset += space;
                    }
                    int playerX = MathHelper.floor_double(this.mc.thePlayer.posX);
                    int playerY = MathHelper.floor_double(this.mc.thePlayer.posY);
                    int playerZ = MathHelper.floor_double(this.mc.thePlayer.posZ);
                    this.drawDebugScreenLine("Light: Sky: " + this.mc.theWorld.getSavedLightValue(EnumLightType.Sky, playerX, playerY, playerZ) + " Block: " + this.mc.theWorld.getSavedLightValue(EnumLightType.Block, playerX, playerY, playerZ));
                }
                this.debugOffset += space;
                if (clock) {
                    this.drawDebugScreenLine("Time: " + this.getTimeString() + " (Day " + this.mc.theWorld.getWorldTime() / (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS + ")");
                } else {
                    this.drawDebugScreenLine("Hold a clock for more information");
                }
                this.debugOffset += space;
                if (rotaryCalendar) {
                    Season season = this.mc.theWorld.getCurrentSeason();
                    String seasonString = season != null ? season.getName() : "None";
                    Weather weather = this.mc.theWorld.getCurrentWeather();
                    String weatherString = weather != null ? weather.getTranslatedName() : "None";
                    this.drawDebugScreenLine("Season: " + seasonString);
                    this.drawDebugScreenLine("Weather: " + weatherString + " (" + this.mc.theWorld.weatherDuration / 20L + "s I: " + Utils.percentRound(this.mc.theWorld.weatherIntensity) + "% P: " + Utils.percentRound(this.mc.theWorld.weatherPower) + "%)");
                    this.drawDebugScreenLine("Biome: " + this.mc.theWorld.getWorldChunkManager().getBiomeGenAt((int)((int)this.mc.thePlayer.posX), (int)((int)this.mc.thePlayer.posZ)).biomeName);
                } else {
                    this.drawDebugScreenLine("Hold a rotary calendar for more information");
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Seed: " + this.mc.theWorld.getRandomSeed());
                this.debugOffset += space;
                this.drawDebugScreenLine("CTRL + F3: Show Frametimes");
                this.drawDebugScreenLine("F3 + Q: Show Keyboard Shortcuts");
                if (this.mc.objectMouseOver != null && this.mc.objectMouseOver.entityHit == null) {
                    this.debugOffset += space;
                    Block block = Block.blocksList[this.mc.theWorld.getBlockId(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ)];
                    if (block.blockID > 0 && block.blockID < Block.blocksList.length) {
                        String name;
                        this.drawDebugScreenLineRight("Looking at:");
                        int meta = this.mc.theWorld.getBlockMetadata(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ);
                        try {
                            name = stringtranslate.translateKey(Item.itemsList[block.blockID].getItemNameIS(new ItemStack(block, 1, meta)) + ".name");
                        }
                        catch (Exception e2) {
                            name = "<ERROR>";
                        }
                        String id2 = block.getBlockName(meta) + " [" + block.blockID + ":" + meta + "]";
                        this.drawDebugScreenLineRight(name);
                        this.drawDebugScreenLineRight(id2);
                        if (compass) {
                            this.drawDebugScreenLineRight("[" + this.mc.objectMouseOver.blockX + ", " + this.mc.objectMouseOver.blockY + ", " + this.mc.objectMouseOver.blockZ + "]");
                        }
                        this.drawDebugScreenLineRight("Harvest: " + this.mc.thePlayer.canHarvestBlock(block));
                        if (clock) {
                            int lightX = this.mc.objectMouseOver.blockX;
                            int lightY = this.mc.objectMouseOver.blockY;
                            int lightZ = this.mc.objectMouseOver.blockZ;
                            Direction side = Direction.getDirectionForLegacySide(this.mc.objectMouseOver.sideHit);
                            if (side == Direction.UP) {
                                --lightY;
                            }
                            if (side == Direction.DOWN) {
                                ++lightY;
                            }
                            if (side == Direction.NORTH) {
                                --lightZ;
                            }
                            if (side == Direction.SOUTH) {
                                ++lightZ;
                            }
                            if (side == Direction.EAST) {
                                ++lightX;
                            }
                            if (side == Direction.WEST) {
                                --lightX;
                            }
                            this.drawDebugScreenLineRight("Light: Sky: " + this.mc.theWorld.getSavedLightValue(EnumLightType.Sky, lightX, lightY, lightZ) + " Block: " + this.mc.theWorld.getSavedLightValue(EnumLightType.Block, lightX, lightY, lightZ));
                        }
                    }
                }
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                if (((Boolean)this.mc.gameSettings.fpsInOverlay.value).booleanValue()) {
                    this.drawString(fontrenderer, this.mc.debugFPS, tsp, tsp + lineHeight * line++, 0xFFFFFF);
                }
                if (compass) {
                    if (((Boolean)this.mc.gameSettings.overlayShowCoords.value).booleanValue()) {
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.posX) + " y: " + Utils.floor10(this.mc.thePlayer.posY) + " z: " + Utils.floor10(this.mc.thePlayer.posZ), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 1) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.posX), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawString(fontrenderer, "y: " + Utils.floor10(this.mc.thePlayer.posY), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawString(fontrenderer, "z: " + Utils.floor10(this.mc.thePlayer.posZ), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 2) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.posX), tsp, tsp + lineHeight * line++, 0xFF8080);
                            this.drawString(fontrenderer, "y: " + Utils.floor10(this.mc.thePlayer.posY), tsp, tsp + lineHeight * line++, 0x80FF80);
                            this.drawString(fontrenderer, "z: " + Utils.floor10(this.mc.thePlayer.posZ), tsp, tsp + lineHeight * line++, 0x8080FF);
                        }
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowDirection.value).booleanValue()) {
                        this.drawString(fontrenderer, GuiIngame.getFacingDirection(this.mc.thePlayer), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                    }
                }
                if (clock && ((Boolean)this.mc.gameSettings.overlayShowTime.value).booleanValue()) {
                    if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                        this.drawString(fontrenderer, this.getTimeString() + " Day " + this.mc.theWorld.getWorldTime() / (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS, tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                    if ((Integer)this.mc.gameSettings.overlayMode.value > 0) {
                        this.drawString(fontrenderer, this.getTimeString(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                        this.drawString(fontrenderer, "Day " + this.mc.theWorld.getWorldTime() / (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS, tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                }
                if (rotaryCalendar) {
                    Weather weather;
                    Season season;
                    if (((Boolean)this.mc.gameSettings.overlayShowSeason.value).booleanValue() && (season = this.mc.theWorld.getCurrentSeason()) != null) {
                        this.drawString(fontrenderer, season.getName(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0x80FFFF : 0xFFFFFF);
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowWeather.value).booleanValue() && (weather = this.mc.theWorld.getCurrentWeather()) != null && weather != this.mc.theWorld.dimension.worldType.defaultWeather) {
                        this.drawString(fontrenderer, weather.getTranslatedName(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFF80FF : 0xFFFFFF);
                    }
                }
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.armorDurabilityOverlay.value).booleanValue()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                ItemStack stack = this.mc.thePlayer.inventory.armorInventory[3 - i2];
                if (stack == null) continue;
                int x9 = 2 + sp2;
                int y5 = height - sp2 - 64 + i2 * 16;
                itemRenderer.renderItemIntoGUI(fontrenderer, this.mc.renderEngine, stack, x9, y5, 1.0f);
                if (!stack.isItemStackDamageable()) continue;
                float durability = (float)(stack.getMaxDamage() - stack.getMetadata()) / (float)stack.getMaxDamage();
                l2 = (int)(durability * 255.0f);
                int i1 = 255 - l2 << 16 | l2 << 8;
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2896);
                fontrenderer.drawStringWithShadow("" + (stack.getMaxDamage() - stack.getMetadata() + 1), x9 + 20, y5 + 4, i1);
            }
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.heldItemCountOverlay.value).booleanValue() && (heldItemStack = this.mc.thePlayer.inventory.getCurrentItem()) != null) {
            int x10 = width / 2 + 96;
            y2 = height - sp2 - 19;
            boolean renderItem = false;
            if (heldItemStack.isItemStackDamageable()) {
                renderItem = true;
                float durability = (float)(heldItemStack.getMaxDamage() - heldItemStack.getMetadata()) / (float)heldItemStack.getMaxDamage();
                l2 = (int)(durability * 255.0f);
                int i1 = 255 - l2 << 16 | l2 << 8;
                int remainingDurability = heldItemStack.getMaxDamage() - heldItemStack.getMetadata() + 1;
                fontrenderer.drawStringWithShadow("" + remainingDurability, x10 + 18, y2 + 4, i1);
            } else {
                int itemCount = 0;
                int stackCount = 0;
                for (int i3 = 0; i3 < this.mc.thePlayer.inventory.getSizeInventory(); ++i3) {
                    ItemStack itemStack = this.mc.thePlayer.inventory.getStackInSlot(i3);
                    if (itemStack == null || itemStack.itemID != heldItemStack.itemID || itemStack.getMetadata() != heldItemStack.getMetadata()) continue;
                    itemCount += itemStack.stackSize;
                    ++stackCount;
                }
                boolean bl3 = renderItem = stackCount >= 1;
                if (renderItem) {
                    fontrenderer.drawStringWithShadow("" + itemCount, x10 + 18, y2 + 4, 0xFFFFFF);
                }
            }
            if (renderItem) {
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                GL11.glPushMatrix();
                GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderHelper.enableStandardItemLighting();
                GL11.glPopMatrix();
                itemRenderer.renderItemIntoGUI(fontrenderer, this.mc.renderEngine, heldItemStack, x10, y2, 1.0f);
                RenderHelper.disableStandardItemLighting();
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawChat()) {
            this.drawChat(width, height, sp2);
        }
    }

    private void drawDebugScreenLine(String string, boolean right, int line, int offset) {
        int width = this.fontrenderer.getStringWidth(string);
        int height = this.debugLineHeight;
        int x2 = right ? this.mc.resolution.scaledWidth - width - 2 : 2;
        int y2 = 3 + line * this.debugLineHeight + offset;
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.drawRectangle(x2 - 1, y2 - 1, width + 2, height);
        tessellator.draw();
        GL11.glEnable((int)3553);
        this.fontrenderer.drawString(string, x2, y2, 0xFFFFFF);
    }

    private void drawDebugScreenLine(String string) {
        this.drawDebugScreenLine(string, false, this.debugLine++, this.debugOffset);
    }

    private void drawDebugScreenLineRight(String string) {
        this.drawDebugScreenLine(string, true, this.debugLineRight++, this.debugOffsetRight);
    }

    public void drawPlayerList(int screenWidth, int screenHeight, int screenPadding) {
        if (!this.mc.isMultiplayerWorld()) {
            return;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            this.mc.gameSettings.showPlayerList.value = this.mc.gameSettings.keyPlayerList.isPressed() && this.mc.currentScreen == null;
        }
        if (!((Boolean)this.mc.gameSettings.showPlayerList.value).booleanValue()) {
            return;
        }
        if (!(this.mc.thePlayer instanceof EntityClientPlayerMP)) {
            return;
        }
        EntityClientPlayerMP player = (EntityClientPlayerMP)this.mc.thePlayer;
        List<PlayerProfile> players = player.sendQueue.players;
        int longestNameWidth = 0;
        int longestScoreWidth = 0;
        this.playerListScoreStrings.clear();
        for (int i2 = 0; i2 < players.size(); ++i2) {
            PlayerProfile playerProfile = players.get(i2);
            longestNameWidth = Math.max(this.fontrenderer.getStringWidth(playerProfile.getDisplayName()), longestNameWidth);
            String scoreString = "" + playerProfile.scoreTotal;
            longestScoreWidth = Math.max(this.fontrenderer.getStringWidth(scoreString), longestScoreWidth);
            this.playerListScoreStrings.add(scoreString);
        }
        int nameScoreSpace = 4;
        int lineHeight = 8;
        int outerPadding = 6;
        int innerPadding = 3;
        int columnWidth = longestNameWidth + longestScoreWidth + 4;
        int columns = (int)Math.ceil((float)players.size() / 8.0f);
        int rows = (int)Math.ceil((float)players.size() / (float)columns) + 1;
        int width = columns * columnWidth + 3 * (columns - 1) + 12;
        int height = rows * 8 + 3 * (rows - 1) + 12;
        int listX = 0;
        int listY = screenPadding;
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 0) {
            listX = (screenWidth - width) / 2;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            listX = (screenWidth - width) / 2;
            listY = screenHeight / 6 + screenPadding;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 2) {
            listX = screenWidth - width - screenPadding;
        }
        this.drawRect(listX, listY, listX + width, listY + height, -1475868664);
        this.fontrenderer.drawCenteredString("Players: ", listX + width / 2, listY + 6, 0xFFFFFF);
        for (int i3 = 0; i3 < players.size(); ++i3) {
            int x2 = i3 % columns;
            int y2 = i3 / columns + 1;
            int posX = listX + x2 * columnWidth + x2 * 3 + 6;
            int posY = listY + y2 * 8 + y2 * 3 + 6;
            PlayerProfile playerProfile = players.get(i3);
            this.fontrenderer.drawStringWithShadow(playerProfile.getDisplayName(), posX, posY, 0xFFFFFF);
            String scoreString = this.playerListScoreStrings.get(i3);
            int scoreStringWidth = this.fontrenderer.getStringWidth(scoreString);
            this.fontrenderer.drawStringWithShadow(ChatColor.yellow + scoreString, posX + columnWidth - scoreStringWidth, posY, 0xFFFFFF);
        }
    }

    public void drawRecordPlayingOverlay(int width, int height, float partialTicks) {
        if (this.recordPlayingUpFor > 0) {
            float f2 = (float)this.recordPlayingUpFor - partialTicks;
            int j3 = (int)(f2 * 256.0f / 20.0f);
            if (j3 > 255) {
                j3 = 255;
            }
            if (j3 > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)width / 2.0f), (float)(height - 48), (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int k4 = 0xFFFFFF;
                if (this.field_22065_l) {
                    k4 = Color.HSBtoRGB(f2 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                }
                this.fontrenderer.drawString(this.recordPlaying, -this.fontrenderer.getStringWidth(this.recordPlaying) / 2, -4, k4 + (j3 << 24));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    public void drawChat(int width, int height, int sp2) {
        int byte0 = 10;
        boolean flag2 = false;
        if (this.mc.currentScreen instanceof GuiChat) {
            byte0 = 20;
            flag2 = true;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(height - 48), (float)0.0f);
        for (int i5 = 0; i5 < this.chatMessageList.size() && i5 < byte0; ++i5) {
            if (this.chatMessageList.get((int)i5).updateCounter >= 200 && !flag2) continue;
            double d2 = (double)this.chatMessageList.get((int)i5).updateCounter / 200.0;
            d2 = 1.0 - d2;
            if ((d2 *= 10.0) < 0.0) {
                d2 = 0.0;
            }
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            d2 *= d2;
            int j6 = (int)(255.0 * d2);
            if (flag2) {
                j6 = 255;
            }
            if (j6 <= 0) continue;
            int byte1 = 2;
            int k6 = -i5 * 9;
            String s1 = this.chatMessageList.get((int)i5).message;
            this.drawRect(byte1, k6 - 1 - sp2, byte1 + 320, k6 + 8 - sp2, j6 / 2 << 24);
            GL11.glEnable((int)3042);
            this.mc.fontRenderer.drawStringWithShadow(s1, byte1, k6 - sp2, 0xFFFFFF + (j6 << 24));
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void drawRotationOverlay(int width, int height, int sp2) {
        int x2 = 0;
        int y2 = 0;
        if ((Integer)this.mc.gameSettings.rotationOverlayMode.value / 2 == 0) {
            x2 = width / 2 - 92 - 32;
            y2 = height - 20 - sp2;
        }
        if ((Integer)this.mc.gameSettings.rotationOverlayMode.value / 2 == 1) {
            x2 = width / 2 - 7 + 16;
            y2 = height / 2 - 7;
        }
        int u2 = (Integer)this.mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? 16 : 0;
        int v2 = 160;
        EntityPlayerSP player = this.mc.thePlayer;
        if (player.rotationLock != null) {
            boolean facingUp = player.rotationPitch < -45.0f;
            boolean facingDown = player.rotationPitch > 45.0f;
            Direction dir = Direction.getDirection(player);
            if (dir.isHorizontal()) {
                dir = dir.rotate(-Direction.getHorizontalDirection((double)((double)player.rotationYaw)).rotate((int)2).index);
                if (facingUp) {
                    if (dir == Direction.SOUTH) {
                        dir = Direction.UP;
                    }
                    if (dir == Direction.NORTH) {
                        dir = Direction.DOWN;
                    }
                }
                if (facingDown) {
                    if (dir == Direction.SOUTH) {
                        dir = Direction.DOWN;
                    }
                    if (dir == Direction.NORTH) {
                        dir = Direction.UP;
                    }
                }
            } else if (dir == Direction.UP) {
                dir = Direction.DOWN;
                if (facingUp) {
                    dir = Direction.SOUTH;
                } else if (facingDown) {
                    dir = Direction.NORTH;
                }
            } else if (dir == Direction.DOWN) {
                dir = Direction.UP;
                if (facingDown) {
                    dir = Direction.SOUTH;
                } else if (facingUp) {
                    dir = Direction.NORTH;
                }
            }
            this.drawTexturedModalRect(x2, y2, u2, v2 + dir.index * 16, 16, 16);
            dir = Direction.getVerticalDirection(player);
            this.drawTexturedModalRect(x2 + 16, y2 + 4, u2 + (dir.index - 4) * 8, v2 - 8, 8, 8);
        }
    }

    public String getTimeString() {
        long worldTime = this.mc.theWorld.getWorldTime();
        int dayLength = net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
        int dayTime = (int)(worldTime % (long)dayLength);
        int hourLength = dayLength / 24;
        int hour = dayTime / hourLength;
        hour = (hour + 6) % 24;
        double hp2 = (double)(dayTime % hourLength) / (double)hourLength;
        int minute = (int)(hp2 * 60.0);
        return hour + ":" + GuiIngame.addZero(minute);
    }

    public static String addZero(int i2) {
        if (i2 < 10) {
            return "0" + i2;
        }
        return "" + i2;
    }

    private void renderPumpkinBlur(int i2, int j2) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("%blur%/misc/pumpkinblur.png"));
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j2, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(i2, j2, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(i2, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderVignette(float f2, int i2, int j2) {
        if ((f2 = 1.0f - f2) < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.prevVignetteBrightness = (float)((double)this.prevVignetteBrightness + (double)(f2 - this.prevVignetteBrightness) * 0.01);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)0, (int)769);
        GL11.glColor4f((float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("%blur%/misc/vignette.png"));
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j2, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(i2, j2, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(i2, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void renderPortalOverlay(float f2, int i2, int j2) {
        if (f2 < 1.0f) {
            f2 *= f2;
            f2 *= f2;
            f2 = f2 * 0.8f + 0.2f;
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f2);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
        float f1 = (float)(Block.texCoordToIndex(14, 0) % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) / (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f22 = (float)(Block.texCoordToIndex(14, 0) / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) / (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f3 = (float)(Block.texCoordToIndex(14, 0) % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES + 1) / (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        float f4 = (float)(Block.texCoordToIndex(14, 0) / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES + 1) / (float)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j2, -90.0, f1, f4);
        tessellator.addVertexWithUV(i2, j2, -90.0, f3, f4);
        tessellator.addVertexWithUV(i2, 0.0, -90.0, f3, f22);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, f1, f22);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderInventorySlot(int itemIndex, int x2, int y2, float delta, float alpha) {
        ItemStack itemstack = this.mc.thePlayer.inventory.mainInventory[itemIndex];
        if (itemstack == null) {
            return;
        }
        float animProgress = (float)itemstack.animationsToGo - delta;
        if (animProgress > 0.0f) {
            GL11.glPushMatrix();
            float f2 = 1.0f + animProgress / 5.0f;
            GL11.glTranslatef((float)(x2 + 8), (float)(y2 + 12), (float)0.0f);
            GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
            GL11.glTranslatef((float)(-(x2 + 8)), (float)(-(y2 + 12)), (float)0.0f);
        }
        itemRenderer.renderItemIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, itemstack, x2, y2, alpha);
        if (animProgress > 0.0f) {
            GL11.glPopMatrix();
        }
        itemRenderer.renderItemOverlayIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, itemstack, x2, y2, alpha);
    }

    public void updateTick() {
        if (this.recordPlayingUpFor > 0) {
            --this.recordPlayingUpFor;
        }
        ++this.updateCounter;
        for (int i2 = 0; i2 < this.chatMessageList.size(); ++i2) {
            ++this.chatMessageList.get((int)i2).updateCounter;
        }
    }

    public void clearChatMessages() {
        this.chatMessageList.clear();
    }

    public void addChatMessage(String s2) {
        System.out.println("[CHAT] " + s2);
        while (this.mc.fontRenderer.getStringWidth(s2) > 320) {
            int i2;
            for (i2 = 1; i2 < s2.length() && this.mc.fontRenderer.getStringWidth(s2.substring(0, i2 + 1)) <= 320; ++i2) {
            }
            this.addChatMessage(s2.substring(0, i2));
            s2 = s2.substring(i2);
        }
        this.chatMessageList.add(0, new ChatLine(s2));
        while (this.chatMessageList.size() > 50) {
            this.chatMessageList.remove(this.chatMessageList.size() - 1);
        }
    }

    public void setRecordPlayingMessage(String s2) {
        this.recordPlaying = "Now playing: " + s2;
        this.recordPlayingUpFor = 60;
        this.field_22065_l = true;
    }

    public void addChatMessageTranslate(String s2) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        String s1 = stringtranslate.translateKey(s2);
        this.addChatMessage(s1);
    }

    public static String getFacingDirection(EntityPlayer player) {
        return directions[MathHelper.floor_double((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5) + 2 & 3];
    }
}

