/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiOptionsButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.StringTranslate;

public class GuiKeybinds
extends GuiScreen {
    protected String screenTitle;
    private final GameSettings options;
    private int buttonId;
    private GuiButton nextPageButton;
    private GuiButton lastPageButton;
    private int page = 0;
    private final int settingsPerPage = 12;
    private int pages;
    private int settingsInPage = 12;
    private String info;

    public GuiKeybinds(GuiScreen guiscreen, GameSettings gamesettings) {
        super(guiscreen);
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = "Controls";
        this.buttonId = -1;
        this.options = gamesettings;
        int l2 = this.options.keys.length;
        this.pages = l2 / 12;
        if (l2 % 12 > 0) {
            ++this.pages;
        }
        this.screenTitle = stringtranslate.translateKey("keybinds.title");
        this.info = stringtranslate.translateKey("keybinds.info");
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        boolean pageUpdated = false;
        if (guibutton.id == 200) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (guibutton == this.nextPageButton) {
            if (this.page + 1 < this.pages) {
                ++this.page;
            }
            if (this.page + 1 == this.pages) {
                this.nextPageButton.enabled = false;
            }
            if (this.page > 0) {
                this.lastPageButton.enabled = true;
            }
            pageUpdated = true;
        } else if (guibutton == this.lastPageButton) {
            if (this.page > 0) {
                --this.page;
            }
            if (this.page == 0) {
                this.lastPageButton.enabled = false;
            }
            if (this.page + 1 < this.pages) {
                this.nextPageButton.enabled = true;
            }
            pageUpdated = true;
        } else {
            this.buttonId = guibutton.id;
            guibutton.displayString = "> " + this.options.getKeyName(this.buttonId) + " <";
        }
        if (this.page == this.pages - 1) {
            this.settingsInPage = this.options.keys.length % 12;
            if (this.settingsInPage == 0) {
                this.settingsInPage = 12;
            }
        } else {
            this.settingsInPage = 12;
        }
        if (pageUpdated) {
            GuiButton button;
            int i2;
            for (i2 = 0; i2 < this.settingsInPage; ++i2) {
                button = (GuiButton)this.controlList.get(i2);
                button.enabled = true;
                button.id = this.page * 12 + i2;
                button.displayString = this.options.getKeyName(button.id);
            }
            for (i2 = this.settingsInPage; i2 < 12; ++i2) {
                button = (GuiButton)this.controlList.get(i2);
                button.enabled = false;
                button.id = this.page * 12 + i2;
                button.displayString = "";
            }
        }
    }

    @Override
    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, this.info, this.width / 2, 30, 0x808080);
        int k2 = this.func_20080_j();
        for (int l2 = 0; l2 < this.settingsInPage; ++l2) {
            this.drawString(this.fontRenderer, this.options.getKeyBindName(12 * this.page + l2), k2 + l2 % 2 * 160 + 70 + 6, this.height / 6 + 24 * (l2 >> 1) + 7, -1);
        }
        super.drawScreen(x2, y2, renderPartialTicks);
    }

    private int func_20080_j() {
        return this.width / 2 - 155;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        int i2 = this.func_20080_j();
        for (int j2 = 0; j2 < this.settingsInPage; ++j2) {
            this.controlList.add(new GuiOptionsButton(12 * this.page + j2, i2 + j2 % 2 * 160, this.height / 6 + 24 * (j2 >> 1), 70, 20, this.options.getKeyName(12 * this.page + j2)));
        }
        this.controlList.add(new GuiButton(200, this.width / 2 - 68, this.height / 6 + 168, 136, 20, stringtranslate.translateKey("gui.done")));
        this.nextPageButton = new GuiButton(201, this.width / 2 - 68 + 136 + 2, this.height / 6 + 168, 30, 20, ">");
        this.lastPageButton = new GuiButton(202, this.width / 2 - 68 - 30 - 2, this.height / 6 + 168, 30, 20, "<");
        this.controlList.add(this.nextPageButton);
        this.controlList.add(this.lastPageButton);
        this.screenTitle = stringtranslate.translateKey("controls.title");
        if (this.page == 0) {
            this.lastPageButton.enabled = false;
        }
        if (this.page + 1 == this.pages) {
            this.nextPageButton.enabled = false;
        }
    }

    @Override
    public void keyTyped(char c2, int i2) {
        if (this.buttonId >= 0) {
            if (i2 == 1) {
                i2 = -1;
            }
            this.options.getKey(this.buttonId).setKeyCode(i2);
            GuiButton button = null;
            for (int q2 = 0; q2 < this.controlList.size(); ++q2) {
                if (((GuiButton)this.controlList.get((int)q2)).id != this.buttonId) continue;
                button = (GuiButton)this.controlList.get(q2);
            }
            button.displayString = this.options.getKeyName(this.buttonId);
            this.buttonId = -1;
        } else {
            super.keyTyped(c2, i2);
        }
    }
}

